/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaMockingUtil;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MockRegionServer;
import org.apache.hadoop.hbase.master.Mocking;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestMasterNoCluster {
    private static final Log LOG = LogFactory.getLog(TestMasterNoCluster.class);
    private static final HBaseTestingUtility TESTUTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration c = TESTUTIL.getConfiguration();
        FSUtils.setRootDir((Configuration)c, (Path)TESTUTIL.getDataTestDir());
        TESTUTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TESTUTIL.shutdownMiniZKCluster();
    }

    @After
    public void tearDown() throws KeeperException, ZooKeeperConnectionException, IOException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TESTUTIL.getConfiguration(), "@Before", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException(why, e);
            }

            public boolean isAborted() {
                return false;
            }
        });
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)zkw.baseZNode);
        zkw.close();
    }

    @Test(timeout=30000L)
    public void testStopDuringStart() throws IOException, KeeperException, InterruptedException {
        HMaster master = new HMaster(TESTUTIL.getConfiguration());
        master.start();
        master.stopMaster();
        master.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testFailover() throws IOException, KeeperException, InterruptedException, ServiceException {
        long now = System.currentTimeMillis();
        ServerName sn0 = new ServerName("0.example.org", 0, now);
        ServerName sn1 = new ServerName("1.example.org", 1, now);
        ServerName sn2 = new ServerName("2.example.org", 2, now);
        final ServerName[] sns = new ServerName[]{sn0, sn1, sn2};
        Configuration conf = TESTUTIL.getConfiguration();
        final MockRegionServer rs0 = new MockRegionServer(conf, sn0);
        MockRegionServer rs1 = new MockRegionServer(conf, sn1);
        MockRegionServer rs2 = new MockRegionServer(conf, sn2);
        MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)rs0.getZooKeeper(), (ServerName)rs0.getServerName());
        TableName tableName = TableName.valueOf((String)"t");
        Result[] results = new Result[]{MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HBaseTestingUtility.KEYS[1]), rs2.getServerName()), MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HBaseTestingUtility.KEYS[1], HBaseTestingUtility.KEYS[2]), rs2.getServerName()), MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HBaseTestingUtility.KEYS[2], HConstants.EMPTY_END_ROW), rs2.getServerName())};
        rs1.setNextResults(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), results);
        HMaster master = new HMaster(conf){

            InetAddress getRemoteInetAddress(int port, long serverStartCode) throws UnknownHostException {
                ServerName sn = sns[port];
                return InetAddress.getByAddress(sn.getHostname(), new byte[]{10, 0, 0, (byte)sn.getPort()});
            }

            ServerManager createServerManager(Server master, MasterServices services) throws IOException {
                ServerManager sm = super.createServerManager(master, services);
                ServerManager spy = (ServerManager)Mockito.spy((Object)sm);
                ((ServerManager)Mockito.doReturn((Object)RegionOpeningState.OPENED).when((Object)spy)).sendRegionOpen((ServerName)Mockito.any(), (HRegionInfo)Mockito.any(), Mockito.anyInt(), Mockito.anyListOf(ServerName.class));
                return spy;
            }

            CatalogTracker createCatalogTracker(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) throws IOException {
                HConnection connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(TESTUTIL.getConfiguration(), rs0, rs0, rs0.getServerName(), HRegionInfo.FIRST_META_REGIONINFO);
                return new CatalogTracker(zk, conf, connection, abortable);
            }

            void initNamespace() {
            }
        };
        master.start();
        try {
            while (!master.isRpcServerOpen()) {
                Threads.sleep((long)10L);
            }
            for (int i = 0; i < sns.length; ++i) {
                RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
                ServerName sn = ServerName.parseVersionedServerName((byte[])sns[i].getVersionedBytes());
                request.setServer(ProtobufUtil.toServerName((ServerName)sn));
                request.setLoad(ServerLoad.EMPTY_SERVERLOAD.obtainServerLoadPB());
                master.regionServerReport(null, request.build());
            }
            while (!master.isInitialized()) {
                Threads.sleep((long)10L);
            }
            Assert.assertTrue((boolean)master.isInitialized());
        }
        finally {
            rs0.stop("Test is done");
            rs1.stop("Test is done");
            rs2.stop("Test is done");
            master.stopMaster();
            master.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCatalogDeploys() throws Exception {
        Configuration conf = TESTUTIL.getConfiguration();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        conf.setInt("hbase.master.wait.on.regionservers.maxtostart", 1);
        long now = System.currentTimeMillis();
        ServerName sn = new ServerName("0.example.org", 0, now);
        final MockRegionServer rs0 = new MockRegionServer(conf, sn);
        HMaster master = new HMaster(conf){

            InetAddress getRemoteInetAddress(int port, long serverStartCode) throws UnknownHostException {
                return InetAddress.getByAddress(rs0.getServerName().getHostname(), new byte[]{10, 0, 0, 0});
            }

            ServerManager createServerManager(Server master, MasterServices services) throws IOException {
                ServerManager sm = super.createServerManager(master, services);
                ServerManager spy = (ServerManager)Mockito.spy((Object)sm);
                ((ServerManager)Mockito.doReturn((Object)RegionOpeningState.OPENED).when((Object)spy)).sendRegionOpen((ServerName)Mockito.any(), (HRegionInfo)Mockito.any(), Mockito.anyInt(), Mockito.anyListOf(ServerName.class));
                return spy;
            }

            CatalogTracker createCatalogTracker(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) throws IOException {
                HConnection connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(TESTUTIL.getConfiguration(), rs0, rs0, rs0.getServerName(), HRegionInfo.FIRST_META_REGIONINFO);
                return new CatalogTracker(zk, conf, connection, abortable);
            }

            void initNamespace() {
            }
        };
        master.start();
        LOG.info((Object)"Master has started");
        try {
            while (!master.isRpcServerOpen()) {
                Threads.sleep((long)10L);
            }
            LOG.info((Object)"RpcServerOpen has started");
            RegionServerStatusProtos.RegionServerStartupRequest.Builder request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
            request.setPort(rs0.getServerName().getPort());
            request.setServerStartCode(rs0.getServerName().getStartcode());
            request.setServerCurrentTime(now);
            RegionServerStatusProtos.RegionServerStartupResponse result = master.regionServerStartup(null, request.build());
            String rshostname = new String();
            for (HBaseProtos.NameStringPair e : result.getMapEntriesList()) {
                if (!e.getName().toString().equals("hbase.regionserver.hostname.seen.by.master")) continue;
                rshostname = e.getValue();
            }
            Assert.assertEquals((Object)rs0.getServerName().getHostname(), (Object)rshostname);
            Mocking.fakeRegionServerRegionOpenInZK(master, rs0.getZooKeeper(), rs0.getServerName(), HRegionInfo.FIRST_META_REGIONINFO);
            LOG.info((Object)"fakeRegionServerRegionOpenInZK has started");
            MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)rs0.getZooKeeper(), (ServerName)rs0.getServerName());
            while (!master.isInitialized()) {
                Threads.sleep((long)10L);
            }
            Assert.assertTrue((boolean)master.isInitialized());
        }
        finally {
            rs0.stop("Test is done");
            master.stopMaster();
            master.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotPullingDeadRegionServerFromZK() throws IOException, KeeperException, InterruptedException {
        Configuration conf = TESTUTIL.getConfiguration();
        final ServerName newServer = new ServerName("test.sample", 1, 101L);
        final ServerName deadServer = new ServerName("test.sample", 1, 100L);
        final MockRegionServer rs0 = new MockRegionServer(conf, newServer);
        HMaster master = new HMaster(conf){

            void assignMeta(MonitoredTask status) {
            }

            void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException {
                super.initializeZKBasedSystemTrackers();
                this.serverManager.recordNewServer(newServer, ServerLoad.EMPTY_SERVERLOAD);
                ArrayList<ServerName> onlineServers = new ArrayList<ServerName>();
                onlineServers.add(deadServer);
                onlineServers.add(newServer);
                this.regionServerTracker = (RegionServerTracker)Mockito.spy((Object)this.regionServerTracker);
                ((RegionServerTracker)Mockito.doReturn(onlineServers).when((Object)this.regionServerTracker)).getOnlineServers();
            }

            CatalogTracker createCatalogTracker(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) throws IOException {
                HConnection connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(TESTUTIL.getConfiguration(), rs0, rs0, rs0.getServerName(), HRegionInfo.FIRST_META_REGIONINFO);
                return new CatalogTracker(zk, conf, connection, abortable);
            }

            void initNamespace() {
            }
        };
        master.start();
        try {
            while (!master.initialized) {
                Threads.sleep((long)10L);
            }
            LOG.info((Object)"Master is initialized");
            Assert.assertFalse((String)"The dead server should not be pulled in", (boolean)master.serverManager.isServerOnline(deadServer));
        }
        finally {
            master.stopMaster();
            master.join();
        }
    }
}

