/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.SimpleTotalOrderPartitioner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSimpleTotalOrderPartitioner
extends HBaseTestCase {
    public void testSplit() throws Exception {
        String start = "a";
        String end = "{";
        SimpleTotalOrderPartitioner p = new SimpleTotalOrderPartitioner();
        this.conf.set("hbase.simpletotalorder.start", start);
        this.conf.set("hbase.simpletotalorder.end", end);
        p.setConf(this.conf);
        ImmutableBytesWritable c = new ImmutableBytesWritable(Bytes.toBytes((String)"c"));
        int partition = p.getPartition(c, (Object)HConstants.EMPTY_BYTE_ARRAY, 1);
        TestSimpleTotalOrderPartitioner.assertEquals((int)0, (int)partition);
        partition = p.getPartition(c, (Object)HConstants.EMPTY_BYTE_ARRAY, 2);
        TestSimpleTotalOrderPartitioner.assertEquals((int)0, (int)partition);
        partition = p.getPartition(c, (Object)HConstants.EMPTY_BYTE_ARRAY, 3);
        TestSimpleTotalOrderPartitioner.assertEquals((int)0, (int)partition);
        ImmutableBytesWritable q = new ImmutableBytesWritable(Bytes.toBytes((String)"q"));
        partition = p.getPartition(q, (Object)HConstants.EMPTY_BYTE_ARRAY, 2);
        TestSimpleTotalOrderPartitioner.assertEquals((int)1, (int)partition);
        partition = p.getPartition(q, (Object)HConstants.EMPTY_BYTE_ARRAY, 3);
        TestSimpleTotalOrderPartitioner.assertEquals((int)2, (int)partition);
        ImmutableBytesWritable startBytes = new ImmutableBytesWritable(Bytes.toBytes((String)start));
        partition = p.getPartition(startBytes, (Object)HConstants.EMPTY_BYTE_ARRAY, 2);
        TestSimpleTotalOrderPartitioner.assertEquals((int)0, (int)partition);
        partition = p.getPartition(startBytes, (Object)HConstants.EMPTY_BYTE_ARRAY, 3);
        TestSimpleTotalOrderPartitioner.assertEquals((int)0, (int)partition);
        ImmutableBytesWritable endBytes = new ImmutableBytesWritable(Bytes.toBytes((String)"z"));
        partition = p.getPartition(endBytes, (Object)HConstants.EMPTY_BYTE_ARRAY, 2);
        TestSimpleTotalOrderPartitioner.assertEquals((int)1, (int)partition);
        partition = p.getPartition(endBytes, (Object)HConstants.EMPTY_BYTE_ARRAY, 3);
        TestSimpleTotalOrderPartitioner.assertEquals((int)2, (int)partition);
    }
}

