/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestImportTsvParser {
    private void assertBytesEquals(byte[] a, byte[] b) {
        Assert.assertEquals((Object)Bytes.toStringBinary((byte[])a), (Object)Bytes.toStringBinary((byte[])b));
    }

    private void checkParsing(ImportTsv.TsvParser.ParsedLine parsed, Iterable<String> expected) {
        ArrayList<String> parsedCols = new ArrayList<String>();
        for (int i = 0; i < parsed.getColumnCount(); ++i) {
            parsedCols.add(Bytes.toString((byte[])parsed.getLineBytes(), (int)parsed.getColumnOffset(i), (int)parsed.getColumnLength(i)));
        }
        if (!Iterables.elementsEqual(parsedCols, expected)) {
            Assert.fail((String)("Expected: " + Joiner.on((String)",").join(expected) + "\n" + "Got:" + Joiner.on((String)",").join(parsedCols)));
        }
    }

    @Test
    public void testTsvParserSpecParsing() {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertFalse((boolean)parser.hasTimestamp());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertFalse((boolean)parser.hasTimestamp());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1,col1:scol2", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(2));
        this.assertBytesEquals(Bytes.toBytes((String)"scol2"), parser.getQualifier(2));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertFalse((boolean)parser.hasTimestamp());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1,HBASE_TS_KEY,col1:scol2", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(3));
        this.assertBytesEquals(Bytes.toBytes((String)"scol2"), parser.getQualifier(3));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertTrue((boolean)parser.hasTimestamp());
        Assert.assertEquals((long)2L, (long)parser.getTimestampKeyColumnIndex());
    }

    @Test
    public void testTsvParser() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("col_a,col_b:qual,HBASE_ROW_KEY,col_d", "\t");
        this.assertBytesEquals(Bytes.toBytes((String)"col_a"), parser.getFamily(0));
        this.assertBytesEquals(HConstants.EMPTY_BYTE_ARRAY, parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col_b"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"qual"), parser.getQualifier(1));
        Assert.assertNull((Object)parser.getFamily(2));
        Assert.assertNull((Object)parser.getQualifier(2));
        Assert.assertEquals((long)2L, (long)parser.getRowKeyColumnIndex());
        Assert.assertEquals((long)-1L, (long)parser.getTimestampKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"val_a\tval_b\tval_c\tval_d");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
        this.checkParsing(parsed, Splitter.on((String)"\t").split((CharSequence)Bytes.toString((byte[])line)));
    }

    @Test
    public void testTsvParserWithTimestamp() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,HBASE_TS_KEY,col_a,", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        Assert.assertNull((Object)parser.getFamily(1));
        Assert.assertNull((Object)parser.getQualifier(1));
        this.assertBytesEquals(Bytes.toBytes((String)"col_a"), parser.getFamily(2));
        this.assertBytesEquals(HConstants.EMPTY_BYTE_ARRAY, parser.getQualifier(2));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        Assert.assertEquals((long)1L, (long)parser.getTimestampKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"rowkey\t1234\tval_a");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
        Assert.assertEquals((long)1234L, (long)parsed.getTimestamp(-1L));
        this.checkParsing(parsed, Splitter.on((String)"\t").split((CharSequence)Bytes.toString((byte[])line)));
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineExcessiveColumns() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"val_a\tval_b\tval_c");
        parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineZeroColumn() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"");
        parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineOnlyKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"key_only");
        parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineNoRowKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("col_a,HBASE_ROW_KEY", "\t");
        byte[] line = Bytes.toBytes((String)"only_cola_data_and_no_row_key");
        parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserInvalidTimestamp() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,HBASE_TS_KEY,col_a,", "\t");
        Assert.assertEquals((long)1L, (long)parser.getTimestampKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"rowkey\ttimestamp\tval_a");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
        Assert.assertEquals((long)-1L, (long)parsed.getTimestamp(-1L));
        this.checkParsing(parsed, Splitter.on((String)"\t").split((CharSequence)Bytes.toString((byte[])line)));
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserNoTimestampValue() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a,HBASE_TS_KEY", "\t");
        Assert.assertEquals((long)2L, (long)parser.getTimestampKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"rowkey\tval_a");
        parser.parse(line, line.length);
    }

    @Test
    public void testTsvParserParseRowKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a,HBASE_TS_KEY", "\t");
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"rowkey\tval_a\t1234");
        Pair rowKeyOffsets = parser.parseRowKey(line, line.length);
        Assert.assertEquals((long)0L, (long)((Integer)rowKeyOffsets.getFirst()).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)rowKeyOffsets.getSecond()).intValue());
        try {
            line = Bytes.toBytes((String)"\t\tval_a\t1234");
            parser.parseRowKey(line, line.length);
            Assert.fail((String)"Should get BadTsvLineException on empty rowkey.");
        }
        catch (ImportTsv.TsvParser.BadTsvLineException b) {
            // empty catch block
        }
        parser = new ImportTsv.TsvParser("col_a,HBASE_ROW_KEY,HBASE_TS_KEY", "\t");
        Assert.assertEquals((long)1L, (long)parser.getRowKeyColumnIndex());
        line = Bytes.toBytes((String)"val_a\trowkey\t1234");
        rowKeyOffsets = parser.parseRowKey(line, line.length);
        Assert.assertEquals((long)6L, (long)((Integer)rowKeyOffsets.getFirst()).intValue());
        Assert.assertEquals((long)11L, (long)((Integer)rowKeyOffsets.getSecond()).intValue());
        try {
            line = Bytes.toBytes((String)"val_a");
            rowKeyOffsets = parser.parseRowKey(line, line.length);
            Assert.fail((String)"Should get BadTsvLineException when number of columns less than rowkey position.");
        }
        catch (ImportTsv.TsvParser.BadTsvLineException b) {
            // empty catch block
        }
        parser = new ImportTsv.TsvParser("col_a,HBASE_TS_KEY,HBASE_ROW_KEY", "\t");
        Assert.assertEquals((long)2L, (long)parser.getRowKeyColumnIndex());
        line = Bytes.toBytes((String)"val_a\t1234\trowkey");
        rowKeyOffsets = parser.parseRowKey(line, line.length);
        Assert.assertEquals((long)11L, (long)((Integer)rowKeyOffsets.getFirst()).intValue());
        Assert.assertEquals((long)16L, (long)((Integer)rowKeyOffsets.getSecond()).intValue());
    }
}

