/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestCopyTable {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;

    @BeforeClass
    public static void beforeClass() throws Exception {
        cluster = TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCopyTable() throws Exception {
        byte[] TABLENAME1 = Bytes.toBytes((String)"testCopyTable1");
        byte[] TABLENAME2 = Bytes.toBytes((String)"testCopyTable2");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        HTable t1 = TEST_UTIL.createTable(TABLENAME1, FAMILY);
        HTable t2 = TEST_UTIL.createTable(TABLENAME2, FAMILY);
        for (int i = 0; i < 10; ++i) {
            Put p = new Put(Bytes.toBytes((String)("row" + i)));
            p.add(FAMILY, COLUMN1, COLUMN1);
            t1.put(p);
        }
        CopyTable copy = new CopyTable(TEST_UTIL.getConfiguration());
        Assert.assertEquals((long)0L, (long)copy.run(new String[]{"--new.name=" + Bytes.toString((byte[])TABLENAME2), Bytes.toString((byte[])TABLENAME1)}));
        for (int i = 0; i < 10; ++i) {
            Get g = new Get(Bytes.toBytes((String)("row" + i)));
            Result r = t2.get(g);
            Assert.assertEquals((long)1L, (long)r.size());
            Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN1));
        }
        t1.close();
        t2.close();
        TEST_UTIL.deleteTable(TABLENAME1);
        TEST_UTIL.deleteTable(TABLENAME2);
    }

    @Test
    public void testStartStopRow() throws Exception {
        byte[] TABLENAME1 = Bytes.toBytes((String)"testStartStopRow1");
        byte[] TABLENAME2 = Bytes.toBytes((String)"testStartStopRow2");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        byte[] ROW0 = Bytes.toBytes((String)"row0");
        byte[] ROW1 = Bytes.toBytes((String)"row1");
        byte[] ROW2 = Bytes.toBytes((String)"row2");
        HTable t1 = TEST_UTIL.createTable(TABLENAME1, FAMILY);
        HTable t2 = TEST_UTIL.createTable(TABLENAME2, FAMILY);
        Put p = new Put(ROW0);
        p.add(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        p = new Put(ROW1);
        p.add(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        p = new Put(ROW2);
        p.add(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        CopyTable copy = new CopyTable(TEST_UTIL.getConfiguration());
        Assert.assertEquals((long)0L, (long)copy.run(new String[]{"--new.name=" + Bytes.toString((byte[])TABLENAME2), "--startrow=row1", "--stoprow=row2", Bytes.toString((byte[])TABLENAME1)}));
        Get g = new Get(ROW1);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN1));
        g = new Get(ROW0);
        r = t2.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        g = new Get(ROW2);
        r = t2.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        t1.close();
        t2.close();
        TEST_UTIL.deleteTable(TABLENAME1);
        TEST_UTIL.deleteTable(TABLENAME2);
    }
}

