/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.ChecksumUtil;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.TestHFileBlock;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestChecksum {
    private static final boolean detailedLogging = true;
    private static final boolean[] BOOLEAN_VALUES = new boolean[]{false, true};
    private static final Log LOG = LogFactory.getLog(TestHFileBlock.class);
    static final Compression.Algorithm[] COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
    static final int[] BYTES_PER_CHECKSUM = new int[]{50, 500, 688, 16384, 17364, 65536};
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private FileSystem fs;
    private HFileSystem hfs;

    @Before
    public void setUp() throws Exception {
        this.fs = HFileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        this.hfs = (HFileSystem)this.fs;
    }

    @Test
    public void testChecksumCorruption() throws IOException {
        for (Compression.Algorithm algo : COMPRESSION_ALGORITHMS) {
            for (boolean pread : new boolean[]{false, true}) {
                LOG.info((Object)("testChecksumCorruption: Compression algorithm: " + algo + ", pread=" + pread));
                Path path = new Path(TEST_UTIL.getDataTestDir(), "blocks_v2_" + algo);
                FSDataOutputStream os = this.fs.create(path);
                HFileBlock.Writer hbw = new HFileBlock.Writer(algo, null, true, HFile.DEFAULT_CHECKSUM_TYPE, 16384);
                long totalSize = 0L;
                for (int blockId = 0; blockId < 2; ++blockId) {
                    DataOutputStream dos = hbw.startWriting(BlockType.DATA);
                    for (int i = 0; i < 1234; ++i) {
                        dos.writeInt(i);
                    }
                    hbw.writeHeaderAndData(os);
                    totalSize += (long)hbw.getOnDiskSizeWithHeader();
                }
                os.close();
                Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
                FSDataInputStreamWrapper is = new FSDataInputStreamWrapper(this.fs, path);
                FSReaderV2Test hbr = new FSReaderV2Test(is, algo, totalSize, 2, this.fs, path);
                HFileBlock b = hbr.readBlockData(0L, -1L, -1, pread);
                b.sanityCheck();
                Assert.assertEquals((long)4936L, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)(algo == Compression.Algorithm.GZ ? 2173L : 4936L), (long)(b.getOnDiskSizeWithoutHeader() - b.totalChecksumBytes()));
                ByteBuffer bb = b.getBufferWithoutHeader();
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(bb.array(), bb.arrayOffset(), bb.limit()));
                Assert.assertEquals((long)1L, (long)HFile.getChecksumFailuresCount());
                this.validateData(in);
                for (int i = 0; i < 4; ++i) {
                    b = hbr.readBlockData(0L, -1L, -1, pread);
                    Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
                }
                b = hbr.readBlockData(0L, -1L, -1, pread);
                Assert.assertEquals((long)1L, (long)HFile.getChecksumFailuresCount());
                b = hbr.readBlockData(0L, -1L, -1, pread);
                Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
                is.close();
                HFileSystem newfs = new HFileSystem(TEST_UTIL.getConfiguration(), false);
                Assert.assertEquals((Object)false, (Object)newfs.useHBaseChecksum());
                is = new FSDataInputStreamWrapper((FileSystem)newfs, path);
                hbr = new FSReaderV2Test(is, algo, totalSize, 2, (FileSystem)newfs, path);
                b = hbr.readBlockData(0L, -1L, -1, pread);
                is.close();
                b.sanityCheck();
                Assert.assertEquals((long)4936L, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)(algo == Compression.Algorithm.GZ ? 2173L : 4936L), (long)(b.getOnDiskSizeWithoutHeader() - b.totalChecksumBytes()));
                bb = b.getBufferWithoutHeader();
                in = new DataInputStream(new ByteArrayInputStream(bb.array(), bb.arrayOffset(), bb.limit()));
                Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
                this.validateData(in);
            }
        }
    }

    @Test
    public void testChecksumChunks() throws IOException {
        Compression.Algorithm algo = Compression.Algorithm.NONE;
        for (boolean pread : new boolean[]{false, true}) {
            for (int bytesPerChecksum : BYTES_PER_CHECKSUM) {
                Path path = new Path(TEST_UTIL.getDataTestDir(), "checksumChunk_" + algo + bytesPerChecksum);
                FSDataOutputStream os = this.fs.create(path);
                HFileBlock.Writer hbw = new HFileBlock.Writer(algo, null, true, HFile.DEFAULT_CHECKSUM_TYPE, bytesPerChecksum);
                long dataSize = 0L;
                DataOutputStream dos = hbw.startWriting(BlockType.DATA);
                while (dataSize < (long)(6 * bytesPerChecksum)) {
                    for (int i = 0; i < 1234; ++i) {
                        dos.writeInt(i);
                        dataSize += 4L;
                    }
                }
                hbw.writeHeaderAndData(os);
                long totalSize = hbw.getOnDiskSizeWithHeader();
                os.close();
                long expectedChunks = ChecksumUtil.numChunks((long)(dataSize + 33L), (int)bytesPerChecksum);
                LOG.info((Object)("testChecksumChunks: pread=" + pread + ", bytesPerChecksum=" + bytesPerChecksum + ", fileSize=" + totalSize + ", dataSize=" + dataSize + ", expectedChunks=" + expectedChunks));
                Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
                FSDataInputStream is = this.fs.open(path);
                FSDataInputStream nochecksum = this.hfs.getNoChecksumFs().open(path);
                HFileBlock.FSReaderV2 hbr = new HFileBlock.FSReaderV2(new FSDataInputStreamWrapper(is, nochecksum), algo, totalSize, 2, this.hfs, path);
                HFileBlock b = hbr.readBlockData(0L, -1L, -1, pread);
                is.close();
                b.sanityCheck();
                Assert.assertEquals((long)dataSize, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)totalSize, (long)(33L + dataSize + expectedChunks * 4L));
                Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
            }
        }
    }

    @Test
    public void testChecksumAlgorithm() throws IOException {
        ChecksumType type = ChecksumType.CRC32;
        Assert.assertEquals((Object)ChecksumType.nameToType((String)type.getName()), (Object)type);
        Assert.assertEquals((Object)ChecksumType.valueOf((String)type.toString()), (Object)type);
    }

    private void validateData(DataInputStream in) throws IOException {
        for (int i = 0; i < 1234; ++i) {
            int val = in.readInt();
            if (val == i) continue;
            String msg = "testChecksumCorruption: data mismatch at index " + i + " expected " + i + " found " + val;
            LOG.warn((Object)msg);
            Assert.assertEquals((long)i, (long)val);
        }
    }

    private static class FSReaderV2Test
    extends HFileBlock.FSReaderV2 {
        public FSReaderV2Test(FSDataInputStreamWrapper istream, Compression.Algorithm algo, long fileSize, int minorVersion, FileSystem fs, Path path) throws IOException {
            super(istream, algo, fileSize, minorVersion, (HFileSystem)fs, path);
        }

        protected boolean validateBlockChecksum(HFileBlock block, byte[] data, int hdrSize) throws IOException {
            return false;
        }
    }
}

