/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeCodec;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPrefixTreeEncoding {
    private static final Log LOG = LogFactory.getLog(TestPrefixTreeEncoding.class);
    static final String CF = "EncodingTestCF";
    static final byte[] CF_BYTES = Bytes.toBytes((String)"EncodingTestCF");
    private static final int NUM_ROWS_PER_BATCH = 50;
    private static final int NUM_COLS_PER_ROW = 20;
    private int numBatchesWritten = 0;
    private ConcurrentSkipListSet<KeyValue> kvset = new ConcurrentSkipListSet(KeyValue.COMPARATOR);
    private static boolean formatRowNum = false;

    @Before
    public void setUp() throws Exception {
        this.kvset.clear();
        formatRowNum = false;
    }

    @Test
    public void testSeekBeforeWithFixedData() throws Exception {
        formatRowNum = true;
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        int batchId = this.numBatchesWritten++;
        ByteBuffer dataBuffer = TestPrefixTreeEncoding.generateFixedTestData(this.kvset, batchId, false);
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(Compression.Algorithm.NONE, DataBlockEncoding.PREFIX_TREE, new byte[0]);
        encoder.encodeKeyValues(dataBuffer, false, (HFileBlockEncodingContext)blkEncodingCtx);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, false);
        byte[] onDiskBytes = blkEncodingCtx.getOnDiskBytesWithHeader();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        seeker.setCurrentBuffer(readBuffer);
        KeyValue seekKey = KeyValue.createFirstDeleteFamilyOnRow((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 0), (byte[])CF_BYTES);
        seeker.seekToKeyInBlock(seekKey.getBuffer(), seekKey.getKeyOffset(), seekKey.getKeyLength(), true);
        Assert.assertEquals(null, (Object)seeker.getKeyValue());
        seekKey = KeyValue.createFirstDeleteFamilyOnRow((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 16), (byte[])CF_BYTES);
        seeker.seekToKeyInBlock(seekKey.getBuffer(), seekKey.getKeyOffset(), seekKey.getKeyLength(), true);
        Assert.assertNotNull((Object)seeker.getKeyValue());
        Assert.assertArrayEquals((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 15), (byte[])seeker.getKeyValue().getRow());
        seekKey = KeyValue.createFirstDeleteFamilyOnRow((byte[])Bytes.toBytes((String)"zzzz"), (byte[])CF_BYTES);
        seeker.seekToKeyInBlock(seekKey.getBuffer(), seekKey.getKeyOffset(), seekKey.getKeyLength(), true);
        Assert.assertNotNull((Object)seeker.getKeyValue());
        Assert.assertArrayEquals((byte[])TestPrefixTreeEncoding.getRowKey(batchId, 49), (byte[])seeker.getKeyValue().getRow());
    }

    @Test
    public void testScanWithRandomData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        ByteBuffer dataBuffer = TestPrefixTreeEncoding.generateRandomTestData(this.kvset, this.numBatchesWritten++);
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(Compression.Algorithm.NONE, DataBlockEncoding.PREFIX_TREE, new byte[0]);
        encoder.encodeKeyValues(dataBuffer, false, (HFileBlockEncodingContext)blkEncodingCtx);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, false);
        byte[] onDiskBytes = blkEncodingCtx.getOnDiskBytesWithHeader();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        seeker.setCurrentBuffer(readBuffer);
        KeyValue previousKV = null;
        do {
            KeyValue currentKV = seeker.getKeyValue();
            if (previousKV != null && KeyValue.COMPARATOR.compare((Cell)currentKV, (Cell)previousKV) < 0) {
                this.dumpInputKVSet();
                Assert.fail((String)("Current kv " + currentKV + " is smaller than previous keyvalue " + previousKV));
            }
            previousKV = currentKV;
        } while (seeker.next());
    }

    @Test
    public void testSeekWithRandomData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        int batchId = this.numBatchesWritten++;
        ByteBuffer dataBuffer = TestPrefixTreeEncoding.generateRandomTestData(this.kvset, batchId);
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(Compression.Algorithm.NONE, DataBlockEncoding.PREFIX_TREE, new byte[0]);
        encoder.encodeKeyValues(dataBuffer, false, (HFileBlockEncodingContext)blkEncodingCtx);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, false);
        byte[] onDiskBytes = blkEncodingCtx.getOnDiskBytesWithHeader();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        this.verifySeeking(seeker, readBuffer, batchId);
    }

    @Test
    public void testSeekWithFixedData() throws Exception {
        PrefixTreeCodec encoder = new PrefixTreeCodec();
        int batchId = this.numBatchesWritten++;
        ByteBuffer dataBuffer = TestPrefixTreeEncoding.generateFixedTestData(this.kvset, batchId);
        HFileBlockDefaultEncodingContext blkEncodingCtx = new HFileBlockDefaultEncodingContext(Compression.Algorithm.NONE, DataBlockEncoding.PREFIX_TREE, new byte[0]);
        encoder.encodeKeyValues(dataBuffer, false, (HFileBlockEncodingContext)blkEncodingCtx);
        DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, false);
        byte[] onDiskBytes = blkEncodingCtx.getOnDiskBytesWithHeader();
        ByteBuffer readBuffer = ByteBuffer.wrap(onDiskBytes, 2, onDiskBytes.length - 2);
        this.verifySeeking(seeker, readBuffer, batchId);
    }

    private void verifySeeking(DataBlockEncoder.EncodedSeeker encodeSeeker, ByteBuffer encodedData, int batchId) {
        ArrayList kvList = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            kvList.clear();
            encodeSeeker.setCurrentBuffer(encodedData);
            KeyValue firstOnRow = KeyValue.createFirstOnRow((byte[])TestPrefixTreeEncoding.getRowKey(batchId, i));
            encodeSeeker.seekToKeyInBlock(firstOnRow.getBuffer(), firstOnRow.getKeyOffset(), firstOnRow.getKeyLength(), false);
            boolean hasMoreOfEncodeScanner = encodeSeeker.next();
            CollectionBackedScanner collectionScanner = new CollectionBackedScanner(this.kvset);
            boolean hasMoreOfCollectionScanner = collectionScanner.seek(firstOnRow);
            if (hasMoreOfEncodeScanner != hasMoreOfCollectionScanner) {
                this.dumpInputKVSet();
                Assert.fail((String)("Get error result after seeking " + firstOnRow));
            }
            if (!hasMoreOfEncodeScanner || KeyValue.COMPARATOR.compare((Cell)encodeSeeker.getKeyValue(), (Cell)collectionScanner.peek()) == 0) continue;
            this.dumpInputKVSet();
            Assert.fail((String)("Expected " + collectionScanner.peek() + " actual " + encodeSeeker.getKeyValue() + ", after seeking " + firstOnRow));
        }
    }

    private void dumpInputKVSet() {
        LOG.info((Object)"Dumping input keyvalue set in error case:");
        for (KeyValue kv : this.kvset) {
            System.out.println(kv);
        }
    }

    private static ByteBuffer generateFixedTestData(ConcurrentSkipListSet<KeyValue> kvset, int batchId) throws Exception {
        return TestPrefixTreeEncoding.generateFixedTestData(kvset, batchId, true);
    }

    private static ByteBuffer generateFixedTestData(ConcurrentSkipListSet<KeyValue> kvset, int batchId, boolean partial) throws Exception {
        ByteArrayOutputStream baosInMemory = new ByteArrayOutputStream();
        DataOutputStream userDataStream = new DataOutputStream(baosInMemory);
        for (int i = 0; i < 50; ++i) {
            if (partial && i / 10 % 2 == 1) continue;
            for (int j = 0; j < 20; ++j) {
                KeyValue kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), TestPrefixTreeEncoding.getValue(batchId, i, j));
                kvset.add(kv);
            }
        }
        for (KeyValue kv : kvset) {
            userDataStream.writeInt(kv.getKeyLength());
            userDataStream.writeInt(kv.getValueLength());
            userDataStream.write(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
            userDataStream.write(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
        }
        return ByteBuffer.wrap(baosInMemory.toByteArray());
    }

    private static ByteBuffer generateRandomTestData(ConcurrentSkipListSet<KeyValue> kvset, int batchId) throws Exception {
        ByteArrayOutputStream baosInMemory = new ByteArrayOutputStream();
        DataOutputStream userDataStream = new DataOutputStream(baosInMemory);
        Random random = new Random();
        for (int i = 0; i < 50; ++i) {
            if (random.nextInt(100) < 50) continue;
            for (int j = 0; j < 20; ++j) {
                if (random.nextInt(100) < 50) continue;
                KeyValue kv = new KeyValue(TestPrefixTreeEncoding.getRowKey(batchId, i), CF_BYTES, TestPrefixTreeEncoding.getQualifier(j), TestPrefixTreeEncoding.getValue(batchId, i, j));
                kvset.add(kv);
            }
        }
        for (KeyValue kv : kvset) {
            userDataStream.writeInt(kv.getKeyLength());
            userDataStream.writeInt(kv.getValueLength());
            userDataStream.write(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
            userDataStream.write(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
        }
        return ByteBuffer.wrap(baosInMemory.toByteArray());
    }

    private static byte[] getRowKey(int batchId, int i) {
        return Bytes.toBytes((String)("batch" + batchId + "_row" + (formatRowNum ? String.format("%04d", i) : Integer.valueOf(i))));
    }

    private static byte[] getQualifier(int j) {
        return Bytes.toBytes((String)("col" + j));
    }

    private static byte[] getValue(int batchId, int i, int j) {
        return Bytes.toBytes((String)("value_for_" + Bytes.toString((byte[])TestPrefixTreeEncoding.getRowKey(batchId, i)) + "_col" + j));
    }
}

