/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestHTableMultiplexer {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE1 = Bytes.toBytes((String)"testValue1");
    private static byte[] VALUE2 = Bytes.toBytes((String)"testValue2");
    private static int SLAVES = 3;
    private static int PER_REGIONSERVER_QUEUE_SIZE = 100000;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testHTableMultiplexer() throws Exception {
        byte[] row;
        int i;
        Result r;
        int nbTry;
        Get get;
        TableName TABLE = TableName.valueOf((String)"testHTableMultiplexer");
        int NUM_REGIONS = 10;
        int VERSION = 3;
        HTableMultiplexer multiplexer = new HTableMultiplexer(TEST_UTIL.getConfiguration(), PER_REGIONSERVER_QUEUE_SIZE);
        HTable ht = TEST_UTIL.createTable(TABLE, (byte[][])new byte[][]{FAMILY}, 3, Bytes.toBytes((String)"aaaaa"), Bytes.toBytes((String)"zzzzz"), 10);
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE);
        byte[][] startRows = ht.getStartKeys();
        byte[][] endRows = ht.getEndKeys();
        for (int i2 = 0; i2 < 10; ++i2) {
            byte[] row2 = startRows[i2];
            if (row2 == null || row2.length <= 0) continue;
            Put put = new Put(row2);
            put.add(FAMILY, QUALIFIER, VALUE1);
            boolean success = multiplexer.put(TABLE, put);
            Assert.assertTrue((boolean)success);
            this.LOG.info((Object)("Put for " + Bytes.toString((byte[])startRows[i2]) + " @ iteration " + (i2 + 1)));
            get = new Get(startRows[i2]);
            get.addColumn(FAMILY, QUALIFIER);
            nbTry = 0;
            do {
                Assert.assertTrue((nbTry++ < 50 ? 1 : 0) != 0);
                Thread.sleep(100L);
            } while ((r = ht.get(get)) == null || r.getValue(FAMILY, QUALIFIER) == null);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE1, (byte[])r.getValue(FAMILY, QUALIFIER)));
        }
        ArrayList<Put> multiput = new ArrayList<Put>();
        for (i = 0; i < 10; ++i) {
            row = endRows[i];
            if (row == null || row.length <= 0) continue;
            Put put = new Put(row);
            put.add(FAMILY, QUALIFIER, VALUE2);
            multiput.add(put);
        }
        List failedPuts = multiplexer.put(TABLE, multiput);
        Assert.assertTrue((failedPuts == null ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            row = endRows[i];
            if (row == null || row.length <= 0) continue;
            get = new Get(row);
            get.addColumn(FAMILY, QUALIFIER);
            nbTry = 0;
            do {
                Assert.assertTrue((nbTry++ < 50 ? 1 : 0) != 0);
                Thread.sleep(100L);
            } while ((r = ht.get(get)) == null || r.getValue(FAMILY, QUALIFIER) == null || Bytes.compareTo((byte[])VALUE2, (byte[])r.getValue(FAMILY, QUALIFIER)) != 0);
        }
    }
}

