/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestFromClientSide3 {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static Random random = new Random();
    private static int SLAVES = 3;
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final byte[] ANOTHERROW = Bytes.toBytes((String)"anotherrow");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");
    private static final byte[] COL_QUAL = Bytes.toBytes((String)"f1");
    private static final byte[] VAL_BYTES = Bytes.toBytes((String)"v1");
    private static final byte[] ROW_BYTES = Bytes.toBytes((String)"r1");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    private void randomCFPuts(HTable table, byte[] row, byte[] family, int nPuts) throws Exception {
        Put put = new Put(row);
        for (int i = 0; i < nPuts; ++i) {
            byte[] qualifier = Bytes.toBytes((int)random.nextInt());
            byte[] value = Bytes.toBytes((int)random.nextInt());
            put.add(family, qualifier, value);
        }
        table.put(put);
    }

    private void performMultiplePutAndFlush(HBaseAdmin admin, HTable table, byte[] row, byte[] family, int nFlushes, int nPuts) throws Exception {
        HConnection conn = HConnectionManager.getConnection((Configuration)TEST_UTIL.getConfiguration());
        HRegionLocation loc = table.getRegionLocation(row, true);
        AdminProtos.AdminService.BlockingInterface server = conn.getAdmin(loc.getServerName());
        byte[] regName = loc.getRegionInfo().getRegionName();
        for (int i = 0; i < nFlushes; ++i) {
            this.randomCFPuts(table, row, family, nPuts);
            List sf = ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regName, (byte[])FAMILY);
            int sfCount = sf.size();
            admin.flush(table.getTableName());
            while (ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regName, (byte[])FAMILY).size() == sfCount) {
                Thread.sleep(40L);
            }
        }
    }

    @Test(timeout=60000L)
    public void testAdvancedConfigOverride() throws Exception {
        Pair st;
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compaction.min", 3);
        String tableName = "testAdvancedConfigOverride";
        TableName TABLE = TableName.valueOf((String)tableName);
        HTable hTable = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        HConnection connection = HConnectionManager.getConnection((Configuration)TEST_UTIL.getConfiguration());
        byte[] row = Bytes.toBytes((int)random.nextInt());
        this.performMultiplePutAndFlush(admin, hTable, row, FAMILY, 3, 100);
        HRegionLocation loc = hTable.getRegionLocation(row, true);
        byte[] regionName = loc.getRegionInfo().getRegionName();
        AdminProtos.AdminService.BlockingInterface server = connection.getAdmin(loc.getServerName());
        Assert.assertTrue((ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() > 1 ? 1 : 0) != 0);
        admin.compact(TABLE.getName());
        for (int i = 0; i < 250; ++i) {
            loc = hTable.getRegionLocation(row, true);
            if (!loc.getRegionInfo().isOffline()) {
                regionName = loc.getRegionInfo().getRegionName();
                server = connection.getAdmin(loc.getServerName());
                if (ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() <= 1) break;
            }
            Thread.sleep(40L);
        }
        Assert.assertTrue((ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() <= 1 ? 1 : 0) != 0);
        this.LOG.info((Object)"hbase.hstore.compaction.min should now be 5");
        HTableDescriptor htd = new HTableDescriptor(hTable.getTableDescriptor());
        htd.setValue("hbase.hstore.compaction.min", String.valueOf(5));
        admin.modifyTable(TABLE, htd);
        while (null != (st = admin.getAlterStatus(TABLE)) && (Integer)st.getFirst() > 0) {
            this.LOG.debug((Object)(st.getFirst() + " regions left to update"));
            Thread.sleep(40L);
        }
        this.LOG.info((Object)"alter status finished");
        this.performMultiplePutAndFlush(admin, hTable, row, FAMILY, 3, 10);
        admin.compact(TABLE.getName());
        Thread.sleep(10000L);
        loc = hTable.getRegionLocation(row, true);
        regionName = loc.getRegionInfo().getRegionName();
        server = connection.getAdmin(loc.getServerName());
        int sfCount = ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size();
        Assert.assertTrue((sfCount > 1 ? 1 : 0) != 0);
        this.LOG.info((Object)"hbase.hstore.compaction.min should now be 2");
        HColumnDescriptor hcd = new HColumnDescriptor(htd.getFamily(FAMILY));
        hcd.setValue("hbase.hstore.compaction.min", String.valueOf(2));
        htd.addFamily(hcd);
        admin.modifyTable(TABLE, htd);
        while (null != (st = admin.getAlterStatus(TABLE)) && (Integer)st.getFirst() > 0) {
            this.LOG.debug((Object)(st.getFirst() + " regions left to update"));
            Thread.sleep(40L);
        }
        this.LOG.info((Object)"alter status finished");
        admin.compact(TABLE.getName());
        for (int i = 0; i < 250; ++i) {
            loc = hTable.getRegionLocation(row, true);
            regionName = loc.getRegionInfo().getRegionName();
            try {
                server = connection.getAdmin(loc.getServerName());
                if (ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() < sfCount) {
                    break;
                }
            }
            catch (Exception e) {
                this.LOG.debug((Object)("Waiting for region to come online: " + regionName));
            }
            Thread.sleep(40L);
        }
        Assert.assertTrue((ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() < sfCount ? 1 : 0) != 0);
        this.LOG.info((Object)"Removing CF config value");
        this.LOG.info((Object)"hbase.hstore.compaction.min should now be 5");
        hcd = new HColumnDescriptor(htd.getFamily(FAMILY));
        hcd.setValue("hbase.hstore.compaction.min", null);
        htd.addFamily(hcd);
        admin.modifyTable(TABLE, htd);
        while (null != (st = admin.getAlterStatus(TABLE)) && (Integer)st.getFirst() > 0) {
            this.LOG.debug((Object)(st.getFirst() + " regions left to update"));
            Thread.sleep(40L);
        }
        this.LOG.info((Object)"alter status finished");
        Assert.assertNull((Object)hTable.getTableDescriptor().getFamily(FAMILY).getValue("hbase.hstore.compaction.min"));
    }

    @Test
    public void testHTableExistsMethodSingleRegionSingleGet() throws Exception {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testHTableExistsMethodSingleRegionSingleGet"), (byte[][])new byte[][]{FAMILY});
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        Get get = new Get(ROW);
        boolean exist = table.exists(get);
        Assert.assertEquals((Object)exist, (Object)false);
        table.put(put);
        exist = table.exists(get);
        Assert.assertEquals((Object)exist, (Object)true);
    }

    public void testHTableExistsMethodSingleRegionMultipleGets() throws Exception {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testHTableExistsMethodSingleRegionMultipleGets"), (byte[][])new byte[][]{FAMILY});
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        ArrayList<Get> gets = new ArrayList<Get>();
        gets.add(new Get(ROW));
        gets.add(null);
        gets.add(new Get(ANOTHERROW));
        Boolean[] results = table.exists(gets);
        Assert.assertEquals((Object)results[0], (Object)true);
        Assert.assertEquals((Object)results[1], (Object)false);
        Assert.assertEquals((Object)results[2], (Object)false);
    }

    @Test
    public void testHTableExistsMethodMultipleRegionsSingleGet() throws Exception {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testHTableExistsMethodMultipleRegionsSingleGet"), (byte[][])new byte[][]{FAMILY}, 1, new byte[]{0}, new byte[]{-1}, 255);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        Get get = new Get(ROW);
        boolean exist = table.exists(get);
        Assert.assertEquals((Object)exist, (Object)false);
        table.put(put);
        exist = table.exists(get);
        Assert.assertEquals((Object)exist, (Object)true);
    }

    @Test
    public void testHTableExistsMethodMultipleRegionsMultipleGets() throws Exception {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testHTableExistsMethodMultipleRegionsMultipleGets"), (byte[][])new byte[][]{FAMILY}, 1, new byte[]{0}, new byte[]{-1}, 255);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        ArrayList<Get> gets = new ArrayList<Get>();
        gets.add(new Get(ANOTHERROW));
        gets.add(new Get(Bytes.add((byte[])ROW, (byte[])new byte[]{0})));
        gets.add(new Get(ROW));
        gets.add(new Get(Bytes.add((byte[])ANOTHERROW, (byte[])new byte[]{0})));
        Boolean[] results = table.exists(gets);
        Assert.assertEquals((Object)results[0], (Object)false);
        Assert.assertEquals((Object)results[1], (Object)false);
        Assert.assertEquals((Object)results[2], (Object)true);
        Assert.assertEquals((Object)results[3], (Object)false);
        put = new Put(new byte[]{0});
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        gets = new ArrayList();
        gets.add(new Get(new byte[]{0}));
        gets.add(new Get(new byte[]{0, 0}));
        results = table.exists(gets);
        Assert.assertEquals((Object)results[0], (Object)true);
        Assert.assertEquals((Object)results[1], (Object)false);
        put = new Put(new byte[]{-1, -1});
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        gets = new ArrayList();
        gets.add(new Get(new byte[]{-1}));
        gets.add(new Get(new byte[]{-1, -1}));
        gets.add(new Get(new byte[]{-1, -1, -1}));
        results = table.exists(gets);
        Assert.assertEquals((Object)results[0], (Object)false);
        Assert.assertEquals((Object)results[1], (Object)true);
        Assert.assertEquals((Object)results[2], (Object)false);
    }

    @Test
    public void testGetEmptyRow() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])Bytes.toBytes((String)"test")));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        admin.createTable(desc);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), "test");
        Put put = new Put(ROW_BYTES);
        put.add(FAMILY, COL_QUAL, VAL_BYTES);
        table.put(put);
        table.flushCommits();
        Result res = null;
        try {
            res = table.get(new Get(new byte[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertTrue((res == null ? 1 : 0) != 0);
        res = table.get(new Get(Bytes.toBytes((String)"r1-not-exist")));
        Assert.assertTrue((res.isEmpty() ? 1 : 0) != 0);
        res = table.get(new Get(ROW_BYTES));
        Assert.assertTrue((boolean)Arrays.equals(res.getValue(FAMILY, COL_QUAL), VAL_BYTES));
        table.close();
    }
}

