/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreUtils;

@InterfaceAudience.Private
class DefaultStoreFileManager
implements StoreFileManager {
    static final Log LOG = LogFactory.getLog(DefaultStoreFileManager.class);
    private final KeyValue.KVComparator kvComparator;
    private final Configuration conf;
    private volatile ImmutableList<StoreFile> storefiles = null;

    public DefaultStoreFileManager(KeyValue.KVComparator kvComparator, Configuration conf) {
        this.kvComparator = kvComparator;
        this.conf = conf;
    }

    @Override
    public void loadFiles(List<StoreFile> storeFiles) {
        this.sortAndSetStoreFiles(storeFiles);
    }

    @Override
    public final Collection<StoreFile> getStorefiles() {
        return this.storefiles;
    }

    @Override
    public void insertNewFile(StoreFile sf) {
        ArrayList<StoreFile> newFiles = new ArrayList<StoreFile>((Collection<StoreFile>)this.storefiles);
        newFiles.add(sf);
        this.sortAndSetStoreFiles(newFiles);
    }

    @Override
    public ImmutableCollection<StoreFile> clearFiles() {
        ImmutableList<StoreFile> result = this.storefiles;
        this.storefiles = ImmutableList.of();
        return result;
    }

    @Override
    public final int getStorefileCount() {
        return this.storefiles.size();
    }

    @Override
    public void addCompactionResults(Collection<StoreFile> compactedFiles, Collection<StoreFile> results) {
        ArrayList newStoreFiles = Lists.newArrayList(this.storefiles);
        newStoreFiles.removeAll(compactedFiles);
        if (!results.isEmpty()) {
            newStoreFiles.addAll(results);
        }
        this.sortAndSetStoreFiles(newStoreFiles);
    }

    @Override
    public final Iterator<StoreFile> getCandidateFilesForRowKeyBefore(KeyValue targetKey) {
        return new ArrayList(Lists.reverse(this.storefiles)).iterator();
    }

    @Override
    public Iterator<StoreFile> updateCandidateFilesForRowKeyBefore(Iterator<StoreFile> candidateFiles, KeyValue targetKey, KeyValue candidate) {
        return candidateFiles;
    }

    @Override
    public final byte[] getSplitPoint() throws IOException {
        if (this.storefiles.isEmpty()) {
            return null;
        }
        return StoreUtils.getLargestFile(this.storefiles).getFileSplitPoint(this.kvComparator);
    }

    @Override
    public final Collection<StoreFile> getFilesForScanOrGet(boolean isGet, byte[] startRow, byte[] stopRow) {
        return this.getStorefiles();
    }

    @Override
    public int getStoreCompactionPriority() {
        int blockingFileCount = this.conf.getInt("hbase.hstore.blockingStoreFiles", 7);
        int priority = blockingFileCount - this.storefiles.size();
        return priority == 1 ? priority + 1 : priority;
    }

    private void sortAndSetStoreFiles(List<StoreFile> storeFiles) {
        Collections.sort(storeFiles, StoreFile.Comparators.SEQ_ID);
        this.storefiles = ImmutableList.copyOf(storeFiles);
    }
}

