/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class MetricsMasterWrapperImpl
implements MetricsMasterWrapper {
    private final HMaster master;

    public MetricsMasterWrapperImpl(HMaster master) {
        this.master = master;
    }

    public double getAverageLoad() {
        return this.master.getAverageLoad();
    }

    public String getClusterId() {
        return this.master.getClusterId();
    }

    public String getZookeeperQuorum() {
        ZooKeeperWatcher zk = this.master.getZooKeeperWatcher();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    public String[] getCoprocessors() {
        return this.master.getCoprocessors();
    }

    public long getStartTime() {
        return this.master.getMasterStartTime();
    }

    public long getActiveTime() {
        return this.master.getMasterActiveTime();
    }

    public int getRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getOnlineServers().size();
    }

    public int getDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getDeadServers().size();
    }

    public String getServerName() {
        ServerName serverName = this.master.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    public boolean getIsActiveMaster() {
        return this.master.isActiveMaster();
    }
}

