/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.TestTableName;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAccessController
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestAccessController.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static TableName TEST_TABLE2;
    private static byte[] TEST_FAMILY;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static RegionServerCoprocessorEnvironment RSCP_ENV;
    private RegionCoprocessorEnvironment RCP_ENV;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.master.hfilecleaner.plugins", "org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner,org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner");
        conf.set("hbase.master.logcleaner.plugins", "org.apache.hadoop.hbase.master.snapshot.SnapshotLogCleaner");
        SecureTestUtil.enableSecurity(conf);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        ACCESS_CONTROLLER = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        CP_ENV = cpHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getCoprocessorHost();
        RSCP_ENV = rsHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName());
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin2", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"tbl_create", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"nouser", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        htd.setOwner(USER_OWNER);
        admin.createTable(htd);
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName().getName());
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(this.TEST_TABLE.getTableName()).get(0);
        RegionCoprocessorHost rcpHost = region.getCoprocessorHost();
        this.RCP_ENV = rcpHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service = acl.coprocessorService(this.TEST_TABLE.getTableName().getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            protocol.grant(null, RequestConverter.buildGrantRequest((String)USER_ADMIN.getShortName(), (AccessControlProtos.Permission.Action[])new AccessControlProtos.Permission.Action[]{AccessControlProtos.Permission.Action.ADMIN, AccessControlProtos.Permission.Action.CREATE, AccessControlProtos.Permission.Action.READ, AccessControlProtos.Permission.Action.WRITE}));
            protocol.grant(null, RequestConverter.buildGrantRequest((String)USER_RW.getShortName(), (TableName)this.TEST_TABLE.getTableName(), (byte[])TEST_FAMILY, null, (AccessControlProtos.Permission.Action[])new AccessControlProtos.Permission.Action[]{AccessControlProtos.Permission.Action.READ, AccessControlProtos.Permission.Action.WRITE}));
            protocol.grant(null, RequestConverter.buildGrantRequest((String)USER_CREATE.getShortName(), (TableName)this.TEST_TABLE.getTableName(), null, null, (AccessControlProtos.Permission.Action[])new AccessControlProtos.Permission.Action[]{AccessControlProtos.Permission.Action.CREATE, AccessControlProtos.Permission.Action.READ, AccessControlProtos.Permission.Action.WRITE}));
            protocol.grant(null, RequestConverter.buildGrantRequest((String)USER_RO.getShortName(), (TableName)this.TEST_TABLE.getTableName(), (byte[])TEST_FAMILY, null, (AccessControlProtos.Permission.Action[])new AccessControlProtos.Permission.Action[]{AccessControlProtos.Permission.Action.READ}));
            Assert.assertEquals((long)4L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).size());
        }
        finally {
            acl.close();
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.TEST_TABLE.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).size());
    }

    @Override
    public void verifyAllowed(PrivilegedExceptionAction action, User ... users) throws Exception {
        for (User user : users) {
            this.verifyAllowed(user, action);
        }
    }

    @Override
    public void verifyDenied(User user, PrivilegedExceptionAction ... actions) throws Exception {
        for (PrivilegedExceptionAction action : actions) {
            try {
                user.runAs(action);
                Assert.fail((String)("Expected AccessDeniedException for user '" + user.getShortName() + "'"));
            }
            catch (IOException e) {
                boolean isAccessDeniedException = false;
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    for (Throwable ex : ((RetriesExhaustedWithDetailsException)((Object)e)).getCauses()) {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    }
                } else {
                    Throwable ex = e;
                    do {
                        if (!(ex instanceof AccessDeniedException)) continue;
                        isAccessDeniedException = true;
                        break;
                    } while ((ex = ex.getCause()) != null);
                }
                if (isAccessDeniedException) continue;
                Assert.fail((String)("Not receiving AccessDeniedException for user '" + user.getShortName() + "'"));
            }
            catch (UndeclaredThrowableException ute) {
                ServiceException se;
                Throwable ex = ute.getUndeclaredThrowable();
                if (ex instanceof PrivilegedActionException) {
                    ex = ((PrivilegedActionException)ex).getException();
                }
                if (ex instanceof ServiceException && (se = (ServiceException)ex).getCause() != null && se.getCause() instanceof AccessDeniedException) {
                    return;
                }
                Assert.fail((String)("Not receiving AccessDeniedException for user '" + user.getShortName() + "'"));
            }
        }
    }

    @Override
    public void verifyDenied(PrivilegedExceptionAction action, User ... users) throws Exception {
        for (User user : users) {
            this.verifyDenied(user, action);
        }
    }

    @Test
    public void testTableCreate() throws Exception {
        PrivilegedExceptionAction createTable = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"testnewtable"));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), htd, null);
                return null;
            }
        };
        this.verifyAllowed(createTable, SUPERUSER, USER_ADMIN);
        this.verifyDenied(createTable, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testTableModify() throws Exception {
        PrivilegedExceptionAction modifyTable = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TestAccessController.this.TEST_TABLE.getTableName());
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                htd.addFamily(new HColumnDescriptor("fam_" + User.getCurrent().getShortName()));
                ACCESS_CONTROLLER.preModifyTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName(), htd);
                return null;
            }
        };
        this.verifyAllowed(modifyTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        this.verifyDenied(modifyTable, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testTableDelete() throws Exception {
        PrivilegedExceptionAction deleteTable = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName());
                return null;
            }
        };
        this.verifyAllowed(deleteTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        this.verifyDenied(deleteTable, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testAddColumn() throws Exception {
        final HColumnDescriptor hcd = new HColumnDescriptor("fam_new");
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAddColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName(), hcd);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        this.verifyDenied(action, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testModifyColumn() throws Exception {
        final HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(10);
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preModifyColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName(), hcd);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        this.verifyDenied(action, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testDeleteColumn() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        this.verifyDenied(action, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testTableDisable() throws Exception {
        PrivilegedExceptionAction disableTable = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName());
                return null;
            }
        };
        PrivilegedExceptionAction disableAclTable = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), AccessControlLists.ACL_TABLE_NAME);
                return null;
            }
        };
        this.verifyAllowed(disableTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        this.verifyDenied(disableTable, USER_RW, USER_RO, USER_NONE);
        this.verifyDenied(disableAclTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_RW, USER_RO);
    }

    @Test
    public void testTableEnable() throws Exception {
        PrivilegedExceptionAction enableTable = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preEnableTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestAccessController.this.TEST_TABLE.getTableName());
                return null;
            }
        };
        this.verifyAllowed(enableTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER);
        this.verifyDenied(enableTable, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMove() throws Exception {
        NavigableMap regions;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.TEST_TABLE.getTableName());
        try {
            regions = table.getRegionLocations();
        }
        finally {
            table.close();
        }
        final Map.Entry firstRegion = regions.entrySet().iterator().next();
        final ServerName server = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preMove(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (HRegionInfo)firstRegion.getKey(), server, server);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssign() throws Exception {
        NavigableMap regions;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.TEST_TABLE.getTableName());
        try {
            regions = table.getRegionLocations();
        }
        finally {
            table.close();
        }
        final Map.Entry firstRegion = regions.entrySet().iterator().next();
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAssign(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (HRegionInfo)firstRegion.getKey());
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnassign() throws Exception {
        NavigableMap regions;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.TEST_TABLE.getTableName());
        try {
            regions = table.getRegionLocations();
        }
        finally {
            table.close();
        }
        final Map.Entry firstRegion = regions.entrySet().iterator().next();
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preUnassign(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (HRegionInfo)firstRegion.getKey(), false);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionOffline() throws Exception {
        NavigableMap regions;
        HTable table = new HTable(TEST_UTIL.getConfiguration(), this.TEST_TABLE.getTableName());
        try {
            regions = table.getRegionLocations();
        }
        finally {
            table.close();
        }
        final Map.Entry firstRegion = regions.entrySet().iterator().next();
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRegionOffline(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (HRegionInfo)firstRegion.getKey());
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testBalance() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalance(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null));
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        this.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testBalanceSwitch() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalanceSwitch(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), true);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        this.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testShutdown() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preShutdown(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null));
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        this.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testStopMaster() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopMaster(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null));
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        this.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    private void verifyWrite(PrivilegedExceptionAction action) throws Exception {
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        this.verifyDenied(action, USER_NONE, USER_RO);
    }

    @Test
    public void testSplit() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplit(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null));
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testSplitWithSplitRow() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplit(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null), Bytes.toBytes((String)"row2"));
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testFlush() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preFlush(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null));
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testCompact() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCompact(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null), null, null, ScanType.COMPACT_RETAIN_DELETES);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testPreCompactSelection() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCompactSelection(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null), null, null);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    private void verifyRead(PrivilegedExceptionAction action) throws Exception {
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO);
        this.verifyDenied(action, USER_NONE);
    }

    private void verifyReadWrite(PrivilegedExceptionAction action) throws Exception {
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        this.verifyDenied(action, USER_NONE, USER_RO);
    }

    @Test
    public void testRead() throws Exception {
        PrivilegedExceptionAction getAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Get g = new Get(Bytes.toBytes((String)"random_row"));
                g.addFamily(TEST_FAMILY);
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyRead(getAction);
        PrivilegedExceptionAction scanAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() throws Exception {
                Scan s = new Scan();
                s.addFamily(TEST_FAMILY);
                HTable table = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    ResultScanner scanner = table.getScanner(s);
                    try {
                        Result r = scanner.next();
                        while (r != null) {
                            r = scanner.next();
                        }
                        return null;
                    }
                    catch (IOException e) {
                        return null;
                    }
                    finally {
                        scanner.close();
                    }
                }
                finally {
                    table.close();
                }
            }
        };
        this.verifyRead(scanAction);
    }

    @Test
    public void testWrite() throws Exception {
        PrivilegedExceptionAction putAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"random_row"));
                p.add(TEST_FAMILY, Bytes.toBytes((String)"Qualifier"), Bytes.toBytes((int)1));
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyWrite(putAction);
        PrivilegedExceptionAction deleteAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Delete d = new Delete(Bytes.toBytes((String)"random_row"));
                d.deleteFamily(TEST_FAMILY);
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyWrite(deleteAction);
        PrivilegedExceptionAction incrementAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Increment inc = new Increment(Bytes.toBytes((String)"random_row"));
                inc.addColumn(TEST_FAMILY, Bytes.toBytes((String)"Qualifier"), 1L);
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.increment(inc);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyWrite(incrementAction);
    }

    @Test
    public void testReadWrite() throws Exception {
        PrivilegedExceptionAction checkAndDeleteAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Delete d = new Delete(Bytes.toBytes((String)"random_row"));
                d.deleteFamily(TEST_FAMILY);
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.checkAndDelete(Bytes.toBytes((String)"random_row"), TEST_FAMILY, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"test_value"), d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyReadWrite(checkAndDeleteAction);
        PrivilegedExceptionAction checkAndPut = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"random_row"));
                p.add(TEST_FAMILY, Bytes.toBytes((String)"Qualifier"), Bytes.toBytes((int)1));
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.checkAndPut(Bytes.toBytes((String)"random_row"), TEST_FAMILY, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"test_value"), p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyReadWrite(checkAndPut);
    }

    @Test
    public void testBulkLoad() throws Exception {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        final Path dir = TEST_UTIL.getDataTestDir("testBulkLoad");
        fs.mkdirs(dir);
        fs.setPermission(dir, FsPermission.valueOf((String)"-rwxrwxrwx"));
        PrivilegedExceptionAction bulkLoadAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                int numRows = 3;
                byte[][][] hfileRanges = new byte[][][]{new byte[][]{{0}, {9}}};
                Path bulkLoadBasePath = new Path(dir, new Path(User.getCurrent().getName()));
                new BulkLoadHelper(bulkLoadBasePath).bulkLoadHFile(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, Bytes.toBytes((String)"q"), hfileRanges, numRows);
                return null;
            }
        };
        this.verifyAllowed(bulkLoadAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        this.verifyDenied(bulkLoadAction, USER_RW, USER_NONE, USER_RO);
        TEST_UTIL.getHBaseAdmin().disableTable(this.TEST_TABLE.getTableName());
        TEST_UTIL.getHBaseAdmin().enableTable(this.TEST_TABLE.getTableName());
    }

    @Test
    public void testAppend() throws Exception {
        PrivilegedExceptionAction appendAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                byte[] row = Bytes.toBytes((String)"random_row");
                byte[] qualifier = Bytes.toBytes((String)"q");
                Put put = new Put(row);
                put.add(TEST_FAMILY, qualifier, Bytes.toBytes((int)1));
                Append append = new Append(row);
                append.add(TEST_FAMILY, qualifier, Bytes.toBytes((int)2));
                HTable t = new HTable(conf, TestAccessController.this.TEST_TABLE.getTableName());
                try {
                    t.put(put);
                    t.append(append);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyAllowed(appendAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        this.verifyDenied(appendAction, USER_RO, USER_NONE);
    }

    @Test
    public void testGrantRevoke() throws Exception {
        PrivilegedExceptionAction grantAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(TestAccessController.this.TEST_TABLE.getTableName().getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)USER_RO.getShortName(), (TableName)TestAccessController.this.TEST_TABLE.getTableName(), (byte[])TEST_FAMILY, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction revokeAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(TestAccessController.this.TEST_TABLE.getTableName().getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)USER_RO.getShortName(), (TableName)TestAccessController.this.TEST_TABLE.getTableName(), (byte[])TEST_FAMILY, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction getPermissionsAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(TestAccessController.this.TEST_TABLE.getTableName().getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)TestAccessController.this.TEST_TABLE.getTableName());
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        this.verifyAllowed(grantAction, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(grantAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
        this.verifyAllowed(revokeAction, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(revokeAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
        this.verifyAllowed(getPermissionsAction, SUPERUSER, USER_ADMIN, USER_OWNER);
        this.verifyDenied(getPermissionsAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostGrantRevoke() throws Exception {
        AccessControlProtos.AccessControlService.BlockingInterface protocol;
        CoprocessorRpcChannel service;
        final TableName tableName = TableName.valueOf((String)"TempTable");
        final byte[] family1 = Bytes.toBytes((String)"f1");
        final byte[] family2 = Bytes.toBytes((String)"f2");
        final byte[] qualifier = Bytes.toBytes((String)"q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        admin.createTable(htd);
        User tblUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"tbluser", (String[])new String[0]);
        User gblUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"gbluser", (String[])new String[0]);
        PrivilegedExceptionAction putActionAll = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"a"));
                p.add(family1, qualifier, Bytes.toBytes((String)"v1"));
                p.add(family2, qualifier, Bytes.toBytes((String)"v2"));
                HTable t = new HTable(conf, tableName);
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction putAction1 = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"a"));
                p.add(family1, qualifier, Bytes.toBytes((String)"v1"));
                HTable t = new HTable(conf, tableName);
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction putAction2 = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"a"));
                p.add(family2, qualifier, Bytes.toBytes((String)"v2"));
                HTable t = new HTable(conf, tableName);
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction getActionAll = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Get g = new Get(Bytes.toBytes((String)"random_row"));
                g.addFamily(family1);
                g.addFamily(family2);
                HTable t = new HTable(conf, tableName);
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction getAction1 = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Get g = new Get(Bytes.toBytes((String)"random_row"));
                g.addFamily(family1);
                HTable t = new HTable(conf, tableName);
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction getAction2 = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Get g = new Get(Bytes.toBytes((String)"random_row"));
                g.addFamily(family2);
                HTable t = new HTable(conf, tableName);
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction deleteActionAll = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Delete d = new Delete(Bytes.toBytes((String)"random_row"));
                d.deleteFamily(family1);
                d.deleteFamily(family2);
                HTable t = new HTable(conf, tableName);
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction deleteAction1 = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Delete d = new Delete(Bytes.toBytes((String)"random_row"));
                d.deleteFamily(family1);
                HTable t = new HTable(conf, tableName);
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction deleteAction2 = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Delete d = new Delete(Bytes.toBytes((String)"random_row"));
                d.deleteFamily(family2);
                HTable t = new HTable(conf, tableName);
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        this.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
        this.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        this.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        this.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)tblUser.getShortName(), (TableName)tableName, null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)gblUser.getShortName(), (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyAllowed(tblUser, getActionAll, getAction1, getAction2);
        this.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        this.verifyAllowed(gblUser, getActionAll, getAction1, getAction2);
        this.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)tblUser.getShortName(), (TableName)tableName, null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)gblUser.getShortName(), (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
        this.verifyAllowed(tblUser, putActionAll, putAction1, putAction2);
        this.verifyAllowed(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        this.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        this.verifyAllowed(gblUser, putActionAll, putAction1, putAction2);
        this.verifyAllowed(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)tblUser.getShortName(), (TableName)tableName, null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
            ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)tblUser.getShortName(), (TableName)tableName, null, null, (Permission.Action[])new Permission.Action[0]);
            ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)gblUser.getShortName(), (Permission.Action[])new Permission.Action[0]);
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
        this.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        this.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        this.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)tblUser.getShortName(), (TableName)tableName, (byte[])family1, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)gblUser.getShortName(), (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyAllowed(tblUser, getActionAll, getAction1);
        this.verifyDenied(tblUser, getAction2);
        this.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        this.verifyAllowed(gblUser, getActionAll, getAction1, getAction2);
        this.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)tblUser.getShortName(), (TableName)tableName, (byte[])family2, null, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)gblUser.getShortName(), (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyAllowed(tblUser, getActionAll, getAction1);
        this.verifyAllowed(tblUser, putAction2, deleteAction2);
        this.verifyDenied(tblUser, getAction2);
        this.verifyDenied(tblUser, putActionAll, putAction1);
        this.verifyDenied(tblUser, deleteActionAll, deleteAction1);
        this.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        this.verifyAllowed(gblUser, putActionAll, putAction1, putAction2);
        this.verifyAllowed(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)tblUser.getShortName(), (TableName)tableName, (byte[])family2, null, (Permission.Action[])new Permission.Action[0]);
            ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)gblUser.getShortName(), (Permission.Action[])new Permission.Action[0]);
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyAllowed(tblUser, getActionAll, getAction1);
        this.verifyDenied(tblUser, getAction2);
        this.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
        this.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
        this.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
        this.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
    }

    private boolean hasFoundUserPermission(UserPermission userPermission, List<UserPermission> perms) {
        return perms.contains(userPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostGrantRevokeAtQualifierLevel() throws Exception {
        AccessControlProtos.AccessControlService.BlockingInterface protocol;
        CoprocessorRpcChannel service;
        final TableName tableName = TableName.valueOf((String)"testGrantRevokeAtQualifierLevel");
        final byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        final byte[] qualifier = Bytes.toBytes((String)"q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        admin.createTable(htd);
        User user = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"user", (String[])new String[0]);
        PrivilegedExceptionAction getQualifierAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Get g = new Get(Bytes.toBytes((String)"random_row"));
                g.addColumn(family1, qualifier);
                HTable t = new HTable(conf, tableName);
                try {
                    t.get(g);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction putQualifierAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Put p = new Put(Bytes.toBytes((String)"random_row"));
                p.add(family1, qualifier, Bytes.toBytes((String)"v1"));
                HTable t = new HTable(conf, tableName);
                try {
                    t.put(p);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction deleteQualifierAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Delete d = new Delete(Bytes.toBytes((String)"random_row"));
                d.deleteColumn(family1, qualifier);
                HTable t = new HTable(conf, tableName);
                try {
                    t.delete(d);
                }
                finally {
                    t.close();
                }
                return null;
            }
        };
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user.getShortName(), (TableName)tableName, (byte[])family1, null, (Permission.Action[])new Permission.Action[0]);
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyDenied(user, getQualifierAction);
        this.verifyDenied(user, putQualifierAction);
        this.verifyDenied(user, deleteQualifierAction);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user.getShortName(), (TableName)tableName, (byte[])family1, (byte[])qualifier, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyAllowed(user, getQualifierAction);
        this.verifyDenied(user, putQualifierAction);
        this.verifyDenied(user, deleteQualifierAction);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user.getShortName(), (TableName)tableName, (byte[])family1, (byte[])qualifier, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyDenied(user, getQualifierAction);
        this.verifyAllowed(user, putQualifierAction);
        this.verifyAllowed(user, deleteQualifierAction);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user.getShortName(), (TableName)tableName, (byte[])family1, (byte[])qualifier, (Permission.Action[])new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyAllowed(user, getQualifierAction);
        this.verifyAllowed(user, putQualifierAction);
        this.verifyAllowed(user, deleteQualifierAction);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user.getShortName(), (TableName)tableName, (byte[])family1, (byte[])qualifier, (Permission.Action[])new Permission.Action[0]);
        }
        finally {
            acl.close();
        }
        Thread.sleep(100L);
        this.verifyDenied(user, getQualifierAction);
        this.verifyDenied(user, putQualifierAction);
        this.verifyDenied(user, deleteQualifierAction);
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPermissionList() throws Exception {
        AccessControlProtos.AccessControlService.BlockingInterface protocol;
        CoprocessorRpcChannel service;
        List perms;
        TableName tableName = TableName.valueOf((String)"testPermissionList");
        byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        byte[] qualifier = Bytes.toBytes((String)"q");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        htd.setOwner(USER_OWNER);
        admin.createTable(htd);
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service2 = acl.coprocessorService(tableName.getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol2 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service2);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol2, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        UserPermission ownerperm = new UserPermission(Bytes.toBytes((String)USER_OWNER.getName()), tableName, null, Permission.Action.values());
        Assert.assertTrue((String)"Owner should have all permissions on table", (boolean)this.hasFoundUserPermission(ownerperm, perms));
        User user = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"user", (String[])new String[0]);
        byte[] userName = Bytes.toBytes((String)user.getShortName());
        UserPermission up = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.READ});
        Assert.assertFalse((String)("User should not be granted permission: " + up.toString()), (boolean)this.hasFoundUserPermission(up, perms));
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service3 = acl.coprocessorService(tableName.getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol3 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service3);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol3, (String)user.getShortName(), (TableName)tableName, (byte[])family1, (byte[])qualifier, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol3, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        UserPermission upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.READ});
        Assert.assertTrue((String)("User should be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
        upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.WRITE});
        Assert.assertFalse((String)("User should not be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user.getShortName(), (TableName)tableName, (byte[])family1, (byte[])qualifier, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ});
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ});
        Assert.assertTrue((String)("User should be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            service = acl.coprocessorService(tableName.getName());
            protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.revoke((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)user.getShortName(), (TableName)tableName, (byte[])family1, (byte[])qualifier, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ});
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        Assert.assertFalse((String)("User should not be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, perms));
        admin.disableTable(tableName);
        User newOwner = User.createUserForTesting((Configuration)conf, (String)"new_owner", (String[])new String[0]);
        htd.setOwner(newOwner);
        admin.modifyTable(tableName, htd);
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service4 = acl.coprocessorService(tableName.getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol4 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service4);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol4, (TableName)tableName);
        }
        finally {
            acl.close();
        }
        UserPermission newOwnerperm = new UserPermission(Bytes.toBytes((String)newOwner.getName()), tableName, null, Permission.Action.values());
        Assert.assertTrue((String)"New owner should have all permissions on table", (boolean)this.hasFoundUserPermission(newOwnerperm, perms));
        admin.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalPermissionList() throws Exception {
        List perms;
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            perms = ProtobufUtil.getUserPermissions((AccessControlProtos.AccessControlService.BlockingInterface)protocol);
        }
        finally {
            acl.close();
        }
        UserPermission adminPerm = new UserPermission(Bytes.toBytes((String)USER_ADMIN.getShortName()), AccessControlLists.ACL_TABLE_NAME, null, null, Bytes.toBytes((String)"ACRW"));
        Assert.assertTrue((String)"Only user admin has permission on table _acl_ per setup", (perms.size() == 1 && this.hasFoundUserPermission(adminPerm, perms) ? 1 : 0) != 0);
    }

    private void verifyGlobal(PrivilegedExceptionAction<?> action) throws Exception {
        this.verifyAllowed(action, SUPERUSER);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_NONE, USER_RO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkGlobalPerms(Permission.Action ... actions) throws IOException {
        Permission[] perms = new Permission[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            perms[i] = new Permission(new Permission.Action[]{actions[i]});
        }
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission.Action a : actions) {
            request.addPermission(AccessControlProtos.Permission.newBuilder().setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(AccessControlProtos.GlobalPermission.newBuilder().addAction(ProtobufUtil.toPermissionAction((Permission.Action)a)).build()));
        }
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel channel = acl.coprocessorService(new byte[0]);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)channel);
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException((ServiceException)se);
            }
        }
        finally {
            acl.close();
        }
    }

    public void checkTablePerms(TableName table, byte[] family, byte[] column, Permission.Action ... actions) throws IOException {
        Permission[] perms = new Permission[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            perms[i] = new TablePermission(table, family, column, new Permission.Action[]{actions[i]});
        }
        this.checkTablePerms(table, perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTablePerms(TableName table, Permission ... perms) throws IOException {
        AccessControlProtos.CheckPermissionsRequest.Builder request = AccessControlProtos.CheckPermissionsRequest.newBuilder();
        for (Permission p : perms) {
            request.addPermission(ProtobufUtil.toPermission((Permission)p));
        }
        HTable acl = new HTable(conf, table);
        try {
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)acl.coprocessorService(new byte[0]));
            try {
                protocol.checkPermissions(null, request.build());
            }
            catch (ServiceException se) {
                ProtobufUtil.toIOException((ServiceException)se);
            }
        }
        finally {
            acl.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckPermissions() throws Exception {
        PrivilegedExceptionAction<Void> globalAdmin = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkGlobalPerms(Permission.Action.ADMIN);
                return null;
            }
        };
        this.verifyGlobal(globalAdmin);
        PrivilegedExceptionAction<Void> globalReadWrite = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkGlobalPerms(Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        this.verifyGlobal(globalReadWrite);
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        User userTable = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_table", (String[])new String[0]);
        User userColumn = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_family", (String[])new String[0]);
        User userQualifier = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_q", (String[])new String[0]);
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel channel = acl.coprocessorService(new byte[0]);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)channel);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)userTable.getShortName(), (TableName)this.TEST_TABLE.getTableName(), null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)userColumn.getShortName(), (TableName)this.TEST_TABLE.getTableName(), (byte[])TEST_FAMILY, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)userQualifier.getShortName(), (TableName)this.TEST_TABLE.getTableName(), (byte[])TEST_FAMILY, (byte[])TEST_Q1, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
        }
        finally {
            acl.close();
        }
        PrivilegedExceptionAction<Void> tableRead = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ);
                return null;
            }
        };
        PrivilegedExceptionAction<Void> columnRead = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
                return null;
            }
        };
        PrivilegedExceptionAction<Void> qualifierRead = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ);
                return null;
            }
        };
        PrivilegedExceptionAction<Void> multiQualifierRead = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), new Permission[]{new TablePermission(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, new Permission.Action[]{Permission.Action.READ}), new TablePermission(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q2, new Permission.Action[]{Permission.Action.READ})});
                return null;
            }
        };
        PrivilegedExceptionAction<Void> globalAndTableRead = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), new Permission[]{new Permission(new Permission.Action[]{Permission.Action.READ}), new TablePermission(TestAccessController.this.TEST_TABLE.getTableName(), null, (byte[])null, new Permission.Action[]{Permission.Action.READ})});
                return null;
            }
        };
        PrivilegedExceptionAction<Void> noCheck = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), new Permission[0]);
                return null;
            }
        };
        this.verifyAllowed(tableRead, SUPERUSER, userTable);
        this.verifyDenied(tableRead, userColumn, userQualifier);
        this.verifyAllowed(columnRead, SUPERUSER, userTable, userColumn);
        this.verifyDenied(columnRead, userQualifier);
        this.verifyAllowed(qualifierRead, SUPERUSER, userTable, userColumn, userQualifier);
        this.verifyAllowed(multiQualifierRead, SUPERUSER, userTable, userColumn);
        this.verifyDenied(multiQualifierRead, userQualifier);
        this.verifyAllowed(globalAndTableRead, SUPERUSER);
        this.verifyDenied(globalAndTableRead, userTable, userColumn, userQualifier);
        this.verifyAllowed(noCheck, SUPERUSER, userTable, userColumn, userQualifier);
        PrivilegedExceptionAction<Void> familyReadWrite = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestAccessController.this.checkTablePerms(TestAccessController.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        this.verifyAllowed(familyReadWrite, SUPERUSER, USER_OWNER, USER_CREATE, USER_RW);
        this.verifyDenied(familyReadWrite, USER_NONE, USER_RO);
        AccessControlProtos.CheckPermissionsRequest checkRequest = AccessControlProtos.CheckPermissionsRequest.newBuilder().addPermission(AccessControlProtos.Permission.newBuilder().setType(AccessControlProtos.Permission.Type.Table).setTablePermission(AccessControlProtos.TablePermission.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)this.TEST_TABLE.getTableName())).addAction(AccessControlProtos.Permission.Action.CREATE))).build();
        acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel channel = acl.coprocessorService(new byte[0]);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)channel);
            try {
                protocol.checkPermissions(null, checkRequest);
                Assert.fail((String)"this should have thrown CoprocessorException");
            }
            catch (ServiceException ex) {
                // empty catch block
            }
        }
        finally {
            acl.close();
        }
    }

    @Test
    public void testStopRegionServer() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopRegionServer(ObserverContext.createAndPrepare((CoprocessorEnvironment)RSCP_ENV, null));
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        this.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE);
    }

    @Test
    public void testOpenRegion() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preOpen(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null));
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testCloseRegion() throws Exception {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preClose(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestAccessController.this.RCP_ENV, null), false);
                return null;
            }
        };
        this.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        this.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testSnapshot() throws Exception {
        PrivilegedExceptionAction snapshotAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), null, null);
                return null;
            }
        };
        PrivilegedExceptionAction deleteAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), null);
                return null;
            }
        };
        PrivilegedExceptionAction restoreAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRestoreSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), null, null);
                return null;
            }
        };
        PrivilegedExceptionAction cloneAction = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCloneSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), null, null);
                return null;
            }
        };
        this.verifyAllowed(snapshotAction, SUPERUSER, USER_ADMIN);
        this.verifyDenied(snapshotAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
        this.verifyAllowed(cloneAction, SUPERUSER, USER_ADMIN);
        this.verifyDenied(deleteAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
        this.verifyAllowed(restoreAction, SUPERUSER, USER_ADMIN);
        this.verifyDenied(restoreAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
        this.verifyAllowed(deleteAction, SUPERUSER, USER_ADMIN);
        this.verifyDenied(cloneAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalAuthorizationForNewRegisteredRS() throws Exception {
        LOG.debug((Object)"Test for global authorization for a new registered RegionServer.");
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getHBaseCluster();
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service = acl.coprocessorService(this.TEST_TABLE.getTableName().getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            String currentUser = User.getCurrent().getShortName();
            String activeUserForNewRs = currentUser + ".hfs." + hbaseCluster.getLiveRegionServerThreads().size();
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)activeUserForNewRs, (Permission.Action[])new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE});
        }
        finally {
            acl.close();
        }
        final HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE2);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        admin.createTable(htd);
        JVMClusterUtil.RegionServerThread newRsThread = hbaseCluster.startRegionServer();
        final HRegionServer newRs = newRsThread.getRegionServer();
        final HTable table = new HTable(TEST_UTIL.getConfiguration(), TEST_TABLE2);
        try {
            NavigableMap regions = table.getRegionLocations();
            final Map.Entry firstRegion = regions.entrySet().iterator().next();
            PrivilegedExceptionAction moveAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    admin.move(((HRegionInfo)firstRegion.getKey()).getEncodedNameAsBytes(), Bytes.toBytes((String)newRs.getServerName().getServerName()));
                    return null;
                }
            };
            SUPERUSER.runAs(moveAction);
            int RETRIES_LIMIT = 10;
            int retries = 0;
            while (newRs.getOnlineRegions(TEST_TABLE2).size() < 1 && retries < 10) {
                LOG.debug((Object)("Waiting for region to be opened. Already retried " + retries + " times."));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (++retries != 9) continue;
                Assert.fail((String)"Retry exhaust for waiting region to be opened.");
            }
            PrivilegedExceptionAction putAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Put put = new Put(Bytes.toBytes((String)"test"));
                    put.add(TEST_FAMILY, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value"));
                    table.put(put);
                    return null;
                }
            };
            USER_ADMIN.runAs(putAction);
        }
        finally {
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableDescriptorsEnumeration() throws Exception {
        User TABLE_ADMIN = User.createUserForTesting((Configuration)conf, (String)"UserA", (String[])new String[0]);
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service = acl.coprocessorService(this.TEST_TABLE.getTableName().getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)TABLE_ADMIN.getShortName(), (TableName)this.TEST_TABLE.getTableName(), null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.ADMIN});
        }
        finally {
            acl.close();
        }
        PrivilegedExceptionAction listTablesAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                try {
                    admin.listTables();
                }
                finally {
                    admin.close();
                }
                return null;
            }
        };
        PrivilegedExceptionAction getTableDescAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                try {
                    admin.getTableDescriptor(TestAccessController.this.TEST_TABLE.getTableName());
                }
                finally {
                    admin.close();
                }
                return null;
            }
        };
        this.verifyAllowed(listTablesAction, SUPERUSER, USER_ADMIN);
        this.verifyDenied(listTablesAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, TABLE_ADMIN);
        this.verifyAllowed(getTableDescAction, SUPERUSER, USER_ADMIN, USER_CREATE, TABLE_ADMIN);
        this.verifyDenied(getTableDescAction, USER_RW, USER_RO, USER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableDeletion() throws Exception {
        User TABLE_ADMIN = User.createUserForTesting((Configuration)conf, (String)"TestUser", (String[])new String[0]);
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            CoprocessorRpcChannel service = acl.coprocessorService(this.TEST_TABLE.getTableName().getName());
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            ProtobufUtil.grant((AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)TABLE_ADMIN.getShortName(), (TableName)this.TEST_TABLE.getTableName(), null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.ADMIN});
        }
        finally {
            acl.close();
        }
        PrivilegedExceptionAction deleteTableAction = new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                try {
                    admin.disableTable(TestAccessController.this.TEST_TABLE.getTableName());
                    admin.deleteTable(TestAccessController.this.TEST_TABLE.getTableName());
                }
                finally {
                    admin.close();
                }
                return null;
            }
        };
        this.verifyDenied(deleteTableAction, USER_RW, USER_RO, USER_NONE);
        this.verifyAllowed(deleteTableAction, TABLE_ADMIN);
    }

    static {
        TEST_TABLE2 = TableName.valueOf((String)"testtable2");
        TEST_FAMILY = Bytes.toBytes((String)"f1");
    }

    public class BulkLoadHelper {
        private final FileSystem fs = TestAccessController.access$600().getTestFileSystem();
        private final Path loadPath;
        private final Configuration conf = TestAccessController.access$600().getConfiguration();

        public BulkLoadHelper(Path loadPath) throws IOException {
            this.loadPath = loadPath = loadPath.makeQualified(this.fs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createHFile(Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
            HFile.Writer writer = null;
            long now = System.currentTimeMillis();
            try {
                writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)new CacheConfig(this.conf)).withPath(this.fs, path).create();
                for (byte[] key : Bytes.iterateOnSplits((byte[])startKey, (byte[])endKey, (boolean)true, (int)(numRows - 2))) {
                    KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                    writer.append(kv);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bulkLoadHFile(TableName tableName, byte[] family, byte[] qualifier, byte[][][] hfileRanges, int numRowsPerRange) throws Exception {
            Path familyDir = new Path(this.loadPath, Bytes.toString((byte[])family));
            this.fs.mkdirs(familyDir);
            int hfileIdx = 0;
            for (byte[][] range : hfileRanges) {
                byte[] from = range[0];
                byte[] to = range[1];
                this.createHFile(new Path(familyDir, "hfile_" + hfileIdx++), family, qualifier, from, to, numRowsPerRange);
            }
            this.setPermission(this.loadPath, FsPermission.valueOf((String)"-rwxrwxrwx"));
            HTable table = new HTable(this.conf, tableName);
            try {
                HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
                TEST_UTIL.waitTableEnabled(admin, tableName.getName());
                LoadIncrementalHFiles loader = new LoadIncrementalHFiles(this.conf);
                loader.doBulkLoad(this.loadPath, table);
            }
            finally {
                table.close();
            }
        }

        public void setPermission(Path dir, FsPermission perm) throws IOException {
            if (!this.fs.getFileStatus(dir).isDir()) {
                this.fs.setPermission(dir, perm);
            } else {
                for (FileStatus el : this.fs.listStatus(dir)) {
                    this.fs.setPermission(el.getPath(), perm);
                    this.setPermission(el.getPath(), perm);
                }
            }
        }
    }
}

