/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Header;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRowResource {
    private static final String TABLE = "TestRowResource";
    private static final String CFA = "a";
    private static final String CFB = "b";
    private static final String COLUMN_1 = "a:1";
    private static final String COLUMN_2 = "b:2";
    private static final String COLUMN_3 = "a:";
    private static final String ROW_1 = "testrow1";
    private static final String VALUE_1 = "testvalue1";
    private static final String ROW_2 = "testrow2";
    private static final String VALUE_2 = "testvalue2";
    private static final String ROW_3 = "testrow3";
    private static final String VALUE_3 = "testvalue3";
    private static final String ROW_4 = "testrow4";
    private static final String VALUE_4 = "testvalue4";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static final MetricsAssertHelper METRICS_ASSERT = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static Client client;
    private static JAXBContext context;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(3);
        REST_TEST_UTIL.startServletContainer(conf);
        context = JAXBContext.newInstance((Class[])new Class[]{CellModel.class, CellSetModel.class, RowModel.class});
        marshaller = context.createMarshaller();
        unmarshaller = context.createUnmarshaller();
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
    }

    @Before
    public void beforeMethod() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(TABLE)) {
            return;
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TABLE));
        htd.addFamily(new HColumnDescriptor(CFA));
        htd.addFamily(new HColumnDescriptor(CFB));
        admin.createTable(htd);
    }

    @After
    public void afterMethod() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(TABLE)) {
            admin.disableTable(TABLE);
            admin.deleteTable(TABLE);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static Response deleteRow(String table, String row) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        Response response = client.delete(path.toString());
        Thread.yield();
        return response;
    }

    private static Response deleteValue(String table, String row, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        Response response = client.delete(path.toString());
        Thread.yield();
        return response;
    }

    private static Response getValueXML(String table, String row, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return TestRowResource.getValueXML(path.toString());
    }

    private static Response getValueXML(String table, String startRow, String endRow, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(startRow);
        path.append(",");
        path.append(endRow);
        path.append('/');
        path.append(column);
        return TestRowResource.getValueXML(path.toString());
    }

    private static Response getValueXML(String url) throws IOException {
        Response response = client.get(url, "text/xml");
        return response;
    }

    private static Response getValuePB(String table, String row, String column) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return TestRowResource.getValuePB(path.toString());
    }

    private static Response getValuePB(String url) throws IOException {
        Response response = client.get(url, "application/x-protobuf");
        return response;
    }

    private static Response putValueXML(String table, String row, String column, String value) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return TestRowResource.putValueXML(path.toString(), table, row, column, value);
    }

    private static Response putValueXML(String url, String table, String row, String column, String value) throws IOException, JAXBException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)value)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(url, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        return response;
    }

    private static void checkValueXML(String table, String row, String column, String value) throws IOException, JAXBException {
        Response response = TestRowResource.getValueXML(table, row, column);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getValue()), (Object)value);
    }

    private static void checkValueXML(String url, String table, String row, String column, String value) throws IOException, JAXBException {
        Response response = TestRowResource.getValueXML(url);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getValue()), (Object)value);
    }

    private static Response putValuePB(String table, String row, String column, String value) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append('/');
        path.append(column);
        return TestRowResource.putValuePB(path.toString(), table, row, column, value);
    }

    private static Response putValuePB(String url, String table, String row, String column, String value) throws IOException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)value)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        Response response = client.put(url, "application/x-protobuf", cellSetModel.createProtobufOutput());
        Thread.yield();
        return response;
    }

    private static void checkValuePB(String table, String row, String column, String value) throws IOException {
        Response response = TestRowResource.getValuePB(table, row, column);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = new CellSetModel();
        cellSet.getObjectFromMessage(response.getBody());
        RowModel rowModel = (RowModel)cellSet.getRows().get(0);
        CellModel cell = (CellModel)rowModel.getCells().get(0);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getColumn()), (Object)column);
        Assert.assertEquals((Object)Bytes.toString((byte[])cell.getValue()), (Object)value);
    }

    private static Response checkAndPutValuePB(String url, String table, String row, String column, String valueToCheck, String valueToPut) throws IOException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToPut)));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        Response response = client.put(url, "application/x-protobuf", cellSetModel.createProtobufOutput());
        Thread.yield();
        return response;
    }

    private static Response checkAndPutValuePB(String table, String row, String column, String valueToCheck, String valueToPut) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=put");
        return TestRowResource.checkAndPutValuePB(path.toString(), table, row, column, valueToCheck, valueToPut);
    }

    private static Response checkAndPutValueXML(String url, String table, String row, String column, String valueToCheck, String valueToPut) throws IOException, JAXBException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToPut)));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(url, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        return response;
    }

    private static Response checkAndPutValueXML(String table, String row, String column, String valueToCheck, String valueToPut) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=put");
        return TestRowResource.checkAndPutValueXML(path.toString(), table, row, column, valueToCheck, valueToPut);
    }

    private static Response checkAndDeleteXML(String url, String table, String row, String column, String valueToCheck) throws IOException, JAXBException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(url, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        return response;
    }

    private static Response checkAndDeleteXML(String table, String row, String column, String valueToCheck) throws IOException, JAXBException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=delete");
        return TestRowResource.checkAndDeleteXML(path.toString(), table, row, column, valueToCheck);
    }

    private static Response checkAndDeletePB(String table, String row, String column, String value) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(table);
        path.append('/');
        path.append(row);
        path.append("?check=delete");
        return TestRowResource.checkAndDeleteValuePB(path.toString(), table, row, column, value);
    }

    private static Response checkAndDeleteValuePB(String url, String table, String row, String column, String valueToCheck) throws IOException {
        RowModel rowModel = new RowModel(row);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)column), Bytes.toBytes((String)valueToCheck)));
        CellSetModel cellSetModel = new CellSetModel();
        cellSetModel.addRow(rowModel);
        Response response = client.put(url, "application/x-protobuf", cellSetModel.createProtobufOutput());
        Thread.yield();
        return response;
    }

    @Test
    public void testDelete() throws IOException, JAXBException {
        Response response = TestRowResource.putValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.putValueXML(TABLE, ROW_1, COLUMN_2, VALUE_2);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1);
        TestRowResource.checkValueXML(TABLE, ROW_1, COLUMN_2, VALUE_2);
        response = TestRowResource.deleteValue(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.getValueXML(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)404L);
        TestRowResource.checkValueXML(TABLE, ROW_1, COLUMN_2, VALUE_2);
        response = TestRowResource.putValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.checkAndDeletePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.getValueXML(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.getValueXML(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestRowResource.getValueXML(TABLE, ROW_1, COLUMN_2);
        Assert.assertEquals((long)response.getCode(), (long)404L);
    }

    @Test
    public void testForbidden() throws IOException, JAXBException {
        conf.set("hbase.rest.readonly", "true");
        Response response = TestRowResource.putValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestRowResource.putValuePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestRowResource.checkAndPutValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1, VALUE_2);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestRowResource.checkAndPutValuePB(TABLE, ROW_1, COLUMN_1, VALUE_1, VALUE_2);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestRowResource.deleteValue(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestRowResource.checkAndDeletePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        conf.set("hbase.rest.readonly", "false");
        response = TestRowResource.putValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.putValuePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.checkAndPutValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1, VALUE_2);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.checkAndPutValuePB(TABLE, ROW_1, COLUMN_1, VALUE_2, VALUE_3);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.deleteValue(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSingleCellGetPutXML() throws IOException, JAXBException {
        Response response = TestRowResource.getValueXML(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestRowResource.putValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1);
        response = TestRowResource.putValueXML(TABLE, ROW_1, COLUMN_1, VALUE_2);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValueXML(TABLE, ROW_1, COLUMN_1, VALUE_2);
        response = TestRowResource.checkAndPutValueXML(TABLE, ROW_1, COLUMN_1, VALUE_2, VALUE_3);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValueXML(TABLE, ROW_1, COLUMN_1, VALUE_3);
        response = TestRowResource.checkAndDeleteXML(TABLE, ROW_1, COLUMN_1, VALUE_3);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSingleCellGetPutPB() throws IOException, JAXBException {
        Response response = TestRowResource.getValuePB(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestRowResource.putValuePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValuePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        response = TestRowResource.putValuePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValuePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        response = TestRowResource.putValueXML(TABLE, ROW_1, COLUMN_1, VALUE_2);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValuePB(TABLE, ROW_1, COLUMN_1, VALUE_2);
        response = TestRowResource.checkAndPutValuePB(TABLE, ROW_1, COLUMN_1, VALUE_2, VALUE_3);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValuePB(TABLE, ROW_1, COLUMN_1, VALUE_3);
        response = TestRowResource.checkAndPutValueXML(TABLE, ROW_1, COLUMN_1, VALUE_3, VALUE_4);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValuePB(TABLE, ROW_1, COLUMN_1, VALUE_4);
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSingleCellGetPutBinary() throws IOException {
        String path = "/TestRowResource/testrow3/a:1";
        byte[] body = Bytes.toBytes((String)VALUE_3);
        Response response = client.put("/TestRowResource/testrow3/a:1", "application/octet-stream", body);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Thread.yield();
        response = client.get("/TestRowResource/testrow3/a:1", "application/octet-stream");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/octet-stream", (Object)response.getHeader("content-type"));
        Assert.assertTrue((boolean)Bytes.equals((byte[])response.getBody(), (byte[])body));
        boolean foundTimestampHeader = false;
        for (Header header : response.getHeaders()) {
            if (!header.getName().equals("X-Timestamp")) continue;
            foundTimestampHeader = true;
            break;
        }
        Assert.assertTrue((boolean)foundTimestampHeader);
        response = TestRowResource.deleteRow(TABLE, ROW_3);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSingleCellGetJSON() throws IOException, JAXBException {
        String path = "/TestRowResource/testrow4/a:1";
        Response response = client.put("/TestRowResource/testrow4/a:1", "application/octet-stream", Bytes.toBytes((String)VALUE_4));
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Thread.yield();
        response = client.get("/TestRowResource/testrow4/a:1", "application/json");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        response = TestRowResource.deleteRow(TABLE, ROW_4);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testMetrics() throws IOException, JAXBException {
        String path = "/TestRowResource/testrow4/a:1";
        Response response = client.put("/TestRowResource/testrow4/a:1", "application/octet-stream", Bytes.toBytes((String)VALUE_4));
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Thread.yield();
        response = client.get("/TestRowResource/testrow4/a:1", "application/json");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        response = TestRowResource.deleteRow(TABLE, ROW_4);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        UserGroupInformation ugi = User.getCurrent().getUGI();
        METRICS_ASSERT.assertCounterGt("requests", 2L, (BaseSource)RESTServlet.getInstance((Configuration)conf, (UserGroupInformation)ugi).getMetrics().getSource());
        METRICS_ASSERT.assertCounterGt("successfulGet", 0L, (BaseSource)RESTServlet.getInstance((Configuration)conf, (UserGroupInformation)ugi).getMetrics().getSource());
        METRICS_ASSERT.assertCounterGt("successfulPut", 0L, (BaseSource)RESTServlet.getInstance((Configuration)conf, (UserGroupInformation)ugi).getMetrics().getSource());
        METRICS_ASSERT.assertCounterGt("successfulDelete", 0L, (BaseSource)RESTServlet.getInstance((Configuration)conf, (UserGroupInformation)ugi).getMetrics().getSource());
    }

    @Test
    public void testURLEncodedKey() throws IOException, JAXBException {
        String urlKey = "http://example.com/foo";
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append(TABLE);
        path.append('/');
        path.append(URLEncoder.encode(urlKey, "UTF-8"));
        path.append('/');
        path.append(COLUMN_1);
        Response response = TestRowResource.putValueXML(path.toString(), TABLE, urlKey, COLUMN_1, VALUE_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestRowResource.checkValueXML(path.toString(), TABLE, urlKey, COLUMN_1, VALUE_1);
    }

    @Test
    public void testNoSuchCF() throws IOException, JAXBException {
        String goodPath = "/TestRowResource/testrow1/a:";
        String badPath = "/TestRowResource/testrow1/BAD";
        Response response = client.post("/TestRowResource/testrow1/a:", "application/octet-stream", Bytes.toBytes((String)VALUE_1));
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((long)client.get("/TestRowResource/testrow1/a:", "application/octet-stream").getCode(), (long)200L);
        Assert.assertEquals((long)client.get("/TestRowResource/testrow1/BAD", "application/octet-stream").getCode(), (long)404L);
        Assert.assertEquals((long)client.get("/TestRowResource/testrow1/a:", "application/octet-stream").getCode(), (long)200L);
    }

    @Test
    public void testMultiCellGetPutXML() throws IOException, JAXBException {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel(ROW_1);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_1), Bytes.toBytes((String)VALUE_1)));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_2), Bytes.toBytes((String)VALUE_2)));
        cellSetModel.addRow(rowModel);
        rowModel = new RowModel(ROW_2);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_1), Bytes.toBytes((String)VALUE_3)));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_2), Bytes.toBytes((String)VALUE_4)));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(path, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        response = client.get(path, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        TestRowResource.checkValueXML(TABLE, ROW_1, COLUMN_1, VALUE_1);
        TestRowResource.checkValueXML(TABLE, ROW_1, COLUMN_2, VALUE_2);
        TestRowResource.checkValueXML(TABLE, ROW_2, COLUMN_1, VALUE_3);
        TestRowResource.checkValueXML(TABLE, ROW_2, COLUMN_2, VALUE_4);
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.deleteRow(TABLE, ROW_2);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testMultiCellGetPutPB() throws IOException {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel(ROW_1);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_1), Bytes.toBytes((String)VALUE_1)));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_2), Bytes.toBytes((String)VALUE_2)));
        cellSetModel.addRow(rowModel);
        rowModel = new RowModel(ROW_2);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_1), Bytes.toBytes((String)VALUE_3)));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_2), Bytes.toBytes((String)VALUE_4)));
        cellSetModel.addRow(rowModel);
        Response response = client.put(path, "application/x-protobuf", cellSetModel.createProtobufOutput());
        Thread.yield();
        response = client.get(path, "application/x-protobuf");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        TestRowResource.checkValuePB(TABLE, ROW_1, COLUMN_1, VALUE_1);
        TestRowResource.checkValuePB(TABLE, ROW_1, COLUMN_2, VALUE_2);
        TestRowResource.checkValuePB(TABLE, ROW_2, COLUMN_1, VALUE_3);
        TestRowResource.checkValuePB(TABLE, ROW_2, COLUMN_2, VALUE_4);
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.deleteRow(TABLE, ROW_2);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testStartEndRowGetPutXML() throws IOException, JAXBException {
        String[] rows = new String[]{ROW_1, ROW_2, ROW_3};
        String[] values = new String[]{VALUE_1, VALUE_2, VALUE_3};
        Response response = null;
        for (int i = 0; i < rows.length; ++i) {
            response = TestRowResource.putValueXML(TABLE, rows[i], COLUMN_1, values[i]);
            Assert.assertEquals((long)200L, (long)response.getCode());
            TestRowResource.checkValueXML(TABLE, rows[i], COLUMN_1, values[i]);
        }
        response = TestRowResource.getValueXML(TABLE, rows[0], rows[2], COLUMN_1);
        Assert.assertEquals((long)200L, (long)response.getCode());
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertEquals((long)2L, (long)cellSet.getRows().size());
        for (int i = 0; i < cellSet.getRows().size() - 1; ++i) {
            RowModel rowModel = (RowModel)cellSet.getRows().get(i);
            for (CellModel cell : rowModel.getCells()) {
                Assert.assertEquals((Object)COLUMN_1, (Object)Bytes.toString((byte[])cell.getColumn()));
                Assert.assertEquals((Object)values[i], (Object)Bytes.toString((byte[])cell.getValue()));
            }
        }
        for (String row : rows) {
            response = TestRowResource.deleteRow(TABLE, row);
            Assert.assertEquals((long)200L, (long)response.getCode());
        }
    }

    @Test
    public void testInvalidCheckParam() throws IOException, JAXBException {
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel(ROW_1);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_1), Bytes.toBytes((String)VALUE_1)));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)cellSetModel, (Writer)writer);
        String path = "/TestRowResource/testrow1/a:1?check=blah";
        Response response = client.put("/TestRowResource/testrow1/a:1?check=blah", "text/xml", Bytes.toBytes((String)writer.toString()));
        Assert.assertEquals((long)response.getCode(), (long)400L);
    }

    @Test
    public void testLatestCellGetXML() throws IOException, JAXBException {
        String path = "/TestRowResource/testrow1/a:1";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel(ROW_1);
        CellModel cellOne = new CellModel(Bytes.toBytes((String)COLUMN_1), 1L, Bytes.toBytes((String)VALUE_1));
        CellModel cellTwo = new CellModel(Bytes.toBytes((String)COLUMN_1), 2L, Bytes.toBytes((String)VALUE_2));
        rowModel.addCell(cellOne);
        rowModel.addCell(cellTwo);
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put("/TestRowResource/testrow1/a:1", "text/xml", Bytes.toBytes((String)writer.toString()));
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestRowResource.getValueXML(TABLE, ROW_1, COLUMN_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertTrue((cellSet.getRows().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((RowModel)cellSet.getRows().get(0)).getCells().size() == 1 ? 1 : 0) != 0);
        CellModel cell = (CellModel)((RowModel)cellSet.getRows().get(0)).getCells().get(0);
        Assert.assertEquals((Object)VALUE_2, (Object)Bytes.toString((byte[])cell.getValue()));
        Assert.assertEquals((long)2L, (long)cell.getTimestamp());
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testMultiColumnGetXML() throws Exception {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel(ROW_1);
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_1), Bytes.toBytes((String)VALUE_1)));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_2), Bytes.toBytes((String)VALUE_2)));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)COLUMN_3), Bytes.toBytes((String)VALUE_2)));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(path, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        response = client.get(path, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        path = "/TestRowResource/testrow1/a:1,b:2,a:";
        response = client.get(path, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertTrue((cellSet.getRows().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((RowModel)cellSet.getRows().get(0)).getCells().size() == 3 ? 1 : 0) != 0);
        List cells = ((RowModel)cellSet.getRows().get(0)).getCells();
        Assert.assertTrue((boolean)this.containsCellModel(cells, COLUMN_1, VALUE_1));
        Assert.assertTrue((boolean)this.containsCellModel(cells, COLUMN_2, VALUE_2));
        Assert.assertTrue((boolean)this.containsCellModel(cells, COLUMN_3, VALUE_2));
        response = TestRowResource.deleteRow(TABLE, ROW_1);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    private boolean containsCellModel(List<CellModel> cells, String column, String value) {
        boolean contains = false;
        for (CellModel cell : cells) {
            if (!Bytes.toString((byte[])cell.getColumn()).equals(column) || !Bytes.toString((byte[])cell.getValue()).equals(value)) continue;
            contains = true;
            return contains;
        }
        return contains;
    }
}

