/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSink;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationSink {
    private static final Log LOG = LogFactory.getLog(TestReplicationSink.class);
    private static final int BATCH_SIZE = 10;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ReplicationSink SINK;
    private static final byte[] TABLE_NAME1;
    private static final byte[] TABLE_NAME2;
    private static final byte[] FAM_NAME1;
    private static final byte[] FAM_NAME2;
    private static HTable table1;
    private static Stoppable STOPPABLE;
    private static HTable table2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.replication", true);
        TEST_UTIL.startMiniCluster(3);
        SINK = new ReplicationSink(new Configuration(TEST_UTIL.getConfiguration()), STOPPABLE);
        table1 = TEST_UTIL.createTable(TABLE_NAME1, FAM_NAME1);
        table2 = TEST_UTIL.createTable(TABLE_NAME2, FAM_NAME2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        STOPPABLE.stop("Shutting down");
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        table1 = TEST_UTIL.truncateTable(TABLE_NAME1);
        table2 = TEST_UTIL.truncateTable(TABLE_NAME2);
    }

    @Test
    public void testBatchSink() throws Exception {
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(10);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()));
        Scan scan = new Scan();
        ResultScanner scanRes = table1.getScanner(scan);
        Assert.assertEquals((long)10L, (long)scanRes.next(10).length);
    }

    @Test
    public void testMixedPutDelete() throws Exception {
        int i;
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(5);
        ArrayList<Object> cells = new ArrayList<Cell>();
        for (i = 0; i < 5; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells));
        entries = new ArrayList(10);
        cells = new ArrayList();
        for (i = 0; i < 10; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, i % 2 != 0 ? KeyValue.Type.Put : KeyValue.Type.DeleteColumn, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()));
        Scan scan = new Scan();
        ResultScanner scanRes = table1.getScanner(scan);
        Assert.assertEquals((long)5L, (long)scanRes.next(10).length);
    }

    @Test
    public void testMixedPutTables() throws Exception {
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(5);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < 10; ++i) {
            entries.add(this.createEntry(i % 2 == 0 ? TABLE_NAME2 : TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()));
        Scan scan = new Scan();
        ResultScanner scanRes = table2.getScanner(scan);
        for (Result res : scanRes) {
            Assert.assertTrue((Bytes.toInt((byte[])res.getRow()) % 2 == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMixedDeletes() throws Exception {
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(3);
        ArrayList<Object> cells = new ArrayList<Cell>();
        for (int i = 0; i < 3; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()));
        entries = new ArrayList(3);
        cells = new ArrayList();
        entries.add(this.createEntry(TABLE_NAME1, 0, KeyValue.Type.DeleteColumn, cells));
        entries.add(this.createEntry(TABLE_NAME1, 1, KeyValue.Type.DeleteFamily, cells));
        entries.add(this.createEntry(TABLE_NAME1, 2, KeyValue.Type.DeleteColumn, cells));
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()));
        Scan scan = new Scan();
        ResultScanner scanRes = table1.getScanner(scan);
        Assert.assertEquals((long)0L, (long)scanRes.next(3).length);
    }

    @Test
    public void testApplyDeleteBeforePut() throws Exception {
        int i;
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>(5);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (i = 0; i < 2; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        entries.add(this.createEntry(TABLE_NAME1, 1, KeyValue.Type.DeleteFamily, cells));
        for (i = 3; i < 5; ++i) {
            entries.add(this.createEntry(TABLE_NAME1, i, KeyValue.Type.Put, cells));
        }
        SINK.replicateEntries(entries, CellUtil.createCellScanner(cells.iterator()));
        Get get = new Get(Bytes.toBytes((int)1));
        Result res = table1.get(get);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    private AdminProtos.WALEntry createEntry(byte[] table, int row, KeyValue.Type type, List<Cell> cells) {
        byte[] fam = Bytes.equals((byte[])table, (byte[])TABLE_NAME1) ? FAM_NAME1 : FAM_NAME2;
        byte[] rowBytes = Bytes.toBytes((int)row);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Was interrupted while sleep, meh", (Throwable)e);
        }
        long now = System.currentTimeMillis();
        KeyValue kv = null;
        if (type.getCode() == KeyValue.Type.Put.getCode()) {
            kv = new KeyValue(rowBytes, fam, fam, now, KeyValue.Type.Put, Bytes.toBytes((int)row));
        } else if (type.getCode() == KeyValue.Type.DeleteColumn.getCode()) {
            kv = new KeyValue(rowBytes, fam, fam, now, KeyValue.Type.DeleteColumn);
        } else if (type.getCode() == KeyValue.Type.DeleteFamily.getCode()) {
            kv = new KeyValue(rowBytes, fam, null, now, KeyValue.Type.DeleteFamily);
        }
        AdminProtos.WALEntry.Builder builder = AdminProtos.WALEntry.newBuilder();
        builder.setAssociatedCellCount(1);
        WALProtos.WALKey.Builder keyBuilder = WALProtos.WALKey.newBuilder();
        HBaseProtos.UUID.Builder uuidBuilder = HBaseProtos.UUID.newBuilder();
        uuidBuilder.setLeastSigBits(HConstants.DEFAULT_CLUSTER_ID.getLeastSignificantBits());
        uuidBuilder.setMostSigBits(HConstants.DEFAULT_CLUSTER_ID.getMostSignificantBits());
        keyBuilder.setClusterId(uuidBuilder.build());
        keyBuilder.setTableName(ByteString.copyFrom((byte[])table));
        keyBuilder.setWriteTime(now);
        keyBuilder.setEncodedRegionName(ByteString.copyFrom((byte[])HConstants.EMPTY_BYTE_ARRAY));
        keyBuilder.setLogSequenceNumber(-1L);
        builder.setKey(keyBuilder.build());
        cells.add((Cell)kv);
        return builder.build();
    }

    static {
        TABLE_NAME1 = Bytes.toBytes((String)"table1");
        TABLE_NAME2 = Bytes.toBytes((String)"table2");
        FAM_NAME1 = Bytes.toBytes((String)"info1");
        FAM_NAME2 = Bytes.toBytes((String)"info2");
        STOPPABLE = new Stoppable(){
            final AtomicBoolean stop = new AtomicBoolean(false);

            public boolean isStopped() {
                return this.stop.get();
            }

            public void stop(String why) {
                LOG.info((Object)("STOPPING BECAUSE: " + why));
                this.stop.set(true);
            }
        };
    }
}

