/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDurability {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static FileSystem FS;
    private static MiniDFSCluster CLUSTER;
    private static Configuration CONF;
    private static final Path DIR;
    private static byte[] FAMILY;
    private static byte[] ROW;
    private static byte[] COL;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CONF = TEST_UTIL.getConfiguration();
        CONF.setLong("hbase.regionserver.optionallogflushinterval", 500000L);
        TEST_UTIL.startMiniDFSCluster(1);
        CLUSTER = TEST_UTIL.getDFSCluster();
        FS = CLUSTER.getFileSystem();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDurability() throws Exception {
        HLog wal = HLogFactory.createHLog((FileSystem)FS, (Path)DIR, (String)"hlogdir", (String)"hlogdir_archive", (Configuration)CONF);
        byte[] tableName = Bytes.toBytes((String)"TestDurability");
        HRegion region = this.createHRegion(tableName, "region", wal, false);
        HRegion deferredRegion = this.createHRegion(tableName, "deferredRegion", wal, true);
        region.put(this.newPut(null));
        this.verifyHLogCount(wal, 1);
        deferredRegion.put(this.newPut(null));
        this.verifyHLogCount(wal, 1);
        wal.sync();
        this.verifyHLogCount(wal, 2);
        deferredRegion.put(this.newPut(null));
        this.verifyHLogCount(wal, 2);
        region.put(this.newPut(null));
        this.verifyHLogCount(wal, 4);
        deferredRegion.put(this.newPut(Durability.USE_DEFAULT));
        this.verifyHLogCount(wal, 4);
        region.put(this.newPut(Durability.USE_DEFAULT));
        this.verifyHLogCount(wal, 6);
        region.put(this.newPut(Durability.SKIP_WAL));
        deferredRegion.put(this.newPut(Durability.SKIP_WAL));
        this.verifyHLogCount(wal, 6);
        wal.sync();
        this.verifyHLogCount(wal, 6);
        region.put(this.newPut(Durability.ASYNC_WAL));
        deferredRegion.put(this.newPut(Durability.ASYNC_WAL));
        this.verifyHLogCount(wal, 6);
        wal.sync();
        this.verifyHLogCount(wal, 8);
        region.put(this.newPut(Durability.SYNC_WAL));
        deferredRegion.put(this.newPut(Durability.SYNC_WAL));
        this.verifyHLogCount(wal, 10);
        region.put(this.newPut(Durability.FSYNC_WAL));
        deferredRegion.put(this.newPut(Durability.FSYNC_WAL));
        this.verifyHLogCount(wal, 12);
    }

    private Put newPut(Durability durability) {
        Put p = new Put(ROW);
        p.add(FAMILY, COL, COL);
        if (durability != null) {
            p.setDurability(durability);
        }
        return p;
    }

    private void verifyHLogCount(HLog log, int expected) throws Exception {
        Path walPath = ((FSHLog)log).computeFilename();
        HLog.Reader reader = HLogFactory.createReader((FileSystem)FS, (Path)walPath, (Configuration)CONF);
        int count = 0;
        HLog.Entry entry = new HLog.Entry();
        while (reader.next(entry) != null) {
            ++count;
        }
        reader.close();
        Assert.assertEquals((long)expected, (long)count);
    }

    private HRegion createHRegion(byte[] tableName, String callingMethod, HLog log, boolean isDeferredLogFlush) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        htd.setDeferredLogFlush(isDeferredLogFlush);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Path path = new Path(DIR + callingMethod);
        if (FS.exists(path) && !FS.delete(path, true)) {
            throw new IOException("Failed delete of " + path);
        }
        return HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)HBaseConfiguration.create(), (HTableDescriptor)htd, (HLog)log);
    }

    static {
        DIR = TEST_UTIL.getDataTestDir("TestDurability");
        FAMILY = Bytes.toBytes((String)"family");
        ROW = Bytes.toBytes((String)"row");
        COL = Bytes.toBytes((String)"col");
    }
}

