/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRSStatusServlet {
    private HRegionServer rs;
    static final int FAKE_IPC_PORT = 1585;
    static final int FAKE_WEB_PORT = 1586;
    private final ServerName fakeServerName = new ServerName("localhost", 1585, 11111L);
    private final AdminProtos.GetServerInfoResponse fakeResponse = ResponseConverter.buildGetServerInfoResponse((ServerName)this.fakeServerName, (int)1586);
    private final ServerName fakeMasterAddress = new ServerName("localhost", 60010, 1212121212L);

    @Before
    public void setupBasicMocks() throws IOException, ServiceException {
        this.rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        ((HRegionServer)Mockito.doReturn((Object)HBaseConfiguration.create()).when((Object)this.rs)).getConfiguration();
        ((HRegionServer)Mockito.doReturn((Object)this.fakeResponse).when((Object)this.rs)).getServerInfo((RpcController)Mockito.any(), (AdminProtos.GetServerInfoRequest)Mockito.any());
        ZooKeeperWatcher zkw = (ZooKeeperWatcher)Mockito.mock(ZooKeeperWatcher.class);
        ((ZooKeeperWatcher)Mockito.doReturn((Object)"fakequorum").when((Object)zkw)).getQuorum();
        ((HRegionServer)Mockito.doReturn((Object)zkw).when((Object)this.rs)).getZooKeeper();
        MasterAddressTracker mat = (MasterAddressTracker)Mockito.mock(MasterAddressTracker.class);
        ((MasterAddressTracker)Mockito.doReturn((Object)this.fakeMasterAddress).when((Object)mat)).getMasterAddress();
        ((HRegionServer)Mockito.doReturn((Object)mat).when((Object)this.rs)).getMasterAddressManager();
        MetricsRegionServer rms = (MetricsRegionServer)Mockito.mock(MetricsRegionServer.class);
        ((MetricsRegionServer)Mockito.doReturn((Object)new MetricsRegionServerWrapperStub()).when((Object)rms)).getRegionServerWrapper();
        ((HRegionServer)Mockito.doReturn((Object)rms).when((Object)this.rs)).getMetrics();
    }

    @Test
    public void testBasic() throws IOException, ServiceException {
        new RSStatusTmpl().render((Writer)new StringWriter(), this.rs);
    }

    @Test
    public void testWithRegions() throws IOException, ServiceException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"mytable"));
        ArrayList regions = Lists.newArrayList((Object[])new HRegionInfo[]{new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"d")), new HRegionInfo(htd.getTableName(), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"z"))});
        ((HRegionServer)Mockito.doReturn((Object)ResponseConverter.buildGetOnlineRegionResponse((List)regions)).when((Object)this.rs)).getOnlineRegion((RpcController)Mockito.any(), (AdminProtos.GetOnlineRegionRequest)Mockito.any());
        new RSStatusTmpl().render((Writer)new StringWriter(), this.rs);
    }
}

