/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.migration.NamespaceUpgrade;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.util.VersionInfo;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestNamespaceUpgrade {
    static final Log LOG = LogFactory.getLog(TestNamespaceUpgrade.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String[] snapshot1Keys = new String[]{"1", "10", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final String[] snapshot2Keys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final String[] currentKeys = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "A"};
    private static final String[] tables = new String[]{"foo", "ns1.foo", "ns.two.foo"};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(1);
        Path testdir = TEST_UTIL.getDataTestDir("TestNamespaceUpgrade");
        File untar = TestNamespaceUpgrade.untar(new File(testdir.toString()));
        Configuration conf = TEST_UTIL.getConfiguration();
        FsShell shell = new FsShell(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path hbaseRootDir = TEST_UTIL.getDefaultRootDirPath();
        if (!fs.isDirectory(hbaseRootDir.getParent())) {
            fs.mkdirs(hbaseRootDir.getParent());
        }
        if (VersionInfo.getVersion().startsWith("2.")) {
            LOG.info((Object)"Hadoop version is 2.x, pre-migrating snapshot dir");
            LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
            if (!localFS.rename(new Path(untar.toString(), ".snapshot"), new Path(untar.toString(), ".hbase-snapshot"))) {
                throw new IllegalStateException("Failed to move snapshot dir to 2.x expectation");
            }
        }
        TestNamespaceUpgrade.doFsCommand(shell, new String[]{"-put", untar.toURI().toString(), hbaseRootDir.toString()});
        TestNamespaceUpgrade.doFsCommand(shell, new String[]{"-lsr", "/"});
        Configuration toolConf = TEST_UTIL.getConfiguration();
        conf.set("hbase.rootdir", TEST_UTIL.getDefaultRootDirPath().toString());
        ToolRunner.run((Configuration)toolConf, (Tool)new NamespaceUpgrade(), (String[])new String[]{"--upgrade"});
        Assert.assertTrue((boolean)FSUtils.getVersion((FileSystem)fs, (Path)hbaseRootDir).equals("8"));
        TestNamespaceUpgrade.doFsCommand(shell, new String[]{"-lsr", "/"});
        TEST_UTIL.startMiniHBaseCluster(1, 1);
        for (String table : tables) {
            int count = 0;
            for (Result res : new HTable(TEST_UTIL.getConfiguration(), table).getScanner(new Scan())) {
                Assert.assertEquals((Object)currentKeys[count++], (Object)Bytes.toString((byte[])res.getRow()));
            }
            Assert.assertEquals((long)currentKeys.length, (long)count);
        }
        Assert.assertEquals((long)2L, (long)TEST_UTIL.getHBaseAdmin().listNamespaceDescriptors().length);
        HTable secureTable = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        ResultScanner scanner = secureTable.getScanner(new Scan());
        int count = 0;
        for (Result r : scanner) {
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertFalse((boolean)TEST_UTIL.getHBaseAdmin().tableExists("_acl_"));
        List<HRegion> regions = TEST_UTIL.getMiniHBaseCluster().getRegions(secureTable.getName());
        for (HRegion region : regions) {
            Assert.assertEquals((long)1L, (long)region.getStores().size());
        }
    }

    static File untar(File testdir) throws IOException {
        String datafile = "TestNamespaceUpgrade";
        File srcTarFile = new File(System.getProperty("project.build.testSourceDirectory", "src/test") + File.separator + "data" + File.separator + "TestNamespaceUpgrade" + ".tgz");
        File homedir = new File(testdir.toString());
        File tgtUntarDir = new File(homedir, "hbase");
        if (tgtUntarDir.exists() && !FileUtil.fullyDelete((File)tgtUntarDir)) {
            throw new IOException("Failed delete of " + tgtUntarDir.toString());
        }
        if (!srcTarFile.exists()) {
            throw new IOException(srcTarFile + " does not exist");
        }
        LOG.info((Object)("Untarring " + srcTarFile + " into " + homedir.toString()));
        FileUtil.unTar((File)srcTarFile, (File)homedir);
        Assert.assertTrue((boolean)tgtUntarDir.exists());
        return tgtUntarDir;
    }

    private static void doFsCommand(FsShell shell, String[] args) throws Exception {
        int errcode = shell.run(args);
        if (errcode != 0) {
            throw new IOException("Failed put; errcode=" + errcode);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testSnapshots() throws IOException, InterruptedException {
        String[][] snapshots = new String[][]{snapshot1Keys, snapshot2Keys};
        for (int i = 1; i <= snapshots.length; ++i) {
            for (String table : tables) {
                TEST_UTIL.getHBaseAdmin().cloneSnapshot(table + "_snapshot" + i, table + "_clone" + i);
                FSUtils.logFileSystemState((FileSystem)FileSystem.get((Configuration)TEST_UTIL.getConfiguration()), (Path)FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), (Log)LOG);
                int count = 0;
                for (Result res : new HTable(TEST_UTIL.getConfiguration(), table + "_clone" + i).getScanner(new Scan())) {
                    Assert.assertEquals((Object)snapshots[i - 1][count++], (Object)Bytes.toString((byte[])res.getRow()));
                }
                Assert.assertEquals((String)(table + "_snapshot" + i), (long)snapshots[i - 1].length, (long)count);
            }
        }
    }

    @Test(timeout=300000L)
    public void testRenameUsingSnapshots() throws Exception {
        String newNS = "newNS";
        TEST_UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create((String)newNS).build());
        for (String table : tables) {
            int count = 0;
            for (Result res : new HTable(TEST_UTIL.getConfiguration(), table).getScanner(new Scan())) {
                Assert.assertEquals((Object)currentKeys[count++], (Object)Bytes.toString((byte[])res.getRow()));
            }
            TEST_UTIL.getHBaseAdmin().snapshot(table + "_snapshot3", table);
            final String newTableName = newNS + ':' + table + "_clone3";
            TEST_UTIL.getHBaseAdmin().cloneSnapshot(table + "_snapshot3", newTableName);
            Thread.sleep(1000L);
            count = 0;
            for (Result res : new HTable(TEST_UTIL.getConfiguration(), newTableName).getScanner(new Scan())) {
                Assert.assertEquals((Object)currentKeys[count++], (Object)Bytes.toString((byte[])res.getRow()));
            }
            FSUtils.logFileSystemState((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)TEST_UTIL.getDefaultRootDirPath(), (Log)LOG);
            Assert.assertEquals((String)newTableName, (long)currentKeys.length, (long)count);
            TEST_UTIL.getHBaseAdmin().flush(newTableName);
            TEST_UTIL.getHBaseAdmin().majorCompact(newTableName);
            TEST_UTIL.waitFor(30000L, new Waiter.Predicate<IOException>(){

                public boolean evaluate() throws IOException {
                    try {
                        return TEST_UTIL.getHBaseAdmin().getCompactionState(newTableName) == AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
            });
        }
        String nextNS = "nextNS";
        TEST_UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create((String)nextNS).build());
        for (String table : tables) {
            String srcTable = newNS + ':' + table + "_clone3";
            TEST_UTIL.getHBaseAdmin().snapshot(table + "_snapshot4", srcTable);
            String newTableName = nextNS + ':' + table + "_clone4";
            TEST_UTIL.getHBaseAdmin().cloneSnapshot(table + "_snapshot4", newTableName);
            FSUtils.logFileSystemState((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)TEST_UTIL.getDefaultRootDirPath(), (Log)LOG);
            int count = 0;
            for (Result res : new HTable(TEST_UTIL.getConfiguration(), newTableName).getScanner(new Scan())) {
                Assert.assertEquals((Object)currentKeys[count++], (Object)Bytes.toString((byte[])res.getRow()));
            }
            Assert.assertEquals((String)newTableName, (long)currentKeys.length, (long)count);
        }
    }

    @Test(timeout=300000L)
    public void testOldDirsAreGonePostMigration() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Path hbaseRootDir = TEST_UTIL.getDefaultRootDirPath();
        ArrayList dirs = new ArrayList(NamespaceUpgrade.NON_USER_TABLE_DIRS);
        dirs.remove(".hbck");
        dirs.remove(".hbase-snapshot");
        dirs.remove(".tmp");
        for (String dir : dirs) {
            Assert.assertFalse((boolean)fs.exists(new Path(hbaseRootDir, dir)));
        }
    }

    @Test(timeout=300000L)
    public void testNewDirsArePresentPostMigration() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        String[] newdirs = new String[]{"data", "WALs"};
        Path hbaseRootDir = TEST_UTIL.getDefaultRootDirPath();
        for (String dir : newdirs) {
            Assert.assertTrue((String)dir, (boolean)fs.exists(new Path(hbaseRootDir, dir)));
        }
    }
}

