/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.master.snapshot.SnapshotLogCleaner;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSnapshotLogCleaner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @AfterClass
    public static void cleanup() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(rootDir, true);
    }

    @Test
    public void testFindsSnapshotFilesWhenCleaning() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        FSUtils.setRootDir((Configuration)conf, (Path)TEST_UTIL.getDataTestDir());
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        SnapshotLogCleaner cleaner = new SnapshotLogCleaner();
        cleaner.setConf(conf);
        String snapshotName = "snapshot";
        byte[] snapshot = Bytes.toBytes((String)snapshotName);
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        Path snapshotLogDir = new Path(snapshotDir, "WALs");
        String timestamp = "1339643343027";
        String hostFromMaster = "localhost%2C59648%2C1339643336601";
        Path hostSnapshotLogDir = new Path(snapshotLogDir, hostFromMaster);
        String snapshotlogfile = hostFromMaster + "." + timestamp + ".hbase";
        fs.create(new Path(hostSnapshotLogDir, snapshotlogfile));
        Path oldlogDir = new Path(rootDir, "oldWALs");
        Path logFile = new Path(oldlogDir, snapshotlogfile);
        fs.create(logFile);
        Assert.assertFalse((boolean)cleaner.isFileDeletable(fs.getFileStatus(logFile)));
    }
}

