/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.ClusterStatusPublisher;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClusterStatusPublisher {
    private ManualEnvironmentEdge mee = new ManualEnvironmentEdge();

    @Before
    public void before() {
        this.mee.setValue(0L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)this.mee);
    }

    @Test
    public void testEmpty() {
        ClusterStatusPublisher csp = new ClusterStatusPublisher(){

            protected List<Pair<ServerName, Long>> getDeadServers(long since) {
                return new ArrayList<Pair<ServerName, Long>>();
            }
        };
        Assert.assertTrue((boolean)csp.generateDeadServersListToSend().isEmpty());
    }

    @Test
    public void testMaxSend() {
        ClusterStatusPublisher csp = new ClusterStatusPublisher(){

            protected List<Pair<ServerName, Long>> getDeadServers(long since) {
                ArrayList<Pair<ServerName, Long>> res = new ArrayList<Pair<ServerName, Long>>();
                switch ((int)EnvironmentEdgeManager.currentTimeMillis()) {
                    case 2: {
                        res.add((Pair<ServerName, Long>)new Pair((Object)new ServerName("hn", 10, 10L), (Object)1L));
                        break;
                    }
                }
                return res;
            }
        };
        this.mee.setValue(2L);
        for (int i = 0; i < ClusterStatusPublisher.NB_SEND; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)1L, (long)csp.generateDeadServersListToSend().size());
        }
        this.mee.setValue(1000L);
        Assert.assertTrue((boolean)csp.generateDeadServersListToSend().isEmpty());
    }

    @Test
    public void testOrder() {
        ClusterStatusPublisher csp = new ClusterStatusPublisher(){

            protected List<Pair<ServerName, Long>> getDeadServers(long since) {
                ArrayList<Pair<ServerName, Long>> res = new ArrayList<Pair<ServerName, Long>>();
                for (int i = 0; i < 25; ++i) {
                    res.add((Pair<ServerName, Long>)new Pair((Object)new ServerName("hn" + i, 10, 10L), (Object)20L));
                }
                return res;
            }
        };
        this.mee.setValue(3L);
        List allSNS = csp.generateDeadServersListToSend();
        Assert.assertEquals((long)10L, (long)ClusterStatusPublisher.MAX_SERVER_PER_MESSAGE);
        Assert.assertEquals((long)10L, (long)allSNS.size());
        List nextMes = csp.generateDeadServersListToSend();
        Assert.assertEquals((long)10L, (long)nextMes.size());
        for (ServerName sn : nextMes) {
            if (allSNS.contains(sn)) continue;
            allSNS.add(sn);
        }
        Assert.assertEquals((long)20L, (long)allSNS.size());
        nextMes = csp.generateDeadServersListToSend();
        Assert.assertEquals((long)10L, (long)nextMes.size());
        for (ServerName sn : nextMes) {
            if (allSNS.contains(sn)) continue;
            allSNS.add(sn);
        }
        Assert.assertEquals((long)25L, (long)allSNS.size());
        nextMes = csp.generateDeadServersListToSend();
        Assert.assertEquals((long)10L, (long)nextMes.size());
        for (ServerName sn : nextMes) {
            if (allSNS.contains(sn)) continue;
            allSNS.add(sn);
        }
        Assert.assertEquals((long)25L, (long)allSNS.size());
    }
}

