/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAssignmentManagerOnCluster {
    private static final byte[] FAMILY = Bytes.toBytes((String)"FAMILY");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static HBaseAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setClass("hbase.master.loadbalancer.class", MyLoadBalancer.class, LoadBalancer.class);
        conf.setClass("hbase.coprocessor.region.classes", MyRegionObserver.class, RegionObserver.class);
        conf.setInt("hbase.assignment.maximum.attempts", 3);
        TEST_UTIL.startMiniCluster(1, 4, null, MyMaster.class, null);
        admin = TEST_UTIL.getHBaseAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignRegion() throws Exception {
        String table = "testAssignRegion";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            master.assignRegion(hri);
            master.getAssignmentManager().waitForAssignment(hri);
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        }
        finally {
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(timeout=60000L)
    public void testAssignRegionOnRestartedServer() throws Exception {
        String table;
        block3: {
            table = "testAssignRegionOnRestartedServer";
            ServerName deadServer = null;
            HMaster master = null;
            try {
                HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
                desc.addFamily(new HColumnDescriptor(FAMILY));
                admin.createTable(desc);
                HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
                HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
                MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
                master = TEST_UTIL.getHBaseCluster().getMaster();
                Set onlineServers = master.serverManager.getOnlineServers().keySet();
                Assert.assertFalse((String)"There should be some servers online", (boolean)onlineServers.isEmpty());
                ServerName destServer = (ServerName)onlineServers.iterator().next();
                deadServer = new ServerName(destServer.getHostname(), destServer.getPort(), destServer.getStartcode() - 100L);
                master.serverManager.recordNewServer(deadServer, ServerLoad.EMPTY_SERVERLOAD);
                AssignmentManager am = master.getAssignmentManager();
                RegionPlan plan = new RegionPlan(hri, null, deadServer);
                am.addPlan(hri.getEncodedName(), plan);
                master.assignRegion(hri);
                int version = ZKAssign.transitionNode((ZooKeeperWatcher)master.getZooKeeper(), (HRegionInfo)hri, (ServerName)destServer, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)0);
                Assert.assertEquals((String)"TansitionNode should fail", (long)-1L, (long)version);
                Thread.sleep(2000L);
                Assert.assertTrue((String)"Region should still be in transition", (boolean)am.getRegionStates().isRegionInTransition(hri));
                Assert.assertEquals((String)"Assign node should still be in version 0", (long)0L, (long)ZKAssign.getVersion((ZooKeeperWatcher)master.getZooKeeper(), (HRegionInfo)hri));
                if (deadServer == null) break block3;
            }
            catch (Throwable throwable) {
                if (deadServer != null) {
                    master.serverManager.expireServer(deadServer);
                }
                TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
                throw throwable;
            }
            master.serverManager.expireServer(deadServer);
        }
        TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOfflineRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testOfflineRegion");
        try {
            List regions;
            HRegionInfo hri = this.createTableAndGetOneRegion(table);
            RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
            ServerName serverName = regionStates.getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
            admin.offline(hri.getRegionName());
            long timeoutTime = System.currentTimeMillis() + 800L;
            while ((regions = regionStates.getRegionsOfTable(table)).contains(hri)) {
                long now = System.currentTimeMillis();
                if (now > timeoutTime) {
                    Assert.fail((String)"Failed to offline the region in time");
                    break;
                }
                Thread.sleep(10L);
            }
            RegionState regionState = regionStates.getRegionState(hri);
            Assert.assertTrue((boolean)regionState.isOffline());
        }
        finally {
            TEST_UTIL.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testMoveRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testMoveRegion");
        try {
            HRegionInfo hri = this.createTableAndGetOneRegion(table);
            RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
            ServerName serverName = regionStates.getRegionServerOfRegion(hri);
            ServerName destServerName = null;
            for (int i = 0; i < 3; ++i) {
                HRegionServer destServer = TEST_UTIL.getHBaseCluster().getRegionServer(i);
                if (destServer.getServerName().equals((Object)serverName)) continue;
                destServerName = destServer.getServerName();
                break;
            }
            Assert.assertTrue((destServerName != null && !destServerName.equals((Object)serverName) ? 1 : 0) != 0);
            TEST_UTIL.getHBaseAdmin().move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)destServerName.getServerName()));
            long timeoutTime = System.currentTimeMillis() + 30000L;
            while (true) {
                ServerName sn;
                if ((sn = regionStates.getRegionServerOfRegion(hri)) != null && sn.equals((Object)destServerName)) {
                    TEST_UTIL.assertRegionOnServer(hri, sn, 200L);
                    break;
                }
                long now = System.currentTimeMillis();
                if (now > timeoutTime) {
                    Assert.fail((String)("Failed to move the region in time: " + regionStates.getRegionState(hri)));
                }
                regionStates.waitForUpdate(50L);
            }
        }
        finally {
            TEST_UTIL.deleteTable(table);
        }
    }

    HRegionInfo createTableAndGetOneRegion(TableName tableName) throws IOException, InterruptedException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY));
        admin.createTable(desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 5);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        long timeoutTime = System.currentTimeMillis() + 1000L;
        List regions;
        while ((regions = master.getAssignmentManager().getRegionStates().getRegionsOfTable(tableName)).size() <= 3) {
            long now = System.currentTimeMillis();
            if (now > timeoutTime) {
                Assert.fail((String)"Could not find an online region");
            }
            Thread.sleep(10L);
        }
        return (HRegionInfo)regions.get(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testForceAssignWhileClosing() throws Exception {
        String table = "testForceAssignWhileClosing";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            master.assignRegion(hri);
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            MyRegionObserver.preCloseEnabled.set(true);
            am.unassign(hri);
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_CLOSE, (Object)state.getState());
            MyRegionObserver.preCloseEnabled.set(false);
            am.unassign(hri, true);
            am.assign(hri, true, true);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnlyOnServer(hri, serverName, 200L);
        }
        finally {
            MyRegionObserver.preCloseEnabled.set(false);
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCloseFailed() throws Exception {
        String table = "testCloseFailed";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            master.assignRegion(hri);
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            MyRegionObserver.preCloseEnabled.set(true);
            am.unassign(hri);
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_CLOSE, (Object)state.getState());
            MyRegionObserver.preCloseEnabled.set(false);
            am.unassign(hri, true);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        }
        finally {
            MyRegionObserver.preCloseEnabled.set(false);
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenFailed() throws Exception {
        String table = "testOpenFailed";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            MyLoadBalancer.controledRegion = hri.getEncodedName();
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            master.assignRegion(hri);
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertFalse((boolean)am.waitForAssignment(hri));
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_OPEN, (Object)state.getState());
            Assert.assertNull((Object)state.getServerName());
            MyLoadBalancer.controledRegion = null;
            master.assignRegion(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        }
        finally {
            MyLoadBalancer.controledRegion = null;
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenFailedUnrecoverable() throws Exception {
        TableName table = TableName.valueOf((String)"testOpenFailedUnrecoverable");
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)table);
            Path regionDir = new Path(tableDir, hri.getEncodedName());
            fs.create(regionDir, true);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            master.assignRegion(hri);
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertFalse((boolean)am.waitForAssignment(hri));
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_OPEN, (Object)state.getState());
            Assert.assertNotNull((Object)state.getServerName());
            fs.delete(regionDir, true);
            master.assignRegion(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        }
        finally {
            TEST_UTIL.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSSHWhenDisablingTableRegionsInOpeningOrPendingOpenState() throws Exception {
        TableName table = TableName.valueOf((String)"testSSHWhenDisablingTableRegionsInOpeningOrPendingOpenState");
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        HRegionInfo hri = null;
        ServerName serverName = null;
        try {
            hri = this.createTableAndGetOneRegion(table);
            serverName = am.getRegionStates().getRegionServerOfRegion(hri);
            ServerName destServerName = null;
            HRegionServer destServer = null;
            for (int i = 0; i < 3; ++i) {
                destServer = TEST_UTIL.getHBaseCluster().getRegionServer(i);
                if (destServer.getServerName().equals((Object)serverName)) continue;
                destServerName = destServer.getServerName();
                break;
            }
            am.regionOffline(hri);
            ZooKeeperWatcher zkw = TEST_UTIL.getHBaseCluster().getMaster().getZooKeeper();
            am.getRegionStates().updateRegionState(hri, RegionState.State.OFFLINE);
            ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)hri, (ServerName)destServerName);
            ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)hri, (ServerName)destServerName);
            long timeoutTime = System.currentTimeMillis() + 20000L;
            while (!am.getRegionStates().isRegionInTransition(hri)) {
                Assert.assertTrue((String)"Failed to process ZK opening event in time", (System.currentTimeMillis() < timeoutTime ? 1 : 0) != 0);
                Thread.sleep(100L);
            }
            am.getZKTable().setDisablingTable(table);
            List toAssignRegions = am.processServerShutdown(destServerName);
            Assert.assertTrue((String)"Regions to be assigned should be empty.", (boolean)toAssignRegions.isEmpty());
            Assert.assertTrue((String)"Regions to be assigned should be empty.", (boolean)am.getRegionStates().getRegionState(hri).isOffline());
        }
        finally {
            if (hri != null && serverName != null) {
                am.regionOnline(hri, serverName);
            }
            am.getZKTable().setDisabledTable(table);
            TEST_UTIL.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCloseHang() throws Exception {
        String table = "testCloseHang";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            master.assignRegion(hri);
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            MyRegionObserver.postCloseEnabled.set(true);
            am.unassign(hri);
            am.unassign(hri, true);
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_CLOSE, (Object)state.getState());
            MyRegionObserver.postCloseEnabled.set(false);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        }
        finally {
            MyRegionObserver.postCloseEnabled.set(false);
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenCloseRacing() throws Exception {
        String table = "testOpenCloseRacing";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            MyRegionObserver.postOpenEnabled.set(true);
            MyRegionObserver.postOpenCalled = false;
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            master.assignRegion(hri);
            long end = EnvironmentEdgeManager.currentTimeMillis() + 20000L;
            while (!MyRegionObserver.postOpenCalled) {
                Assert.assertFalse((String)"Timed out waiting for postOpen to be called", (EnvironmentEdgeManager.currentTimeMillis() > end ? 1 : 0) != 0);
                Thread.sleep(300L);
            }
            AssignmentManager am = master.getAssignmentManager();
            am.unassign(hri);
            RegionState state = am.getRegionStates().getRegionState(hri);
            ServerName oldServerName = state.getServerName();
            Assert.assertTrue((state.isPendingOpenOrOpening() && oldServerName != null ? 1 : 0) != 0);
            MyRegionObserver.postOpenEnabled.set(false);
            am.assign(hri, true, true);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnlyOnServer(hri, serverName, 200L);
            Assert.assertFalse((String)"Region should assigned on a new region server", (boolean)oldServerName.equals((Object)serverName));
        }
        finally {
            MyRegionObserver.postOpenEnabled.set(false);
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignRacingWithSSH() throws Exception {
        String table = "testAssignRacingWithSSH";
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        MyMaster master = null;
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            master = (MyMaster)cluster.getMaster();
            master.assignRegion(hri);
            master.enableSSH(false);
            AssignmentManager am = master.getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            RegionState state = regionStates.getRegionState(hri);
            ServerName oldServerName = state.getServerName();
            cluster.killRegionServer(oldServerName);
            cluster.waitForRegionServerToStop(oldServerName, -1L);
            am.assign(hri, true, true);
            state = regionStates.getRegionState(hri);
            Assert.assertTrue((boolean)state.isFailedClose());
            am.unassign(hri, true);
            state = regionStates.getRegionState(hri);
            Assert.assertTrue((boolean)state.isFailedClose());
            RegionStates regionStates2 = regionStates;
            synchronized (regionStates2) {
                master.enableSSH(true);
                am.unassign(hri, true);
                state = regionStates.getRegionState(hri);
                Assert.assertTrue((boolean)state.isOffline());
            }
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnlyOnServer(hri, serverName, 200L);
        }
        finally {
            if (master != null) {
                master.enableSSH(true);
            }
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignDisabledRegion() throws Exception {
        String table = "testAssignDisabledRegion";
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        MyMaster master = null;
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaEditor.addRegionToMeta((HTable)meta, (HRegionInfo)hri);
            master = (MyMaster)cluster.getMaster();
            master.assignRegion(hri);
            AssignmentManager am = master.getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            admin.disableTable(table);
            Assert.assertTrue((boolean)regionStates.isRegionOffline(hri));
            am.assign(hri, true, true);
            Assert.assertTrue((boolean)regionStates.isRegionOffline(hri));
            am.unassign(hri, true);
            Assert.assertTrue((boolean)regionStates.isRegionOffline(hri));
        }
        finally {
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    public static class MyRegionObserver
    extends BaseRegionObserver {
        static AtomicBoolean preCloseEnabled = new AtomicBoolean(false);
        static AtomicBoolean postCloseEnabled = new AtomicBoolean(false);
        static AtomicBoolean postOpenEnabled = new AtomicBoolean(false);
        static volatile boolean postOpenCalled = false;

        public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
            if (preCloseEnabled.get()) {
                throw new IOException("fail preClose from coprocessor");
            }
        }

        public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
            this.stallOnFlag(postCloseEnabled);
        }

        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
            postOpenCalled = true;
            this.stallOnFlag(postOpenEnabled);
        }

        private void stallOnFlag(AtomicBoolean flag) {
            try {
                while (flag.get()) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class MyMaster
    extends HMaster {
        AtomicBoolean enabled = new AtomicBoolean(true);

        public MyMaster(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        public boolean isServerShutdownHandlerEnabled() {
            return this.enabled.get() && super.isServerShutdownHandlerEnabled();
        }

        public void enableSSH(boolean enabled) {
            this.enabled.set(enabled);
            if (enabled) {
                this.serverManager.processQueuedDeadServers();
            }
        }
    }

    static class MyLoadBalancer
    extends StochasticLoadBalancer {
        static volatile String controledRegion = null;

        MyLoadBalancer() {
        }

        public ServerName randomAssignment(HRegionInfo regionInfo, List<ServerName> servers) {
            if (regionInfo.getEncodedName().equals(controledRegion)) {
                return null;
            }
            return super.randomAssignment(regionInfo, servers);
        }
    }
}

