/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.TestRegionObserverInterface;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;

public class SimpleRegionObserver
extends BaseRegionObserver {
    static final Log LOG = LogFactory.getLog(TestRegionObserverInterface.class);
    final AtomicInteger ctBeforeDelete = new AtomicInteger(1);
    final AtomicInteger ctPreOpen = new AtomicInteger(0);
    final AtomicInteger ctPostOpen = new AtomicInteger(0);
    final AtomicInteger ctPreClose = new AtomicInteger(0);
    final AtomicInteger ctPostClose = new AtomicInteger(0);
    final AtomicInteger ctPreFlush = new AtomicInteger(0);
    final AtomicInteger ctPreFlushScannerOpen = new AtomicInteger(0);
    final AtomicInteger ctPostFlush = new AtomicInteger(0);
    final AtomicInteger ctPreSplit = new AtomicInteger(0);
    final AtomicInteger ctPostSplit = new AtomicInteger(0);
    final AtomicInteger ctPreCompactSelect = new AtomicInteger(0);
    final AtomicInteger ctPostCompactSelect = new AtomicInteger(0);
    final AtomicInteger ctPreCompactScanner = new AtomicInteger(0);
    final AtomicInteger ctPreCompact = new AtomicInteger(0);
    final AtomicInteger ctPostCompact = new AtomicInteger(0);
    final AtomicInteger ctPreGet = new AtomicInteger(0);
    final AtomicInteger ctPostGet = new AtomicInteger(0);
    final AtomicInteger ctPrePut = new AtomicInteger(0);
    final AtomicInteger ctPostPut = new AtomicInteger(0);
    final AtomicInteger ctPreDeleted = new AtomicInteger(0);
    final AtomicInteger ctPostDeleted = new AtomicInteger(0);
    final AtomicInteger ctPreGetClosestRowBefore = new AtomicInteger(0);
    final AtomicInteger ctPostGetClosestRowBefore = new AtomicInteger(0);
    final AtomicInteger ctPreIncrement = new AtomicInteger(0);
    final AtomicInteger ctPostIncrement = new AtomicInteger(0);
    final AtomicInteger ctPreWALRestored = new AtomicInteger(0);
    final AtomicInteger ctPostWALRestored = new AtomicInteger(0);
    final AtomicInteger ctPreScannerNext = new AtomicInteger(0);
    final AtomicInteger ctPostScannerNext = new AtomicInteger(0);
    final AtomicInteger ctPreScannerClose = new AtomicInteger(0);
    final AtomicInteger ctPostScannerClose = new AtomicInteger(0);
    final AtomicInteger ctPreScannerOpen = new AtomicInteger(0);
    final AtomicInteger ctPreStoreScannerOpen = new AtomicInteger(0);
    final AtomicInteger ctPostScannerOpen = new AtomicInteger(0);
    final AtomicInteger ctPreBulkLoadHFile = new AtomicInteger(0);
    final AtomicInteger ctPostBulkLoadHFile = new AtomicInteger(0);
    final AtomicInteger ctPreBatchMutate = new AtomicInteger(0);
    final AtomicInteger ctPostBatchMutate = new AtomicInteger(0);
    final AtomicInteger ctPreWALRestore = new AtomicInteger(0);
    final AtomicInteger ctPostWALRestore = new AtomicInteger(0);
    final AtomicBoolean throwOnPostFlush = new AtomicBoolean(false);
    static final String TABLE_SKIPPED = "SKIPPED_BY_PREWALRESTORE";

    public void setThrowOnPostFlush(Boolean val) {
        this.throwOnPostFlush.set(val);
    }

    public void start(CoprocessorEnvironment e) throws IOException {
        RegionCoprocessorEnvironment re = (RegionCoprocessorEnvironment)e;
        Leases leases = re.getRegionServerServices().getLeases();
        leases.createLease("x", 2000, null);
        leases.cancelLease("x");
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.ctPreOpen.incrementAndGet();
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.ctPostOpen.incrementAndGet();
    }

    public boolean wasOpened() {
        return this.ctPreOpen.get() > 0 && this.ctPostOpen.get() > 0;
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.ctPreClose.incrementAndGet();
    }

    public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.ctPostClose.incrementAndGet();
    }

    public boolean wasClosed() {
        return this.ctPreClose.get() > 0 && this.ctPostClose.get() > 0;
    }

    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner) throws IOException {
        this.ctPreFlush.incrementAndGet();
        return scanner;
    }

    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner s) throws IOException {
        this.ctPreFlushScannerOpen.incrementAndGet();
        return null;
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile) throws IOException {
        this.ctPostFlush.incrementAndGet();
        if (this.throwOnPostFlush.get()) {
            throw new IOException("throwOnPostFlush is true in postFlush");
        }
    }

    public boolean wasFlushed() {
        return this.ctPreFlush.get() > 0 && this.ctPostFlush.get() > 0;
    }

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.ctPreSplit.incrementAndGet();
    }

    public void postSplit(ObserverContext<RegionCoprocessorEnvironment> c, HRegion l, HRegion r) {
        this.ctPostSplit.incrementAndGet();
    }

    public boolean wasSplit() {
        return this.ctPreSplit.get() > 0 && this.ctPostSplit.get() > 0;
    }

    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<StoreFile> candidates) {
        this.ctPreCompactSelect.incrementAndGet();
    }

    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ImmutableList<StoreFile> selected) {
        this.ctPostCompactSelect.incrementAndGet();
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType) {
        this.ctPreCompact.incrementAndGet();
        return scanner;
    }

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s) throws IOException {
        this.ctPreCompactScanner.incrementAndGet();
        return null;
    }

    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile) {
        this.ctPostCompact.incrementAndGet();
    }

    public boolean wasCompacted() {
        return this.ctPreCompact.get() > 0 && this.ctPostCompact.get() > 0;
    }

    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        this.ctPreScannerOpen.incrementAndGet();
        return null;
    }

    public KeyValueScanner preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, NavigableSet<byte[]> targetCols, KeyValueScanner s) throws IOException {
        this.ctPreStoreScannerOpen.incrementAndGet();
        return null;
    }

    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        this.ctPostScannerOpen.incrementAndGet();
        return s;
    }

    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        this.ctPreScannerNext.incrementAndGet();
        return hasMore;
    }

    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        this.ctPostScannerNext.incrementAndGet();
        return hasMore;
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.ctPreScannerClose.incrementAndGet();
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.ctPostScannerClose.incrementAndGet();
    }

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> results) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)get);
        Assert.assertNotNull(results);
        this.ctPreGet.incrementAndGet();
    }

    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> results) {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)get);
        Assert.assertNotNull(results);
        if (e.getRegion().getTableDesc().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            boolean foundA = false;
            boolean foundB = false;
            boolean foundC = false;
            for (Cell kv : results) {
                if (CellUtil.matchingFamily((Cell)kv, (byte[])TestRegionObserverInterface.A)) {
                    foundA = true;
                }
                if (CellUtil.matchingFamily((Cell)kv, (byte[])TestRegionObserverInterface.B)) {
                    foundB = true;
                }
                if (!CellUtil.matchingFamily((Cell)kv, (byte[])TestRegionObserverInterface.C)) continue;
                foundC = true;
            }
            Assert.assertTrue((boolean)foundA);
            Assert.assertTrue((boolean)foundB);
            Assert.assertTrue((boolean)foundC);
        }
        this.ctPostGet.incrementAndGet();
    }

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        NavigableMap familyMap = put.getFamilyCellMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        if (e.getRegion().getTableDesc().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            List cells = (List)familyMap.get(TestRegionObserverInterface.A);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            KeyValue kv = (KeyValue)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])TestRegionObserverInterface.A));
            cells = (List)familyMap.get(TestRegionObserverInterface.B);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            kv = (KeyValue)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])TestRegionObserverInterface.B));
            cells = (List)familyMap.get(TestRegionObserverInterface.C);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            kv = (KeyValue)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])TestRegionObserverInterface.C));
        }
        this.ctPrePut.incrementAndGet();
    }

    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        NavigableMap familyMap = put.getFamilyCellMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        List cells = (List)familyMap.get(TestRegionObserverInterface.A);
        if (e.getRegion().getTableDesc().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            KeyValue kv = (KeyValue)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])TestRegionObserverInterface.A));
            cells = (List)familyMap.get(TestRegionObserverInterface.B);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            kv = (KeyValue)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])TestRegionObserverInterface.B));
            cells = (List)familyMap.get(TestRegionObserverInterface.C);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            kv = (KeyValue)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])TestRegionObserverInterface.C));
        }
        this.ctPostPut.incrementAndGet();
    }

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        NavigableMap familyMap = delete.getFamilyCellMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        if (this.ctBeforeDelete.get() > 0) {
            this.ctPreDeleted.incrementAndGet();
        }
    }

    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        NavigableMap familyMap = delete.getFamilyCellMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        this.ctBeforeDelete.set(0);
        this.ctPostDeleted.incrementAndGet();
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull(miniBatchOp);
        this.ctPreBatchMutate.incrementAndGet();
    }

    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull(miniBatchOp);
        this.ctPostBatchMutate.incrementAndGet();
    }

    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)row);
        Assert.assertNotNull((Object)result);
        if (this.ctBeforeDelete.get() > 0) {
            this.ctPreGetClosestRowBefore.incrementAndGet();
        }
    }

    public void postGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)row);
        Assert.assertNotNull((Object)result);
        this.ctPostGetClosestRowBefore.incrementAndGet();
    }

    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        this.ctPreIncrement.incrementAndGet();
        return null;
    }

    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
        this.ctPostIncrement.incrementAndGet();
        return result;
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)ctx.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        if (e.getRegion().getTableDesc().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull(familyPaths);
            Assert.assertEquals((long)1L, (long)familyPaths.size());
            Assert.assertArrayEquals((byte[])((byte[])familyPaths.get(0).getFirst()), (byte[])TestRegionObserverInterface.A);
            String familyPath = (String)familyPaths.get(0).getSecond();
            String familyName = Bytes.toString((byte[])TestRegionObserverInterface.A);
            Assert.assertEquals((Object)familyPath.substring(familyPath.length() - familyName.length() - 1), (Object)("/" + familyName));
        }
        this.ctPreBulkLoadHFile.incrementAndGet();
    }

    public boolean postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths, boolean hasLoaded) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)ctx.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        if (e.getRegion().getTableDesc().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull(familyPaths);
            Assert.assertEquals((long)1L, (long)familyPaths.size());
            Assert.assertArrayEquals((byte[])((byte[])familyPaths.get(0).getFirst()), (byte[])TestRegionObserverInterface.A);
            String familyPath = (String)familyPaths.get(0).getSecond();
            String familyName = Bytes.toString((byte[])TestRegionObserverInterface.A);
            Assert.assertEquals((Object)familyPath.substring(familyPath.length() - familyName.length() - 1), (Object)("/" + familyName));
        }
        this.ctPostBulkLoadHFile.incrementAndGet();
        return hasLoaded;
    }

    public void preWALRestore(ObserverContext<RegionCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        String tableName = logKey.getTablename().getNameAsString();
        if (tableName.equals(TABLE_SKIPPED)) {
            env.bypass();
            return;
        }
        this.ctPreWALRestore.incrementAndGet();
    }

    public void postWALRestore(ObserverContext<RegionCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.ctPostWALRestore.incrementAndGet();
    }

    public boolean hadPreGet() {
        return this.ctPreGet.get() > 0;
    }

    public boolean hadPostGet() {
        return this.ctPostGet.get() > 0;
    }

    public boolean hadPrePut() {
        return this.ctPrePut.get() > 0;
    }

    public boolean hadPostPut() {
        return this.ctPostPut.get() > 0;
    }

    public boolean hadPreBatchMutate() {
        return this.ctPreBatchMutate.get() > 0;
    }

    public boolean hadPostBatchMutate() {
        return this.ctPostBatchMutate.get() > 0;
    }

    public boolean hadDelete() {
        return this.ctBeforeDelete.get() <= 0;
    }

    public boolean hadPreIncrement() {
        return this.ctPreIncrement.get() > 0;
    }

    public boolean hadPostIncrement() {
        return this.ctPostIncrement.get() > 0;
    }

    public boolean hadPreWALRestored() {
        return this.ctPreWALRestored.get() > 0;
    }

    public boolean hadPostWALRestored() {
        return this.ctPostWALRestored.get() > 0;
    }

    public boolean wasScannerNextCalled() {
        return this.ctPreScannerNext.get() > 0 && this.ctPostScannerNext.get() > 0;
    }

    public boolean wasScannerCloseCalled() {
        return this.ctPreScannerClose.get() > 0 && this.ctPostScannerClose.get() > 0;
    }

    public boolean wasScannerOpenCalled() {
        return this.ctPreScannerOpen.get() > 0 && this.ctPostScannerOpen.get() > 0;
    }

    public boolean hadDeleted() {
        return this.ctPreDeleted.get() > 0 && this.ctPostDeleted.get() > 0;
    }

    public boolean hadPostBulkLoadHFile() {
        return this.ctPostBulkLoadHFile.get() > 0;
    }

    public boolean hadPreBulkLoadHFile() {
        return this.ctPreBulkLoadHFile.get() > 0;
    }

    public int getCtBeforeDelete() {
        return this.ctBeforeDelete.get();
    }

    public int getCtPreOpen() {
        return this.ctPreOpen.get();
    }

    public int getCtPostOpen() {
        return this.ctPostOpen.get();
    }

    public int getCtPreClose() {
        return this.ctPreClose.get();
    }

    public int getCtPostClose() {
        return this.ctPostClose.get();
    }

    public int getCtPreFlush() {
        return this.ctPreFlush.get();
    }

    public int getCtPreFlushScannerOpen() {
        return this.ctPreFlushScannerOpen.get();
    }

    public int getCtPostFlush() {
        return this.ctPostFlush.get();
    }

    public int getCtPreSplit() {
        return this.ctPreSplit.get();
    }

    public int getCtPostSplit() {
        return this.ctPostSplit.get();
    }

    public int getCtPreCompactSelect() {
        return this.ctPreCompactSelect.get();
    }

    public int getCtPostCompactSelect() {
        return this.ctPostCompactSelect.get();
    }

    public int getCtPreCompactScanner() {
        return this.ctPreCompactScanner.get();
    }

    public int getCtPreCompact() {
        return this.ctPreCompact.get();
    }

    public int getCtPostCompact() {
        return this.ctPostCompact.get();
    }

    public int getCtPreGet() {
        return this.ctPreGet.get();
    }

    public int getCtPostGet() {
        return this.ctPostGet.get();
    }

    public int getCtPrePut() {
        return this.ctPrePut.get();
    }

    public int getCtPostPut() {
        return this.ctPostPut.get();
    }

    public int getCtPreDeleted() {
        return this.ctPreDeleted.get();
    }

    public int getCtPostDeleted() {
        return this.ctPostDeleted.get();
    }

    public int getCtPreGetClosestRowBefore() {
        return this.ctPreGetClosestRowBefore.get();
    }

    public int getCtPostGetClosestRowBefore() {
        return this.ctPostGetClosestRowBefore.get();
    }

    public int getCtPreIncrement() {
        return this.ctPreIncrement.get();
    }

    public int getCtPostIncrement() {
        return this.ctPostIncrement.get();
    }

    public int getCtPreWALRestore() {
        return this.ctPreWALRestore.get();
    }

    public int getCtPostWALRestore() {
        return this.ctPostWALRestore.get();
    }
}

