/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode.column;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerNode;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.vint.UFIntTool;
import org.apache.hadoop.hbase.util.vint.UVIntTool;

@InterfaceAudience.Private
public class ColumnNodeWriter {
    protected TokenizerNode builderNode;
    protected PrefixTreeBlockMeta blockMeta;
    protected boolean familyVsQualifier;
    protected int tokenLength;
    protected byte[] token;
    protected int parentStartPosition;

    public ColumnNodeWriter(PrefixTreeBlockMeta blockMeta, TokenizerNode builderNode, boolean familyVsQualifier) {
        this.blockMeta = blockMeta;
        this.builderNode = builderNode;
        this.familyVsQualifier = familyVsQualifier;
        this.calculateTokenLength();
    }

    public boolean isRoot() {
        return this.parentStartPosition == 0;
    }

    private void calculateTokenLength() {
        this.tokenLength = this.builderNode.getTokenLength();
        this.token = new byte[this.tokenLength];
    }

    public int getWidthUsingPlaceholderForOffsetWidth(int offsetWidthPlaceholder) {
        int width = 0;
        width += UVIntTool.numBytes(this.tokenLength);
        width += this.token.length;
        return width += offsetWidthPlaceholder;
    }

    public void writeBytes(OutputStream os) throws IOException {
        int parentOffsetWidth = this.familyVsQualifier ? this.blockMeta.getFamilyOffsetWidth() : this.blockMeta.getQualifierOffsetWidth();
        UVIntTool.writeBytes(this.tokenLength, os);
        os.write(this.token);
        UFIntTool.writeBytes(parentOffsetWidth, this.parentStartPosition, os);
    }

    public void setTokenBytes(ByteRange source) {
        source.deepCopySubRangeTo(0, this.tokenLength, this.token, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Strings.padFront((String)(this.builderNode.getOutputArrayOffset() + ""), (char)' ', (int)3) + ",");
        sb.append("[");
        sb.append(Bytes.toString((byte[])this.token));
        sb.append("]->");
        sb.append(this.parentStartPosition);
        return sb.toString();
    }

    public void setParentStartPosition(int parentStartPosition) {
        this.parentStartPosition = parentStartPosition;
    }
}

