/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;

public class MetricsRegionServerSourceImpl
extends BaseSourceImpl
implements MetricsRegionServerSource {
    final MetricsRegionServerWrapper rsWrap;
    private final MetricHistogram putHisto;
    private final MetricHistogram deleteHisto;
    private final MetricHistogram getHisto;
    private final MetricHistogram incrementHisto;
    private final MetricHistogram appendHisto;
    private final MetricHistogram replayHisto;
    private final MetricMutableCounterLong slowPut;
    private final MetricMutableCounterLong slowDelete;
    private final MetricMutableCounterLong slowGet;
    private final MetricMutableCounterLong slowIncrement;
    private final MetricMutableCounterLong slowAppend;

    public MetricsRegionServerSourceImpl(MetricsRegionServerWrapper rsWrap) {
        this("Server", "Metrics about HBase RegionServer", "regionserver", "RegionServer,sub=Server", rsWrap);
    }

    public MetricsRegionServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsRegionServerWrapper rsWrap) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.rsWrap = rsWrap;
        this.putHisto = this.getMetricsRegistry().newHistogram("mutate");
        this.slowPut = this.getMetricsRegistry().newCounter("slowPutCount", "The number of Multis that took over 1000ms to complete", 0L);
        this.deleteHisto = this.getMetricsRegistry().newHistogram("delete");
        this.slowDelete = this.getMetricsRegistry().newCounter("slowDeleteCount", "The number of Deletes that took over 1000ms to complete", 0L);
        this.getHisto = this.getMetricsRegistry().newHistogram("get");
        this.slowGet = this.getMetricsRegistry().newCounter("slowGetCount", "The number of Gets that took over 1000ms to complete", 0L);
        this.incrementHisto = this.getMetricsRegistry().newHistogram("increment");
        this.slowIncrement = this.getMetricsRegistry().newCounter("slowIncrementCount", "The number of Increments that took over 1000ms to complete", 0L);
        this.appendHisto = this.getMetricsRegistry().newHistogram("append");
        this.slowAppend = this.getMetricsRegistry().newCounter("slowAppendCount", "The number of Appends that took over 1000ms to complete", 0L);
        this.replayHisto = this.getMetricsRegistry().newHistogram("replay");
    }

    public void updatePut(long t) {
        this.putHisto.add(t);
    }

    public void updateDelete(long t) {
        this.deleteHisto.add(t);
    }

    public void updateGet(long t) {
        this.getHisto.add(t);
    }

    public void updateIncrement(long t) {
        this.incrementHisto.add(t);
    }

    public void updateAppend(long t) {
        this.appendHisto.add(t);
    }

    public void updateReplay(long t) {
        this.replayHisto.add(t);
    }

    public void incrSlowPut() {
        this.slowPut.incr();
    }

    public void incrSlowDelete() {
        this.slowDelete.incr();
    }

    public void incrSlowGet() {
        this.slowGet.incr();
    }

    public void incrSlowIncrement() {
        this.slowIncrement.incr();
    }

    public void incrSlowAppend() {
        this.slowAppend.incr();
    }

    @Override
    public void getMetrics(MetricsBuilder metricsBuilder, boolean all) {
        MetricsRecordBuilder mrb = metricsBuilder.addRecord(this.metricsName).setContext(this.metricsContext);
        if (this.rsWrap != null) {
            mrb.addGauge("regionCount", "Number of regions", this.rsWrap.getNumOnlineRegions()).addGauge("storeCount", "Number of Stores", this.rsWrap.getNumStores()).addGauge("storeFileCount", "Number of Store Files", this.rsWrap.getNumStoreFiles()).addGauge("memStoreSize", "Size of the memstore", this.rsWrap.getMemstoreSize()).addGauge("storeFileSize", "Size of storefiles being served.", this.rsWrap.getStoreFileSize()).addGauge("regionServerStartTime", "RegionServer Start Time", this.rsWrap.getStartCode()).addCounter("totalRequestCount", "Total number of requests this RegionServer has answered.", this.rsWrap.getTotalRequestCount()).addCounter("readRequestCount", "Number of read requests this region server has answered.", this.rsWrap.getReadRequestsCount()).addCounter("writeRequestCount", "Number of mutation requests this region server has answered.", this.rsWrap.getWriteRequestsCount()).addCounter("checkMutateFailedCount", "Number of Check and Mutate calls that failed the checks.", this.rsWrap.getCheckAndMutateChecksFailed()).addCounter("checkMutatePassedCount", "Number of Check and Mutate calls that passed the checks.", this.rsWrap.getCheckAndMutateChecksPassed()).addGauge("storeFileIndexSize", "Size of indexes in storefiles on disk.", this.rsWrap.getStoreFileIndexSize()).addGauge("staticIndexSize", "Uncompressed size of the static indexes.", this.rsWrap.getTotalStaticIndexSize()).addGauge("staticBloomSize", "Uncompressed size of the static bloom filters.", this.rsWrap.getTotalStaticBloomSize()).addGauge("mutationsWithoutWALCount", "Number of mutations that have been sent by clients with the write ahead logging turned off.", this.rsWrap.getNumMutationsWithoutWAL()).addGauge("mutationsWithoutWALSize", "Size of data that has been sent by clients with the write ahead logging turned off.", this.rsWrap.getDataInMemoryWithoutWAL()).addGauge("percentFilesLocal", "The percent of HFiles that are stored on the local hdfs data node.", this.rsWrap.getPercentFileLocal()).addGauge("compactionQueueLength", "Length of the queue for compactions.", this.rsWrap.getCompactionQueueSize()).addGauge("largeCompactionQueueLength", "Length of the queue for compactions.", this.rsWrap.getLargeCompactionQueueSize()).addGauge("smallCompactionQueueLength", "Length of the queue for compactions.", this.rsWrap.getSmallCompactionQueueSize()).addGauge("flushQueueLength", "Length of the queue for region flushes", this.rsWrap.getFlushQueueSize()).addGauge("blockCacheFreeSize", "Size of the block cache that is not occupied.", this.rsWrap.getBlockCacheFreeSize()).addGauge("blockCacheCount", "Number of block in the block cache.", this.rsWrap.getBlockCacheCount()).addGauge("blockCacheSize", "Size of the block cache.", this.rsWrap.getBlockCacheSize()).addCounter("blockCacheHitCount", "Count of the hit on the block cache.", this.rsWrap.getBlockCacheHitCount()).addCounter("blockCacheMissCount", "Number of requests for a block that missed the block cache.", this.rsWrap.getBlockCacheMissCount()).addCounter("blockCacheEvictionCount", "Count of the number of blocks evicted from the block cache.", this.rsWrap.getBlockCacheEvictedCount()).addGauge("blockCountHitPercent", "Percent of block cache requests that are hits", this.rsWrap.getBlockCacheHitPercent()).addGauge("blockCacheExpressHitPercent", "The percent of the time that requests with the cache turned on hit the cache.", this.rsWrap.getBlockCacheHitCachingPercent()).addCounter("updatesBlockedTime", "Number of MS updates have been blocked so that the memstore can be flushed.", this.rsWrap.getUpdatesBlockedTime()).tag("zookeeperQuorum", "Zookeeper Quorum", this.rsWrap.getZookeeperQuorum()).tag("serverName", "Server Name", this.rsWrap.getServerName()).tag("clusterId", "Cluster Id", this.rsWrap.getClusterId());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

