/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.util.ByteBufferUtils;

@InterfaceAudience.Private
public class CopyKeyDataBlockEncoder
extends BufferedDataBlockEncoder {
    @Override
    public void internalEncodeKeyValues(DataOutputStream out, ByteBuffer in, boolean includesMemstoreTS) throws IOException {
        in.rewind();
        ByteBufferUtils.putInt(out, in.limit());
        ByteBufferUtils.moveBufferToStream(out, in, in.limit());
    }

    @Override
    public ByteBuffer decodeKeyValues(DataInputStream source, int preserveHeaderLength, int skipLastBytes, boolean includesMemstoreTS) throws IOException {
        int decompressedSize = source.readInt();
        ByteBuffer buffer = ByteBuffer.allocate(decompressedSize + preserveHeaderLength);
        buffer.position(preserveHeaderLength);
        ByteBufferUtils.copyFromStreamToBuffer(buffer, source, decompressedSize);
        return buffer;
    }

    @Override
    public ByteBuffer getFirstKeyInBlock(ByteBuffer block) {
        int keyLength = block.getInt(4);
        return ByteBuffer.wrap(block.array(), block.arrayOffset() + 12, keyLength).slice();
    }

    public String toString() {
        return CopyKeyDataBlockEncoder.class.getSimpleName();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(KeyValue.KVComparator comparator, final boolean includesMemstoreTS) {
        return new BufferedDataBlockEncoder.BufferedEncodedSeeker<BufferedDataBlockEncoder.SeekerState>(comparator){

            @Override
            protected void decodeNext() {
                this.current.keyLength = this.currentBuffer.getInt();
                this.current.valueLength = this.currentBuffer.getInt();
                this.current.ensureSpaceForKey();
                this.currentBuffer.get(this.current.keyBuffer, 0, this.current.keyLength);
                this.current.valueOffset = this.currentBuffer.position();
                ByteBufferUtils.skip(this.currentBuffer, this.current.valueLength);
                this.current.memstoreTS = includesMemstoreTS ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
                this.current.nextKvOffset = this.currentBuffer.position();
            }

            @Override
            protected void decodeFirst() {
                ByteBufferUtils.skip(this.currentBuffer, 4);
                this.current.lastCommonPrefix = 0;
                this.decodeNext();
            }
        };
    }
}

