/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ReplicationPeer
implements Abortable,
Closeable {
    private static final Log LOG = LogFactory.getLog(ReplicationPeer.class);
    private final String clusterKey;
    private final String id;
    private List<ServerName> regionServers = new ArrayList<ServerName>(0);
    private final AtomicBoolean peerEnabled = new AtomicBoolean();
    private ZooKeeperWatcher zkw;
    private final Configuration conf;
    private long lastRegionserverUpdate;
    private PeerStateTracker peerStateTracker;

    public ReplicationPeer(Configuration conf, String key, String id) throws ReplicationException {
        this.conf = conf;
        this.clusterKey = key;
        this.id = id;
        try {
            this.reloadZkWatcher();
        }
        catch (IOException e) {
            throw new ReplicationException("Error connecting to peer cluster with peerId=" + id, e);
        }
    }

    public void startStateTracker(ZooKeeperWatcher zookeeper, String peerStateNode) throws KeeperException {
        ReplicationPeer.ensurePeerEnabled(zookeeper, peerStateNode);
        this.peerStateTracker = new PeerStateTracker(peerStateNode, zookeeper, this);
        this.peerStateTracker.start();
        try {
            this.readPeerStateZnode();
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }

    private void readPeerStateZnode() throws DeserializationException {
        this.peerEnabled.set(ReplicationPeer.isStateEnabled(this.peerStateTracker.getData(false)));
    }

    public String getClusterKey() {
        return this.clusterKey;
    }

    public AtomicBoolean getPeerEnabled() {
        return this.peerEnabled;
    }

    public List<ServerName> getRegionServers() {
        return this.regionServers;
    }

    public void setRegionServers(List<ServerName> regionServers) {
        this.regionServers = regionServers;
        this.lastRegionserverUpdate = System.currentTimeMillis();
    }

    public ZooKeeperWatcher getZkw() {
        return this.zkw;
    }

    public long getLastRegionserverUpdate() {
        return this.lastRegionserverUpdate;
    }

    public String getId() {
        return this.id;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.fatal((Object)("The ReplicationPeer coresponding to peer " + this.clusterKey + " was aborted for the following reason(s):" + why), e);
    }

    public void reloadZkWatcher() throws IOException {
        if (this.zkw != null) {
            this.zkw.close();
        }
        this.zkw = new ZooKeeperWatcher(this.conf, "connection to cluster: " + this.id, this);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.zkw != null) {
            this.zkw.close();
        }
    }

    public static boolean isStateEnabled(byte[] bytes) throws DeserializationException {
        ZooKeeperProtos.ReplicationState.State state = ReplicationPeer.parseStateFrom(bytes);
        return ZooKeeperProtos.ReplicationState.State.ENABLED == state;
    }

    private static ZooKeeperProtos.ReplicationState.State parseStateFrom(byte[] bytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(bytes);
        int pblen = ProtobufUtil.lengthOfPBMagic();
        ZooKeeperProtos.ReplicationState.Builder builder = ZooKeeperProtos.ReplicationState.newBuilder();
        try {
            ZooKeeperProtos.ReplicationState state = ((ZooKeeperProtos.ReplicationState.Builder)builder.mergeFrom(bytes, pblen, bytes.length - pblen)).build();
            return state.getState();
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
    }

    private static boolean ensurePeerEnabled(ZooKeeperWatcher zookeeper, String path) throws KeeperException.NodeExistsException, KeeperException {
        if (ZKUtil.checkExists(zookeeper, path) == -1) {
            ZKUtil.createNodeIfNotExistsAndWatch(zookeeper, path, ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
            return true;
        }
        return false;
    }

    public class PeerStateTracker
    extends ZooKeeperNodeTracker {
        public PeerStateTracker(String peerStateZNode, ZooKeeperWatcher watcher, Abortable abortable) {
            super(watcher, peerStateZNode, abortable);
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
                try {
                    ReplicationPeer.this.readPeerStateZnode();
                }
                catch (DeserializationException e) {
                    LOG.warn((Object)("Failed deserializing the content of " + path), (Throwable)e);
                }
            }
        }
    }
}

