/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Pair;

class MultiServerCallable<R>
extends RegionServerCallable<MultiResponse> {
    private final MultiAction<R> multiAction;
    private final boolean cellBlock;

    MultiServerCallable(HConnection connection, TableName tableName, HRegionLocation location, MultiAction<R> multi) {
        super(connection, tableName, null);
        this.multiAction = multi;
        this.setLocation(location);
        this.cellBlock = this.isCellBlock();
    }

    MultiAction<R> getMulti() {
        return this.multiAction;
    }

    @Override
    public MultiResponse call() throws IOException {
        ClientProtos.MultiResponse responseProto;
        int countOfActions = this.multiAction.size();
        if (countOfActions <= 0) {
            throw new DoNotRetryIOException("No Actions");
        }
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ArrayList cells = null;
        for (Map.Entry e : this.multiAction.actions.entrySet()) {
            ClientProtos.RegionAction.Builder regionActionBuilder;
            byte[] regionName = e.getKey();
            List actions = e.getValue();
            if (this.cellBlock) {
                if (cells == null) {
                    cells = new ArrayList(countOfActions);
                }
                regionActionBuilder = RequestConverter.buildNoDataRegionAction(regionName, actions, cells);
            } else {
                regionActionBuilder = RequestConverter.buildRegionAction(regionName, actions);
            }
            multiRequestBuilder.addRegionAction(regionActionBuilder.build());
        }
        PayloadCarryingRpcController controller = new PayloadCarryingRpcController(cells);
        controller.setPriority(this.getTableName());
        ClientProtos.MultiRequest requestProto = multiRequestBuilder.build();
        try {
            responseProto = this.getStub().multi((RpcController)controller, requestProto);
        }
        catch (ServiceException e) {
            return MultiServerCallable.createAllFailedResponse(requestProto, ProtobufUtil.getRemoteException(e));
        }
        return ResponseConverter.getResults(requestProto, responseProto, controller.cellScanner());
    }

    private static MultiResponse createAllFailedResponse(ClientProtos.MultiRequest request, Throwable t) {
        MultiResponse massFailedResponse = new MultiResponse();
        for (ClientProtos.RegionAction rAction : request.getRegionActionList()) {
            byte[] regionName = rAction.getRegion().getValue().toByteArray();
            for (ClientProtos.Action action : rAction.getActionList()) {
                massFailedResponse.add(regionName, (Pair<Integer, Object>)new Pair((Object)action.getIndex(), (Object)t));
            }
        }
        return massFailedResponse;
    }

    private boolean isCellBlock() {
        HConnection connection = this.getConnection();
        if (connection == null) {
            return true;
        }
        Configuration configuration = connection.getConfiguration();
        if (configuration == null) {
            return true;
        }
        String codec = configuration.get("hbase.client.rpc.codec", "");
        return codec != null && codec.length() > 0;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.setStub(this.getConnection().getClient(this.getLocation().getServerName()));
    }
}

