/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.exceptions;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RegionOpeningException
extends NotServingRegionException {
    private static final Log LOG = LogFactory.getLog(RegionOpeningException.class);
    private static final long serialVersionUID = -7232903522310558395L;

    public RegionOpeningException(String message) {
        super(message);
    }

    public static RegionOpeningException find(Object exception) {
        if (exception == null || !(exception instanceof Throwable)) {
            return null;
        }
        RegionOpeningException res = null;
        Throwable cur = (Throwable)exception;
        while (res == null && cur != null) {
            if (cur instanceof RegionOpeningException) {
                res = (RegionOpeningException)cur;
                continue;
            }
            if (cur instanceof RemoteException) {
                RemoteException re = (RemoteException)cur;
                IOException e = re.unwrapRemoteException(new Class[]{RegionOpeningException.class});
                if (e == null) {
                    e = re.unwrapRemoteException();
                }
                if (e != re) {
                    res = RegionOpeningException.find(e);
                }
            }
            cur = cur.getCause();
        }
        return res;
    }
}

