/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.NMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.ContainerTokenIdentifierForTest;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.NMTokenIdentifierNewForTest;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.security.NMTokenSecretManagerInNM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.security.BaseNMTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestContainerManagerSecurity
extends KerberosSecurityTestcase {
    static Log LOG = LogFactory.getLog(TestContainerManagerSecurity.class);
    static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static MiniYARNCluster yarnCluster;
    private static final File testRootDir;
    private static File httpSpnegoKeytabFile;
    private static String httpSpnegoPrincipal;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        testRootDir.mkdirs();
        httpSpnegoKeytabFile.deleteOnExit();
        this.getKdc().createPrincipal(httpSpnegoKeytabFile, new String[]{httpSpnegoPrincipal});
    }

    @After
    public void tearDown() {
        testRootDir.delete();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        Configuration configurationWithoutSecurity = new Configuration();
        configurationWithoutSecurity.set("hadoop.security.authentication", "simple");
        Configuration configurationWithSecurity = new Configuration();
        configurationWithSecurity.set("hadoop.security.authentication", "kerberos");
        configurationWithSecurity.set("yarn.resourcemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        configurationWithSecurity.set("yarn.resourcemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        configurationWithSecurity.set("yarn.nodemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        configurationWithSecurity.set("yarn.nodemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        return Arrays.asList({configurationWithoutSecurity}, {configurationWithSecurity});
    }

    public TestContainerManagerSecurity(Configuration conf) {
        conf.setLong("yarn.am.liveness-monitor.expiry-interval-ms", 100000L);
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.conf = conf;
    }

    @Test(timeout=120000L)
    public void testContainerManager() throws Exception {
        try {
            yarnCluster = new MiniYARNCluster(TestContainerManagerSecurity.class.getName(), 1, 1, 1);
            yarnCluster.init(this.conf);
            yarnCluster.start();
            this.testNMTokens(this.conf);
            this.testContainerToken(this.conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (yarnCluster != null) {
                yarnCluster.stop();
                yarnCluster = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testContainerManagerWithEpoch() throws Exception {
        try {
            yarnCluster = new MiniYARNCluster(TestContainerManagerSecurity.class.getName(), 1, 1, 1);
            yarnCluster.init(this.conf);
            yarnCluster.start();
            this.testContainerTokenWithEpoch(this.conf);
        }
        finally {
            if (yarnCluster != null) {
                yarnCluster.stop();
                yarnCluster = null;
            }
        }
    }

    private void testNMTokens(Configuration conf) throws Exception {
        NMTokenSecretManagerInRM nmTokenSecretManagerRM = yarnCluster.getResourceManager().getRMContext().getNMTokenSecretManager();
        NMTokenSecretManagerInNM nmTokenSecretManagerNM = yarnCluster.getNodeManager(0).getNMContext().getNMTokenSecretManager();
        RMContainerTokenSecretManager containerTokenSecretManager = yarnCluster.getResourceManager().getRMContext().getContainerTokenSecretManager();
        NodeManager nm = yarnCluster.getNodeManager(0);
        this.waitForNMToReceiveNMTokenKey(nmTokenSecretManagerNM, nm);
        Assert.assertEquals((long)nmTokenSecretManagerNM.getCurrentKey().getKeyId(), (long)nmTokenSecretManagerRM.getCurrentKey().getKeyId());
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String user = "test";
        Resource r = Resource.newInstance((int)1024, (int)1);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId validAppAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId validContainerId = ContainerId.newContainerId((ApplicationAttemptId)validAppAttemptId, (long)0L);
        NodeId validNode = yarnCluster.getNodeManager(0).getNMContext().getNodeId();
        NodeId invalidNode = NodeId.newInstance((String)"InvalidHost", (int)1234);
        Token validNMToken = nmTokenSecretManagerRM.createNMToken(validAppAttemptId, validNode, user);
        Token validContainerToken = containerTokenSecretManager.createContainerToken(validContainerId, validNode, user, r, Priority.newInstance((int)10), 1234L);
        ContainerTokenIdentifier identifier = BuilderUtils.newContainerTokenIdentifier((Token)validContainerToken);
        Assert.assertEquals((Object)Priority.newInstance((int)10), (Object)identifier.getPriority());
        Assert.assertEquals((long)1234L, (long)identifier.getCreationTime());
        NMTokenSecretManagerInRM tempManager = new NMTokenSecretManagerInRM(conf);
        tempManager.rollMasterKey();
        do {
            tempManager.rollMasterKey();
            tempManager.activateNextMasterKey();
        } while (tempManager.getCurrentKey().getKeyId() == nmTokenSecretManagerRM.getCurrentKey().getKeyId());
        StringBuilder sb = UserGroupInformation.isSecurityEnabled() ? new StringBuilder("Client cannot authenticate via:[TOKEN]") : new StringBuilder("SIMPLE authentication is not enabled.  Available:[TOKEN]");
        String errorMsg = this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, null, true);
        Assert.assertTrue((boolean)errorMsg.contains(sb.toString()));
        Token invalidNMToken = tempManager.createNMToken(validAppAttemptId, validNode, user);
        sb = new StringBuilder("Given NMToken for application : ");
        sb.append(validAppAttemptId.toString()).append(" seems to have been generated illegally.");
        Assert.assertTrue((boolean)sb.toString().contains(this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, invalidNMToken, true)));
        invalidNMToken = nmTokenSecretManagerRM.createNMToken(validAppAttemptId, invalidNode, user);
        sb = new StringBuilder("Given NMToken for application : ");
        sb.append(validAppAttemptId).append(" is not valid for current node manager.expected : ").append(validNode.toString()).append(" found : ").append(invalidNode.toString());
        Assert.assertTrue((boolean)sb.toString().contains(this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, invalidNMToken, true)));
        conf.setInt("yarn.resourcemanager.rm.container-allocation.expiry-interval-ms", 240000);
        validContainerToken = containerTokenSecretManager.createContainerToken(validContainerId, validNode, user, r, Priority.newInstance((int)0), 0L);
        Assert.assertTrue((boolean)this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, validNMToken, false).isEmpty());
        Assert.assertTrue((boolean)nmTokenSecretManagerNM.isAppAttemptNMTokenKeyPresent(validAppAttemptId));
        ApplicationAttemptId validAppAttemptId2 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        ContainerId validContainerId2 = ContainerId.newContainerId((ApplicationAttemptId)validAppAttemptId2, (long)0L);
        Token validContainerToken2 = containerTokenSecretManager.createContainerToken(validContainerId2, validNode, user, r, Priority.newInstance((int)0), 0L);
        Token validNMToken2 = nmTokenSecretManagerRM.createNMToken(validAppAttemptId2, validNode, user);
        NMTokenIdentifier newIdentifier = new NMTokenIdentifier();
        byte[] tokenIdentifierContent = validNMToken2.getIdentifier().array();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenIdentifierContent, tokenIdentifierContent.length);
        newIdentifier.readFields((DataInput)dib);
        NMTokenIdentifierNewForTest newVersionIdentifier = new NMTokenIdentifierNewForTest(newIdentifier, "message");
        Assert.assertEquals((String)"The ApplicationAttemptId is changed after set to newVersionIdentifier", (long)validAppAttemptId2.getAttemptId(), (long)newVersionIdentifier.getApplicationAttemptId().getAttemptId());
        Assert.assertEquals((String)"The message is changed after set to newVersionIdentifier", (Object)"message", (Object)newVersionIdentifier.getMessage());
        Assert.assertEquals((String)"The NodeId is changed after set to newVersionIdentifier", (Object)validNode, (Object)newVersionIdentifier.getNodeId());
        Token newVersionedNMToken = BaseNMTokenSecretManager.newInstance((byte[])nmTokenSecretManagerRM.retrievePassword((NMTokenIdentifier)newVersionIdentifier), (NMTokenIdentifier)newVersionIdentifier);
        Assert.assertTrue((boolean)this.testStartContainer(rpc, validAppAttemptId2, validNode, validContainerToken2, newVersionedNMToken, false).isEmpty());
        Assert.assertTrue((boolean)nmTokenSecretManagerNM.isAppAttemptNMTokenKeyPresent(validAppAttemptId2));
        this.waitForContainerToFinishOnNM(validContainerId);
        sb = new StringBuilder("Attempt to relaunch the same container with id ");
        sb.append(validContainerId);
        Assert.assertTrue((boolean)this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, validNMToken, true).contains(sb.toString()));
        this.testStopContainer(rpc, validAppAttemptId, validNode, validContainerId, validNMToken, false);
        this.rollNMTokenMasterKey(nmTokenSecretManagerRM, nmTokenSecretManagerNM);
        this.rollNMTokenMasterKey(nmTokenSecretManagerRM, nmTokenSecretManagerNM);
        sb = new StringBuilder("Container ");
        sb.append(validContainerId);
        sb.append(" was recently stopped on node manager");
        Assert.assertTrue((boolean)this.testGetContainer(rpc, validAppAttemptId, validNode, validContainerId, validNMToken, true).contains(sb.toString()));
        nm.getNodeStatusUpdater().clearFinishedContainersFromCache();
        sb = new StringBuilder("Container ");
        sb.append(validContainerId.toString());
        sb.append(" is not handled by this NodeManager");
        Assert.assertTrue((boolean)this.testGetContainer(rpc, validAppAttemptId, validNode, validContainerId, validNMToken, false).contains(sb.toString()));
        ApplicationAttemptId attempt2 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        Token attempt1NMToken = nmTokenSecretManagerRM.createNMToken(validAppAttemptId, validNode, user);
        Token newContainerToken = containerTokenSecretManager.createContainerToken(ContainerId.newContainerId((ApplicationAttemptId)attempt2, (long)1L), validNode, user, r, Priority.newInstance((int)0), 0L);
        Assert.assertTrue((boolean)this.testStartContainer(rpc, attempt2, validNode, newContainerToken, attempt1NMToken, false).isEmpty());
    }

    private void waitForContainerToFinishOnNM(ContainerId containerId) {
        Context nmContet = yarnCluster.getNodeManager(0).getNMContext();
        int interval = 240;
        Assert.assertNotNull((Object)nmContet.getContainers().containsKey(containerId));
        while (interval-- > 0 && !((Container)nmContet.getContainers().get(containerId)).cloneAndGetContainerStatus().getState().equals((Object)ContainerState.COMPLETE)) {
            try {
                LOG.info((Object)("Waiting for " + containerId + " to complete."));
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        yarnCluster.getNodeManager(0).getNodeStatusUpdater().addCompletedContainer(containerId);
        nmContet.getContainers().remove(containerId);
    }

    protected void waitForNMToReceiveNMTokenKey(NMTokenSecretManagerInNM nmTokenSecretManagerNM, NodeManager nm) throws InterruptedException {
        int attempt = 60;
        ContainerManagerImpl cm = (ContainerManagerImpl)nm.getNMContext().getContainerManager();
        while ((cm.getBlockNewContainerRequestsStatus() || nmTokenSecretManagerNM.getNodeId() == null) && attempt-- > 0) {
            Thread.sleep(2000L);
        }
    }

    protected void rollNMTokenMasterKey(NMTokenSecretManagerInRM nmTokenSecretManagerRM, NMTokenSecretManagerInNM nmTokenSecretManagerNM) throws Exception {
        int oldKeyId = nmTokenSecretManagerRM.getCurrentKey().getKeyId();
        nmTokenSecretManagerRM.rollMasterKey();
        int interval = 40;
        while (nmTokenSecretManagerNM.getCurrentKey().getKeyId() == oldKeyId && interval-- > 0) {
            Thread.sleep(1000L);
        }
        nmTokenSecretManagerRM.activateNextMasterKey();
        Assert.assertTrue((nmTokenSecretManagerNM.getCurrentKey().getKeyId() == nmTokenSecretManagerRM.getCurrentKey().getKeyId() ? 1 : 0) != 0);
    }

    private String testStopContainer(YarnRPC rpc, ApplicationAttemptId appAttemptId, NodeId nodeId, ContainerId containerId, Token nmToken, boolean isExceptionExpected) {
        try {
            this.stopContainer(rpc, nmToken, Arrays.asList(containerId), appAttemptId, nodeId);
            if (isExceptionExpected) {
                Assert.fail((String)"Exception was expected!!");
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private String testGetContainer(YarnRPC rpc, ApplicationAttemptId appAttemptId, NodeId nodeId, ContainerId containerId, Token nmToken, boolean isExceptionExpected) {
        try {
            this.getContainerStatus(rpc, nmToken, containerId, appAttemptId, nodeId, isExceptionExpected);
            if (isExceptionExpected) {
                Assert.fail((String)"Exception was expected!!");
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private String testStartContainer(YarnRPC rpc, ApplicationAttemptId appAttemptId, NodeId nodeId, Token containerToken, Token nmToken, boolean isExceptionExpected) {
        try {
            this.startContainer(rpc, nmToken, containerToken, nodeId, appAttemptId.toString());
            if (isExceptionExpected) {
                Assert.fail((String)"Exception was expected!!");
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private void stopContainer(YarnRPC rpc, Token nmToken, List<ContainerId> containerId, ApplicationAttemptId appAttemptId, NodeId nodeId) throws Exception {
        block3: {
            StopContainersRequest request = StopContainersRequest.newInstance(containerId);
            ContainerManagementProtocol proxy = null;
            try {
                proxy = this.getContainerManagementProtocolProxy(rpc, nmToken, nodeId, appAttemptId.toString());
                StopContainersResponse response = proxy.stopContainers(request);
                if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                    this.parseAndThrowException(((SerializedException)response.getFailedRequests().get(containerId)).deSerialize());
                }
            }
            catch (Exception e) {
                if (proxy == null) break block3;
                rpc.stopProxy((Object)proxy, this.conf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getContainerStatus(YarnRPC rpc, Token nmToken, ContainerId containerId, ApplicationAttemptId appAttemptId, NodeId nodeId, boolean isExceptionExpected) throws Exception {
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        GetContainerStatusesRequest request = GetContainerStatusesRequest.newInstance(containerIds);
        ContainerManagementProtocol proxy = null;
        try {
            proxy = this.getContainerManagementProtocolProxy(rpc, nmToken, nodeId, appAttemptId.toString());
            GetContainerStatusesResponse statuses = proxy.getContainerStatuses(request);
            if (statuses.getFailedRequests() != null && statuses.getFailedRequests().containsKey(containerId)) {
                this.parseAndThrowException(((SerializedException)statuses.getFailedRequests().get(containerId)).deSerialize());
            }
        }
        finally {
            if (proxy != null) {
                rpc.stopProxy((Object)proxy, this.conf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainer(YarnRPC rpc, Token nmToken, Token containerToken, NodeId nodeId, String user) throws Exception {
        ContainerLaunchContext context = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        StartContainerRequest scRequest = StartContainerRequest.newInstance((ContainerLaunchContext)context, (Token)containerToken);
        ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
        list.add(scRequest);
        StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
        ContainerManagementProtocol proxy = null;
        try {
            proxy = this.getContainerManagementProtocolProxy(rpc, nmToken, nodeId, user);
            StartContainersResponse response = proxy.startContainers(allRequests);
            for (SerializedException ex : response.getFailedRequests().values()) {
                this.parseAndThrowException(ex.deSerialize());
            }
        }
        finally {
            if (proxy != null) {
                rpc.stopProxy((Object)proxy, this.conf);
            }
        }
    }

    private void parseAndThrowException(Throwable t) throws YarnException, IOException {
        if (t instanceof YarnException) {
            throw (YarnException)t;
        }
        if (t instanceof SecretManager.InvalidToken) {
            throw (SecretManager.InvalidToken)t;
        }
        throw (IOException)t;
    }

    protected ContainerManagementProtocol getContainerManagementProtocolProxy(YarnRPC rpc, Token nmToken, NodeId nodeId, String user) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        InetSocketAddress addr = NetUtils.createSocketAddr((String)nodeId.getHost(), (int)nodeId.getPort());
        if (nmToken != null) {
            ugi.addToken(ConverterUtils.convertFromYarn((Token)nmToken, (InetSocketAddress)addr));
        }
        ContainerManagementProtocol proxy = (ContainerManagementProtocol)NMProxy.createNMProxy((Configuration)this.conf, ContainerManagementProtocol.class, (UserGroupInformation)ugi, (YarnRPC)rpc, (InetSocketAddress)addr);
        return proxy;
    }

    private void testContainerToken(Configuration conf) throws IOException, InterruptedException, YarnException {
        LOG.info((Object)"Running test for malice user");
        NMTokenSecretManagerInRM nmTokenSecretManagerInRM = yarnCluster.getResourceManager().getRMContext().getNMTokenSecretManager();
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L);
        NodeManager nm = yarnCluster.getNodeManager(0);
        NMTokenSecretManagerInNM nmTokenSecretManagerInNM = nm.getNMContext().getNMTokenSecretManager();
        String user = "test";
        this.waitForNMToReceiveNMTokenKey(nmTokenSecretManagerInNM, nm);
        NodeId nodeId = nm.getNMContext().getNodeId();
        Assert.assertEquals((long)nmTokenSecretManagerInNM.getCurrentKey().getKeyId(), (long)nmTokenSecretManagerInRM.getCurrentKey().getKeyId());
        RMContainerTokenSecretManager containerTokenSecretManager = yarnCluster.getResourceManager().getRMContext().getContainerTokenSecretManager();
        Resource r = Resource.newInstance((int)1230, (int)2);
        Token containerToken = containerTokenSecretManager.createContainerToken(cId, nodeId, user, r, Priority.newInstance((int)0), 0L);
        ContainerTokenIdentifier containerTokenIdentifier = this.getContainerTokenIdentifierFromToken(containerToken);
        ContainerTokenIdentifierForTest newVersionTokenIdentifier = new ContainerTokenIdentifierForTest(containerTokenIdentifier, "message");
        byte[] password = containerTokenSecretManager.createPassword((ContainerTokenIdentifier)newVersionTokenIdentifier);
        Token newContainerToken = BuilderUtils.newContainerToken((NodeId)nodeId, (byte[])password, (ContainerTokenIdentifier)newVersionTokenIdentifier);
        Token nmToken = nmTokenSecretManagerInRM.createNMToken(appAttemptId, nodeId, user);
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        Assert.assertTrue((boolean)this.testStartContainer(rpc, appAttemptId, nodeId, newContainerToken, nmToken, false).isEmpty());
        RMContainerTokenSecretManager tamperedContainerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        tamperedContainerTokenSecretManager.rollMasterKey();
        do {
            tamperedContainerTokenSecretManager.rollMasterKey();
            tamperedContainerTokenSecretManager.activateNextMasterKey();
        } while (containerTokenSecretManager.getCurrentKey().getKeyId() == tamperedContainerTokenSecretManager.getCurrentKey().getKeyId());
        ContainerId cId2 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        Token containerToken2 = tamperedContainerTokenSecretManager.createContainerToken(cId2, nodeId, user, r, Priority.newInstance((int)0), 0L);
        StringBuilder sb = new StringBuilder("Given Container ");
        sb.append(cId2);
        sb.append(" seems to have an illegally generated token.");
        Assert.assertTrue((boolean)this.testStartContainer(rpc, appAttemptId, nodeId, containerToken2, nmToken, true).contains(sb.toString()));
    }

    private ContainerTokenIdentifier getContainerTokenIdentifierFromToken(Token containerToken) throws IOException {
        ContainerTokenIdentifier containerTokenIdentifier = new ContainerTokenIdentifier();
        byte[] tokenIdentifierContent = containerToken.getIdentifier().array();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenIdentifierContent, tokenIdentifierContent.length);
        containerTokenIdentifier.readFields((DataInput)dib);
        return containerTokenIdentifier;
    }

    private void testContainerTokenWithEpoch(Configuration conf) throws IOException, InterruptedException, YarnException {
        LOG.info((Object)"Running test for serializing/deserializing containerIds");
        NMTokenSecretManagerInRM nmTokenSecretManagerInRM = yarnCluster.getResourceManager().getRMContext().getNMTokenSecretManager();
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0x50000000003L);
        NodeManager nm = yarnCluster.getNodeManager(0);
        NMTokenSecretManagerInNM nmTokenSecretManagerInNM = nm.getNMContext().getNMTokenSecretManager();
        String user = "test";
        this.waitForNMToReceiveNMTokenKey(nmTokenSecretManagerInNM, nm);
        NodeId nodeId = nm.getNMContext().getNodeId();
        Assert.assertEquals((long)nmTokenSecretManagerInNM.getCurrentKey().getKeyId(), (long)nmTokenSecretManagerInRM.getCurrentKey().getKeyId());
        RMContainerTokenSecretManager containerTokenSecretManager = yarnCluster.getResourceManager().getRMContext().getContainerTokenSecretManager();
        Resource r = Resource.newInstance((int)1230, (int)2);
        Token containerToken = containerTokenSecretManager.createContainerToken(cId, nodeId, user, r, Priority.newInstance((int)0), 0L);
        ContainerTokenIdentifier containerTokenIdentifier = new ContainerTokenIdentifier();
        byte[] tokenIdentifierContent = containerToken.getIdentifier().array();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(tokenIdentifierContent, tokenIdentifierContent.length);
        containerTokenIdentifier.readFields((DataInput)dib);
        Assert.assertEquals((Object)cId, (Object)containerTokenIdentifier.getContainerID());
        Assert.assertEquals((Object)cId.toString(), (Object)containerTokenIdentifier.getContainerID().toString());
        Token nmToken = nmTokenSecretManagerInRM.createNMToken(appAttemptId, nodeId, user);
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.testStartContainer(rpc, appAttemptId, nodeId, containerToken, nmToken, false);
        LinkedList<ContainerId> containerIds = new LinkedList<ContainerId>();
        containerIds.add(cId);
        ContainerManagementProtocol proxy = this.getContainerManagementProtocolProxy(rpc, nmToken, nodeId, user);
        GetContainerStatusesResponse res = proxy.getContainerStatuses(GetContainerStatusesRequest.newInstance(containerIds));
        Assert.assertNotNull(res.getContainerStatuses().get(0));
        Assert.assertEquals((Object)cId, (Object)((ContainerStatus)res.getContainerStatuses().get(0)).getContainerId());
        Assert.assertEquals((Object)cId.toString(), (Object)((ContainerStatus)res.getContainerStatuses().get(0)).getContainerId().toString());
    }

    static {
        testRootDir = new File("target", TestContainerManagerSecurity.class.getName() + "-root");
        httpSpnegoKeytabFile = new File(testRootDir, "httpSpnegoKeytabFile.keytab");
        httpSpnegoPrincipal = "HTTP/localhost@EXAMPLE.COM";
    }
}

