/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.api.records.HeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.RegistrationResponse;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.junit.Test;

public class TestRMNMSecretKeys {
    @Test
    public void testNMUpdation() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        final DrainDispatcher dispatcher = new DrainDispatcher();
        ResourceManager rm = new ResourceManager(null){

            protected void doSecureLogin() throws IOException {
            }

            protected Dispatcher createDispatcher() {
                return dispatcher;
            }
        };
        rm.init((Configuration)conf);
        rm.start();
        MockNM nm = new MockNM("host:1234", 3072, rm.getResourceTrackerService());
        RegistrationResponse registrationResponse = nm.registerNode();
        MasterKey masterKey = registrationResponse.getMasterKey();
        Assert.assertNotNull((String)"Registration should cause a key-update!", (Object)masterKey);
        dispatcher.await();
        HeartbeatResponse response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)"First heartbeat after registration shouldn't get any key updates!", (Object)response.getMasterKey());
        dispatcher.await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)"Even second heartbeat after registration shouldn't get any key updates!", (Object)response.getMasterKey());
        dispatcher.await();
        RMContainerTokenSecretManager secretManager = rm.getRMContainerTokenSecretManager();
        secretManager.rollMasterKey();
        response = nm.nodeHeartbeat(true);
        Assert.assertNotNull((String)"Heartbeats after roll-over and before activation should not err out.", (Object)response.getMasterKey());
        Assert.assertEquals((String)"Roll-over should have incremented the key-id only by one!", (int)(masterKey.getKeyId() + 1), (int)response.getMasterKey().getKeyId());
        dispatcher.await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)"Second heartbeat after roll-over shouldn't get any key updates!", (Object)response.getMasterKey());
        dispatcher.await();
        secretManager.activateNextMasterKey();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)"Activation shouldn't cause any key updates!", (Object)response.getMasterKey());
        dispatcher.await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)"Even second heartbeat after activation shouldn't get any key updates!", (Object)response.getMasterKey());
        dispatcher.await();
        rm.stop();
    }
}

