/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.DataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.AMRMProtocol;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ApplicationTokenIdentifier;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.security.ApplicationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestContainerManagerSecurity {
    static Log LOG = LogFactory.getLog(TestContainerManagerSecurity.class);
    static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static FileContext localFS = null;
    private static final File localDir = new File("target", TestContainerManagerSecurity.class.getName() + "-localDir").getAbsoluteFile();
    private static MiniYARNCluster yarnCluster;
    static final Configuration conf;

    @BeforeClass
    public static void setup() throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        localFS = FileContext.getLocalFSFileContext();
        localFS.delete(new Path(localDir.getAbsolutePath()), true);
        localDir.mkdir();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.setLong("yarn.am.liveness-monitor.expiry-interval-ms", 100000L);
        UserGroupInformation.setConfiguration((Configuration)conf);
        yarnCluster = new MiniYARNCluster(TestContainerManagerSecurity.class.getName(), 1, 1, 1);
        yarnCluster.init(conf);
        yarnCluster.start();
    }

    @AfterClass
    public static void teardown() {
        yarnCluster.stop();
    }

    @Test
    public void testAuthenticatedUser() throws IOException, InterruptedException {
        LOG.info((Object)"Running test for authenticated user");
        ResourceManager resourceManager = yarnCluster.getResourceManager();
        final YarnRPC yarnRPC = YarnRPC.create((Configuration)conf);
        ApplicationId appID = resourceManager.getClientRMService().getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class)).getApplicationId();
        AMRMProtocol scheduler = this.submitAndRegisterApplication(resourceManager, yarnRPC, appID);
        final Container allocatedContainer = this.requestAndGetContainer(scheduler, appID);
        final ContainerId containerID = allocatedContainer.getId();
        UserGroupInformation authenticatedUser = UserGroupInformation.createRemoteUser((String)containerID.toString());
        ContainerToken containerToken = allocatedContainer.getContainerToken();
        Token token = new Token(containerToken.getIdentifier().array(), containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
        authenticatedUser.addToken(token);
        authenticatedUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                ContainerManager client = (ContainerManager)yarnRPC.getProxy(ContainerManager.class, NetUtils.createSocketAddr((String)allocatedContainer.getNodeId().toString()), conf);
                LOG.info((Object)"Going to make a legal stopContainer() request");
                StopContainerRequest request = (StopContainerRequest)recordFactory.newRecordInstance(StopContainerRequest.class);
                request.setContainerId(containerID);
                client.stopContainer(request);
                return null;
            }
        });
        KillApplicationRequest request = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(appID);
        resourceManager.getClientRMService().forceKillApplication(request);
    }

    @Test
    public void testMaliceUser() throws IOException, InterruptedException {
        LOG.info((Object)"Running test for malice user");
        ResourceManager resourceManager = yarnCluster.getResourceManager();
        final YarnRPC yarnRPC = YarnRPC.create((Configuration)conf);
        ApplicationId appID = resourceManager.getClientRMService().getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class)).getApplicationId();
        AMRMProtocol scheduler = this.submitAndRegisterApplication(resourceManager, yarnRPC, appID);
        final Container allocatedContainer = this.requestAndGetContainer(scheduler, appID);
        final ContainerId containerID = allocatedContainer.getId();
        UserGroupInformation maliceUser = UserGroupInformation.createRemoteUser((String)containerID.toString());
        ContainerToken containerToken = allocatedContainer.getContainerToken();
        byte[] identifierBytes = containerToken.getIdentifier().array();
        DataInputBuffer di = new DataInputBuffer();
        di.reset(identifierBytes, identifierBytes.length);
        ContainerTokenIdentifier dummyIdentifier = new ContainerTokenIdentifier();
        dummyIdentifier.readFields((DataInput)di);
        Resource modifiedResource = BuilderUtils.newResource((int)2048);
        ContainerTokenIdentifier modifiedIdentifier = new ContainerTokenIdentifier(dummyIdentifier.getContainerID(), dummyIdentifier.getNmHostAddress(), "testUser", modifiedResource, Long.MAX_VALUE, dummyIdentifier.getMasterKeyId());
        Token modifiedToken = new Token(modifiedIdentifier.getBytes(), containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
        maliceUser.addToken(modifiedToken);
        maliceUser.doAs((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ContainerManager client = (ContainerManager)yarnRPC.getProxy(ContainerManager.class, NetUtils.createSocketAddr((String)allocatedContainer.getNodeId().toString()), conf);
                LOG.info((Object)"Going to contact NM:  ilLegal request");
                GetContainerStatusRequest request = (GetContainerStatusRequest)recordFactory.newRecordInstance(GetContainerStatusRequest.class);
                request.setContainerId(containerID);
                try {
                    client.getContainerStatus(request);
                    Assert.fail((String)"Connection initiation with illegally modified tokens is expected to fail.");
                }
                catch (YarnRemoteException e) {
                    LOG.error((Object)"Got exception", (Throwable)e);
                    Assert.fail((String)"Cannot get a YARN remote exception as it will indicate RPC success");
                }
                catch (Exception e) {
                    junit.framework.Assert.assertEquals((String)UndeclaredThrowableException.class.getCanonicalName(), (String)e.getClass().getCanonicalName());
                    junit.framework.Assert.assertTrue((boolean)e.getCause().getMessage().contains("DIGEST-MD5: digest response format violation. Mismatched response."));
                }
                return null;
            }
        });
        KillApplicationRequest request = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(appID);
        resourceManager.getClientRMService().forceKillApplication(request);
    }

    @Test
    public void testUnauthorizedUser() throws IOException, InterruptedException {
        LOG.info((Object)"\n\nRunning test for malice user");
        ResourceManager resourceManager = yarnCluster.getResourceManager();
        final YarnRPC yarnRPC = YarnRPC.create((Configuration)conf);
        ApplicationId appID = resourceManager.getClientRMService().getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class)).getApplicationId();
        AMRMProtocol scheduler = this.submitAndRegisterApplication(resourceManager, yarnRPC, appID);
        final Container allocatedContainer = this.requestAndGetContainer(scheduler, appID);
        ContainerId containerID = allocatedContainer.getId();
        UserGroupInformation unauthorizedUser = UserGroupInformation.createRemoteUser((String)containerID.toString());
        ContainerToken containerToken = allocatedContainer.getContainerToken();
        byte[] identifierBytes = containerToken.getIdentifier().array();
        DataInputBuffer di = new DataInputBuffer();
        di.reset(identifierBytes, identifierBytes.length);
        final ContainerTokenIdentifier tokenId = new ContainerTokenIdentifier();
        tokenId.readFields((DataInput)di);
        Token token = new Token(identifierBytes, containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
        unauthorizedUser.addToken(token);
        ContainerManager client = (ContainerManager)unauthorizedUser.doAs((PrivilegedAction)new PrivilegedAction<ContainerManager>(){

            @Override
            public ContainerManager run() {
                ContainerManager client = (ContainerManager)yarnRPC.getProxy(ContainerManager.class, NetUtils.createSocketAddr((String)allocatedContainer.getNodeId().toString()), conf);
                LOG.info((Object)"Going to contact NM:  unauthorized request");
                TestContainerManagerSecurity.this.callWithIllegalContainerID(client, tokenId);
                TestContainerManagerSecurity.this.callWithIllegalResource(client, tokenId);
                TestContainerManagerSecurity.this.callWithIllegalUserName(client, tokenId);
                return client;
            }
        });
        RPC.stopProxy((Object)client);
        unauthorizedUser = UserGroupInformation.createRemoteUser((String)containerID.toString());
        RMContainerTokenSecretManager containerTokenSecreteManager = resourceManager.getRMContainerTokenSecretManager();
        final ContainerTokenIdentifier newTokenId = new ContainerTokenIdentifier(tokenId.getContainerID(), tokenId.getNmHostAddress(), "testUser", tokenId.getResource(), System.currentTimeMillis() - 1L, containerTokenSecreteManager.getCurrentKey().getKeyId());
        byte[] passowrd = containerTokenSecreteManager.createPassword(newTokenId);
        token = new Token(newTokenId.getBytes(), passowrd, new Text(containerToken.getKind()), new Text(containerToken.getService()));
        unauthorizedUser.addToken(token);
        unauthorizedUser.doAs((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ContainerManager client = (ContainerManager)yarnRPC.getProxy(ContainerManager.class, NetUtils.createSocketAddr((String)allocatedContainer.getNodeId().toString()), conf);
                LOG.info((Object)"Going to contact NM with expired token");
                ContainerLaunchContext context = TestContainerManagerSecurity.this.createContainerLaunchContextForTest(newTokenId);
                StartContainerRequest request = (StartContainerRequest)Records.newRecord(StartContainerRequest.class);
                request.setContainerLaunchContext(context);
                try {
                    client.startContainer(request);
                    Assert.fail((String)"Connection initiation with expired token is expected to fail.");
                }
                catch (Throwable t) {
                    LOG.info((Object)"Got exception : ", t);
                    junit.framework.Assert.assertTrue((boolean)t.getMessage().contains("This token is expired. current time is"));
                }
                StopContainerRequest stopRequest = (StopContainerRequest)Records.newRecord(StopContainerRequest.class);
                stopRequest.setContainerId(newTokenId.getContainerID());
                try {
                    client.stopContainer(stopRequest);
                }
                catch (Throwable t) {
                    Assert.fail((String)"Stop Container call should have succeeded");
                }
                return null;
            }
        });
        KillApplicationRequest request = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(appID);
        resourceManager.getClientRMService().forceKillApplication(request);
    }

    private AMRMProtocol submitAndRegisterApplication(ResourceManager resourceManager, final YarnRPC yarnRPC, ApplicationId appID) throws IOException, UnsupportedFileSystemException, YarnRemoteException, InterruptedException {
        RMAppAttemptState state;
        String fileName = "testFile-" + appID.toString();
        File testFile = new File(localDir.getAbsolutePath(), fileName);
        FileWriter tmpFile = new FileWriter(testFile);
        tmpFile.write("testing");
        tmpFile.close();
        URL testFileURL = ConverterUtils.getYarnUrlFromPath((Path)FileContext.getFileContext().makeQualified(new Path(localDir.getAbsolutePath(), fileName)));
        LocalResource rsrc = BuilderUtils.newLocalResource((URL)testFileURL, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PRIVATE, (long)testFile.length(), (long)testFile.lastModified());
        ContainerLaunchContext amContainer = BuilderUtils.newContainerLaunchContext(null, (String)"testUser", (Resource)BuilderUtils.newResource((int)1024), Collections.singletonMap(fileName, rsrc), new HashMap(), Arrays.asList("sleep", "100"), new HashMap(), null, new HashMap());
        ApplicationSubmissionContext appSubmissionContext = (ApplicationSubmissionContext)recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        appSubmissionContext.setApplicationId(appID);
        appSubmissionContext.setUser("testUser");
        appSubmissionContext.setAMContainerSpec(amContainer);
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        submitRequest.setApplicationSubmissionContext(appSubmissionContext);
        resourceManager.getClientRMService().submitApplication(submitRequest);
        int waitCounter = 0;
        RMApp app = (RMApp)resourceManager.getRMContext().getRMApps().get(appID);
        RMAppAttempt appAttempt = app == null ? null : app.getCurrentAppAttempt();
        RMAppAttemptState rMAppAttemptState = state = appAttempt == null ? null : appAttempt.getAppAttemptState();
        while (!(app != null && appAttempt != null && state != null && state.equals((Object)RMAppAttemptState.LAUNCHED) || waitCounter++ == 20)) {
            LOG.info((Object)"Waiting for applicationAttempt to be created.. ");
            Thread.sleep(1000L);
            app = (RMApp)resourceManager.getRMContext().getRMApps().get(appID);
            appAttempt = app == null ? null : app.getCurrentAppAttempt();
            state = appAttempt == null ? null : appAttempt.getAppAttemptState();
        }
        junit.framework.Assert.assertNotNull((Object)app);
        junit.framework.Assert.assertNotNull((Object)appAttempt);
        junit.framework.Assert.assertNotNull((Object)state);
        junit.framework.Assert.assertEquals((Object)RMAppAttemptState.LAUNCHED, (Object)state);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)appAttempt.getAppAttemptId().toString());
        final InetSocketAddress schedulerAddr = resourceManager.getApplicationMasterService().getBindAddress();
        ApplicationTokenIdentifier appTokenIdentifier = new ApplicationTokenIdentifier(appAttempt.getAppAttemptId());
        ApplicationTokenSecretManager appTokenSecretManager = new ApplicationTokenSecretManager(conf);
        appTokenSecretManager.setMasterKey(resourceManager.getApplicationTokenSecretManager().getMasterKey());
        Token appToken = new Token((TokenIdentifier)appTokenIdentifier, (SecretManager)appTokenSecretManager);
        SecurityUtil.setTokenService((Token)appToken, (InetSocketAddress)schedulerAddr);
        currentUser.addToken(appToken);
        AMRMProtocol scheduler = (AMRMProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<AMRMProtocol>(){

            @Override
            public AMRMProtocol run() {
                return (AMRMProtocol)yarnRPC.getProxy(AMRMProtocol.class, schedulerAddr, conf);
            }
        });
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)recordFactory.newRecordInstance(RegisterApplicationMasterRequest.class);
        request.setApplicationAttemptId(((RMApp)resourceManager.getRMContext().getRMApps().get(appID)).getCurrentAppAttempt().getAppAttemptId());
        scheduler.registerApplicationMaster(request);
        return scheduler;
    }

    private Container requestAndGetContainer(AMRMProtocol scheduler, ApplicationId appID) throws YarnRemoteException, InterruptedException {
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.add(BuilderUtils.newResourceRequest((Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((int)1024), (int)1));
        AllocateRequest allocateRequest = BuilderUtils.newAllocateRequest((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)appID, (int)1), (int)0, (float)0.0f, ask, new ArrayList());
        List allocatedContainers = scheduler.allocate(allocateRequest).getAMResponse().getAllocatedContainers();
        allocateRequest.clearAsks();
        int waitCounter = 0;
        while ((allocatedContainers == null || allocatedContainers.size() == 0) && waitCounter++ != 20) {
            LOG.info((Object)"Waiting for container to be allocated..");
            Thread.sleep(1000L);
            allocateRequest.setResponseId(allocateRequest.getResponseId() + 1);
            allocatedContainers = scheduler.allocate(allocateRequest).getAMResponse().getAllocatedContainers();
        }
        junit.framework.Assert.assertNotNull((String)"Container is not allocted!", (Object)allocatedContainers);
        junit.framework.Assert.assertEquals((String)"Didn't get one container!", (int)1, (int)allocatedContainers.size());
        return (Container)allocatedContainers.get(0);
    }

    void callWithIllegalContainerID(ContainerManager client, ContainerTokenIdentifier tokenId) {
        GetContainerStatusRequest request = (GetContainerStatusRequest)recordFactory.newRecordInstance(GetContainerStatusRequest.class);
        ContainerId newContainerId = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)tokenId.getContainerID().getApplicationAttemptId().getApplicationId(), (int)1), (int)42);
        request.setContainerId(newContainerId);
        try {
            client.getContainerStatus(request);
            Assert.fail((String)"Connection initiation with unauthorized access is expected to fail.");
        }
        catch (YarnRemoteException e) {
            LOG.info((Object)"Got exception : ", (Throwable)e);
            junit.framework.Assert.assertEquals((String)("Unauthorized request to start container. \nExpected containerId: " + tokenId.getContainerID() + " Found: " + newContainerId.toString()), (String)e.getMessage());
        }
    }

    void callWithIllegalResource(ContainerManager client, ContainerTokenIdentifier tokenId) {
        StartContainerRequest request = (StartContainerRequest)recordFactory.newRecordInstance(StartContainerRequest.class);
        ContainerLaunchContext context = this.createContainerLaunchContextForTest(tokenId);
        context.getResource().setMemory(2048);
        request.setContainerLaunchContext(context);
        try {
            client.startContainer(request);
            Assert.fail((String)"Connection initiation with unauthorized access is expected to fail.");
        }
        catch (YarnRemoteException e) {
            LOG.info((Object)"Got exception : ", (Throwable)e);
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("Unauthorized request to start container. "));
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("\nExpected resource " + tokenId.getResource().toString() + " but found " + context.getResource().toString()));
        }
    }

    void callWithIllegalUserName(ContainerManager client, ContainerTokenIdentifier tokenId) {
        StartContainerRequest request = (StartContainerRequest)recordFactory.newRecordInstance(StartContainerRequest.class);
        ContainerLaunchContext context = this.createContainerLaunchContextForTest(tokenId);
        context.setUser("Saruman");
        request.setContainerLaunchContext(context);
        try {
            client.startContainer(request);
            Assert.fail((String)"Connection initiation with unauthorized access is expected to fail.");
        }
        catch (YarnRemoteException e) {
            LOG.info((Object)"Got exception : ", (Throwable)e);
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("Unauthorized request to start container. "));
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("Expected user-name " + tokenId.getApplicationSubmitter() + " but found " + context.getUser()));
        }
    }

    private ContainerLaunchContext createContainerLaunchContextForTest(ContainerTokenIdentifier tokenId) {
        ContainerLaunchContext context = BuilderUtils.newContainerLaunchContext((ContainerId)tokenId.getContainerID(), (String)"testUser", (Resource)BuilderUtils.newResource((int)tokenId.getResource().getMemory()), new HashMap(), new HashMap(), new ArrayList(), new HashMap(), null, new HashMap());
        return context;
    }

    static {
        conf = new Configuration();
    }
}

