/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Store;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFactory;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;

public class MiniYARNCluster
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(MiniYARNCluster.class);
    private NodeManager[] nodeManagers;
    private ResourceManager resourceManager;
    private ResourceManagerWrapper resourceManagerWrapper;
    private File testWorkDir;
    private int numLocalDirs;
    private int numLogDirs;

    public MiniYARNCluster(String testName, int noOfNodeManagers, int numLocalDirs, int numLogDirs) {
        super(testName.replace("$", ""));
        this.numLocalDirs = numLocalDirs;
        this.numLogDirs = numLogDirs;
        this.testWorkDir = new File("target", testName.replace("$", ""));
        try {
            FileContext.getLocalFSFileContext().delete(new Path(this.testWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn((Object)"COULD NOT CLEANUP", (Throwable)e);
            throw new YarnException("could not cleanup test dir", (Throwable)e);
        }
        this.resourceManagerWrapper = new ResourceManagerWrapper();
        this.addService((Service)this.resourceManagerWrapper);
        this.nodeManagers = new CustomNodeManager[noOfNodeManagers];
        for (int index = 0; index < noOfNodeManagers; ++index) {
            this.addService((Service)new NodeManagerWrapper(index));
            this.nodeManagers[index] = new CustomNodeManager();
        }
    }

    public void init(Configuration conf) {
        super.init((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
    }

    public File getTestWorkDir() {
        return this.testWorkDir;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public NodeManager getNodeManager(int i) {
        return this.nodeManagers[i];
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    private class CustomNodeManager
    extends NodeManager {
        private CustomNodeManager() {
        }

        protected void doSecureLogin() throws IOException {
        }

        protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
            return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics){

                protected ResourceTracker getRMClient() {
                    final ResourceTrackerService rt = MiniYARNCluster.this.resourceManager.getResourceTrackerService();
                    final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
                    return new ResourceTracker(){

                        public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnRemoteException {
                            NodeHeartbeatResponse response = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
                            try {
                                response.setHeartbeatResponse(rt.nodeHeartbeat(request).getHeartbeatResponse());
                            }
                            catch (IOException ioe) {
                                LOG.info((Object)("Exception in heartbeat from node " + request.getNodeStatus().getNodeId()), (Throwable)ioe);
                                throw RPCUtil.getRemoteException((Throwable)ioe);
                            }
                            return response;
                        }

                        public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnRemoteException {
                            RegisterNodeManagerResponse response = (RegisterNodeManagerResponse)recordFactory.newRecordInstance(RegisterNodeManagerResponse.class);
                            try {
                                response.setRegistrationResponse(rt.registerNodeManager(request).getRegistrationResponse());
                            }
                            catch (IOException ioe) {
                                LOG.info((Object)("Exception in node registration from " + request.getNodeId().toString()), (Throwable)ioe);
                                throw RPCUtil.getRemoteException((Throwable)ioe);
                            }
                            return response;
                        }
                    };
                }
            };
        }
    }

    private class NodeManagerWrapper
    extends AbstractService {
        int index;

        public NodeManagerWrapper(int i) {
            super(NodeManagerWrapper.class.getName() + "_" + i);
            this.index = 0;
            this.index = i;
        }

        public synchronized void init(Configuration conf) {
            YarnConfiguration config = new YarnConfiguration(conf);
            super.init((Configuration)config);
        }

        private String prepareDirs(String dirType, int numDirs) {
            File[] dirs = new File[numDirs];
            String dirsString = "";
            for (int i = 0; i < numDirs; ++i) {
                dirs[i] = new File(MiniYARNCluster.this.testWorkDir, MiniYARNCluster.this.getName() + "-" + dirType + "Dir-nm-" + this.index + "_" + i);
                dirs[i].mkdir();
                LOG.info((Object)("Created " + dirType + "Dir in " + dirs[i].getAbsolutePath()));
                String delimiter = i > 0 ? "," : "";
                dirsString = dirsString.concat(delimiter + dirs[i].getAbsolutePath());
            }
            return dirsString;
        }

        public synchronized void start() {
            try {
                String localDirsString = this.prepareDirs("local", MiniYARNCluster.this.numLocalDirs);
                this.getConfig().set("yarn.nodemanager.local-dirs", localDirsString);
                String logDirsString = this.prepareDirs("log", MiniYARNCluster.this.numLogDirs);
                this.getConfig().set("yarn.nodemanager.log-dirs", logDirsString);
                File remoteLogDir = new File(MiniYARNCluster.this.testWorkDir, MiniYARNCluster.this.getName() + "-remoteLogDir-nm-" + this.index);
                remoteLogDir.mkdir();
                this.getConfig().set("yarn.nodemanager.remote-app-log-dir", remoteLogDir.getAbsolutePath());
                this.getConfig().setInt("yarn.nodemanager.resource.memory-mb", 4096);
                this.getConfig().set("yarn.nodemanager.address", MiniYARNCluster.getHostname() + ":0");
                this.getConfig().set("yarn.nodemanager.localizer.address", MiniYARNCluster.getHostname() + ":0");
                this.getConfig().set("yarn.nodemanager.webapp.address", MiniYARNCluster.getHostname() + ":0");
                LOG.info((Object)("Starting NM: " + this.index));
                MiniYARNCluster.this.nodeManagers[this.index].init(this.getConfig());
                new Thread(){

                    @Override
                    public void run() {
                        MiniYARNCluster.this.nodeManagers[NodeManagerWrapper.this.index].start();
                    }
                }.start();
                int waitCount = 0;
                while (MiniYARNCluster.this.nodeManagers[this.index].getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
                    LOG.info((Object)("Waiting for NM " + this.index + " to start..."));
                    Thread.sleep(1000L);
                }
                if (MiniYARNCluster.this.nodeManagers[this.index].getServiceState() != Service.STATE.STARTED) {
                    throw new IOException("NodeManager " + this.index + " failed to start");
                }
                super.start();
            }
            catch (Throwable t) {
                throw new YarnException(t);
            }
        }

        public synchronized void stop() {
            if (MiniYARNCluster.this.nodeManagers[this.index] != null) {
                MiniYARNCluster.this.nodeManagers[this.index].stop();
            }
            super.stop();
        }
    }

    private class ResourceManagerWrapper
    extends AbstractService {
        public ResourceManagerWrapper() {
            super(ResourceManagerWrapper.class.getName());
        }

        public synchronized void start() {
            try {
                this.getConfig().setBoolean("yarn..is.minicluster", true);
                if (!this.getConfig().getBoolean("yarn.minicluster.fixed.ports", YarnConfiguration.DEFAULT_YARN_MINICLUSTER_FIXED_PORTS)) {
                    this.getConfig().set("yarn.resourcemanager.address", MiniYARNCluster.getHostname() + ":0");
                    this.getConfig().set("yarn.resourcemanager.admin.address", MiniYARNCluster.getHostname() + ":0");
                    this.getConfig().set("yarn.resourcemanager.scheduler.address", MiniYARNCluster.getHostname() + ":0");
                    this.getConfig().set("yarn.resourcemanager.resource-tracker.address", MiniYARNCluster.getHostname() + ":0");
                    this.getConfig().set("yarn.resourcemanager.webapp.address", MiniYARNCluster.getHostname() + ":0");
                }
                Store store = StoreFactory.getStore((Configuration)this.getConfig());
                MiniYARNCluster.this.resourceManager = new ResourceManager(store){

                    protected void doSecureLogin() throws IOException {
                    }
                };
                MiniYARNCluster.this.resourceManager.init(this.getConfig());
                new Thread(){

                    @Override
                    public void run() {
                        MiniYARNCluster.this.resourceManager.start();
                    }
                }.start();
                int waitCount = 0;
                while (MiniYARNCluster.this.resourceManager.getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
                    LOG.info((Object)"Waiting for RM to start...");
                    Thread.sleep(1500L);
                }
                if (MiniYARNCluster.this.resourceManager.getServiceState() != Service.STATE.STARTED) {
                    throw new IOException("ResourceManager failed to start. Final state is " + MiniYARNCluster.this.resourceManager.getServiceState());
                }
                super.start();
            }
            catch (Throwable t) {
                throw new YarnException(t);
            }
            LOG.info((Object)("MiniYARN ResourceManager address: " + this.getConfig().get("yarn.resourcemanager.address")));
            LOG.info((Object)("MiniYARN ResourceManager web address: " + this.getConfig().get("yarn.resourcemanager.webapp.address")));
        }

        public synchronized void stop() {
            if (MiniYARNCluster.this.resourceManager != null) {
                MiniYARNCluster.this.resourceManager.stop();
            }
            super.stop();
        }
    }
}

