/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class FifoScheduler
implements ResourceScheduler,
Configurable {
    private static final Log LOG = LogFactory.getLog(FifoScheduler.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    Configuration conf;
    private static final Container[] EMPTY_CONTAINER_ARRAY = new Container[0];
    private static final List<Container> EMPTY_CONTAINER_LIST = Arrays.asList(EMPTY_CONTAINER_ARRAY);
    private RMContext rmContext;
    protected Map<NodeId, FiCaSchedulerNode> nodes = new ConcurrentHashMap<NodeId, FiCaSchedulerNode>();
    private boolean initialized;
    private Resource minimumAllocation;
    private Resource maximumAllocation;
    private boolean usePortForNodeName;
    @VisibleForTesting
    protected Map<ApplicationAttemptId, FiCaSchedulerApp> applications = new ConcurrentSkipListMap<ApplicationAttemptId, FiCaSchedulerApp>();
    private ActiveUsersManager activeUsersManager;
    private static final String DEFAULT_QUEUE_NAME = "default";
    private QueueMetrics metrics;
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    private final Queue DEFAULT_QUEUE = new Queue(){

        @Override
        public String getQueueName() {
            return FifoScheduler.DEFAULT_QUEUE_NAME;
        }

        @Override
        public QueueMetrics getMetrics() {
            return FifoScheduler.this.metrics;
        }

        @Override
        public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
            QueueInfo queueInfo = (QueueInfo)recordFactory.newRecordInstance(QueueInfo.class);
            queueInfo.setQueueName(FifoScheduler.this.DEFAULT_QUEUE.getQueueName());
            queueInfo.setCapacity(1.0f);
            if (FifoScheduler.this.clusterResource.getMemory() == 0) {
                queueInfo.setCurrentCapacity(0.0f);
            } else {
                queueInfo.setCurrentCapacity((float)FifoScheduler.this.usedResource.getMemory() / (float)FifoScheduler.this.clusterResource.getMemory());
            }
            queueInfo.setMaximumCapacity(1.0f);
            queueInfo.setChildQueues(new ArrayList());
            queueInfo.setQueueState(QueueState.RUNNING);
            return queueInfo;
        }

        public Map<QueueACL, AccessControlList> getQueueAcls() {
            HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
            for (QueueACL acl : QueueACL.values()) {
                acls.put(acl, new AccessControlList("*"));
            }
            return acls;
        }

        @Override
        public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation unused) {
            QueueUserACLInfo queueUserAclInfo = (QueueUserACLInfo)recordFactory.newRecordInstance(QueueUserACLInfo.class);
            queueUserAclInfo.setQueueName(FifoScheduler.DEFAULT_QUEUE_NAME);
            queueUserAclInfo.setUserAcls(Arrays.asList(QueueACL.values()));
            return Collections.singletonList(queueUserAclInfo);
        }

        @Override
        public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
            return this.getQueueAcls().get(acl).isUserAllowed(user);
        }
    };
    private static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0));
    private Resource clusterResource = (Resource)recordFactory.newRecordInstance(Resource.class);
    private Resource usedResource = (Resource)recordFactory.newRecordInstance(Resource.class);

    public synchronized void setConf(Configuration conf) {
        this.conf = conf;
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem <= 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min and max should be greater than 0" + ", max should be no smaller than min.");
        }
    }

    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodes.size();
    }

    @Override
    public Resource getMaximumResourceCapability() {
        return this.maximumAllocation;
    }

    @Override
    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        this.setConf(conf);
        if (!this.initialized) {
            this.validateConf(conf);
            this.rmContext = rmContext;
            this.minimumAllocation = Resources.createResource((int)conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024));
            this.maximumAllocation = Resources.createResource((int)conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192));
            this.usePortForNodeName = conf.getBoolean("yarn.scheduler.include-port-in-node-name", false);
            this.metrics = QueueMetrics.forQueue(DEFAULT_QUEUE_NAME, null, false, conf);
            this.activeUsersManager = new ActiveUsersManager(this.metrics);
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.error((Object)("Calling allocate on removed or non existant application " + applicationAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, this.resourceCalculator, this.clusterResource, this.minimumAllocation, this.maximumAllocation);
        for (ContainerId releasedContainer : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainer);
            if (rmContainer == null) {
                RMAuditLogger.logFailure(application.getUser(), "AM Released Container", "Unauthorized access or invalid container", "FifoScheduler", "Trying to release container not owned by app or with invalid id", application.getApplicationId(), releasedContainer);
            }
            this.containerCompleted(rmContainer, SchedulerUtils.createAbnormalContainerStatus(releasedContainer, "Container released by application"), RMContainerEventType.RELEASED);
        }
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            if (application.isStopped()) {
                LOG.info((Object)("Calling allocate on a stopped application " + applicationAttemptId));
                return EMPTY_ALLOCATION;
            }
            if (!ask.isEmpty()) {
                LOG.debug((Object)("allocate: pre-update applicationId=" + applicationAttemptId + " application=" + application));
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)("allocate: post-update applicationId=" + applicationAttemptId + " application=" + application));
                application.showRequests();
                LOG.debug((Object)("allocate: applicationId=" + applicationAttemptId + " #ask=" + ask.size()));
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            return new Allocation(application.pullNewlyAllocatedContainers(), application.getHeadroom());
        }
    }

    @VisibleForTesting
    FiCaSchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applications.get(applicationAttemptId);
    }

    @Override
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId applicationAttemptId) {
        FiCaSchedulerApp app = this.getApplication(applicationAttemptId);
        return app == null ? null : new SchedulerAppReport(app);
    }

    @Override
    public ApplicationResourceUsageReport getAppResourceUsageReport(ApplicationAttemptId applicationAttemptId) {
        FiCaSchedulerApp app = this.getApplication(applicationAttemptId);
        return app == null ? null : app.getResourceUsageReport();
    }

    private FiCaSchedulerNode getNode(NodeId nodeId) {
        return this.nodes.get(nodeId);
    }

    private synchronized void addApplicationAttempt(ApplicationAttemptId appAttemptId, String user) {
        FiCaSchedulerApp schedulerApp = new FiCaSchedulerApp(appAttemptId, user, this.DEFAULT_QUEUE, this.activeUsersManager, this.rmContext);
        this.applications.put(appAttemptId, schedulerApp);
        this.metrics.submitApp(user, appAttemptId.getAttemptId());
        LOG.info((Object)("Application Submission: " + appAttemptId.getApplicationId() + " from " + user + ", currently active: " + this.applications.size()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.APP_ACCEPTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doneApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState) throws IOException {
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            throw new IOException("Unknown application " + applicationAttemptId + " has completed!");
        }
        for (RMContainer container : application.getLiveContainers()) {
            this.containerCompleted(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            this.activeUsersManager.deactivateApplication(application.getUser(), application.getApplicationId());
        }
        application.stop(rmAppAttemptFinalState);
        this.applications.remove(applicationAttemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignContainers(FiCaSchedulerNode node) {
        LOG.debug((Object)("assignContainers: node=" + node.getRMNode().getNodeAddress() + " #applications=" + this.applications.size()));
        for (Map.Entry<ApplicationAttemptId, FiCaSchedulerApp> e : this.applications.entrySet()) {
            FiCaSchedulerApp application = e.getValue();
            LOG.debug((Object)"pre-assignContainers");
            application.showRequests();
            FiCaSchedulerApp fiCaSchedulerApp = application;
            synchronized (fiCaSchedulerApp) {
                int assignedContainers;
                Priority priority;
                int maxContainers;
                if (SchedulerAppUtils.isBlacklisted(application, node, LOG)) {
                    continue;
                }
                Iterator<Priority> i$ = application.getPriorities().iterator();
                while (i$.hasNext() && ((maxContainers = this.getMaxAllocatableContainers(application, priority = i$.next(), node, NodeType.OFF_SWITCH)) <= 0 || (assignedContainers = this.assignContainersOnNode(node, application, priority)) != 0)) {
                }
            }
            LOG.debug((Object)"post-assignContainers");
            application.showRequests();
            if (!Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)node.getAvailableResource(), (Resource)this.minimumAllocation)) continue;
            break;
        }
        for (FiCaSchedulerApp application : this.applications.values()) {
            application.setHeadroom(Resources.subtract((Resource)this.clusterResource, (Resource)this.usedResource));
        }
    }

    private int getMaxAllocatableContainers(FiCaSchedulerApp application, Priority priority, FiCaSchedulerNode node, NodeType type) {
        ResourceRequest nodeLocalRequest;
        ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
        int maxContainers = offSwitchRequest.getNumContainers();
        if (type == NodeType.OFF_SWITCH) {
            return maxContainers;
        }
        if (type == NodeType.RACK_LOCAL) {
            ResourceRequest rackLocalRequest = application.getResourceRequest(priority, node.getRMNode().getRackName());
            if (rackLocalRequest == null) {
                return maxContainers;
            }
            maxContainers = Math.min(maxContainers, rackLocalRequest.getNumContainers());
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = application.getResourceRequest(priority, node.getRMNode().getNodeAddress())) != null) {
            maxContainers = Math.min(maxContainers, nodeLocalRequest.getNumContainers());
        }
        return maxContainers;
    }

    private int assignContainersOnNode(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int nodeLocalContainers = this.assignNodeLocalContainers(node, application, priority);
        int rackLocalContainers = this.assignRackLocalContainers(node, application, priority);
        int offSwitchContainers = this.assignOffSwitchContainers(node, application, priority);
        LOG.debug((Object)("assignContainersOnNode: node=" + node.getRMNode().getNodeAddress() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " #assigned=" + (nodeLocalContainers + rackLocalContainers + offSwitchContainers)));
        return nodeLocalContainers + rackLocalContainers + offSwitchContainers;
    }

    private int assignNodeLocalContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, node.getNodeName());
        if (request != null) {
            ResourceRequest rackRequest = application.getResourceRequest(priority, node.getRMNode().getRackName());
            if (rackRequest == null || rackRequest.getNumContainers() <= 0) {
                return 0;
            }
            int assignableContainers = Math.min(this.getMaxAllocatableContainers(application, priority, node, NodeType.NODE_LOCAL), request.getNumContainers());
            assignedContainers = this.assignContainer(node, application, priority, assignableContainers, request, NodeType.NODE_LOCAL);
        }
        return assignedContainers;
    }

    private int assignRackLocalContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, node.getRMNode().getRackName());
        if (request != null) {
            ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
            if (offSwitchRequest.getNumContainers() <= 0) {
                return 0;
            }
            int assignableContainers = Math.min(this.getMaxAllocatableContainers(application, priority, node, NodeType.RACK_LOCAL), request.getNumContainers());
            assignedContainers = this.assignContainer(node, application, priority, assignableContainers, request, NodeType.RACK_LOCAL);
        }
        return assignedContainers;
    }

    private int assignOffSwitchContainers(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority) {
        int assignedContainers = 0;
        ResourceRequest request = application.getResourceRequest(priority, "*");
        if (request != null) {
            assignedContainers = this.assignContainer(node, application, priority, request.getNumContainers(), request, NodeType.OFF_SWITCH);
        }
        return assignedContainers;
    }

    private int assignContainer(FiCaSchedulerNode node, FiCaSchedulerApp application, Priority priority, int assignableContainers, ResourceRequest request, NodeType type) {
        LOG.debug((Object)("assignContainers: node=" + node.getRMNode().getNodeAddress() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " assignableContainers=" + assignableContainers + " request=" + request + " type=" + (Object)((Object)type)));
        Resource capability = request.getCapability();
        int availableContainers = node.getAvailableResource().getMemory() / capability.getMemory();
        int assignedContainers = Math.min(assignableContainers, availableContainers);
        if (assignedContainers > 0) {
            for (int i = 0; i < assignedContainers; ++i) {
                NodeId nodeId = node.getRMNode().getNodeID();
                ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (int)application.getNewContainerId());
                Token containerToken = null;
                containerToken = this.rmContext.getContainerTokenSecretManager().createContainerToken(containerId, nodeId, application.getUser(), capability);
                if (containerToken == null) {
                    return i;
                }
                Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, (Token)containerToken);
                RMContainer rmContainer = application.allocate(type, node, priority, request, container);
                node.allocateContainer(application.getApplicationId(), rmContainer);
                Resources.addTo((Resource)this.usedResource, (Resource)capability);
            }
        }
        return assignedContainers;
    }

    private synchronized void nodeUpdate(RMNode rmNode) {
        FiCaSchedulerNode node = this.getNode(rmNode.getNodeID());
        SchedulerUtils.updateResourceIfChanged(node, rmNode, this.clusterResource, LOG);
        List<UpdatedContainerInfo> containerInfoList = rmNode.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.containerCompleted(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.clusterResource, (Resource)node.getAvailableResource(), (Resource)this.minimumAllocation)) {
            LOG.debug((Object)("Node heartbeat " + rmNode.getNodeID() + " available resource = " + node.getAvailableResource()));
            this.assignContainers(node);
            LOG.debug((Object)("Node after allocation " + rmNode.getNodeID() + " resource = " + node.getAvailableResource()));
        }
        this.metrics.setAvailableResourcesToQueue(Resources.subtract((Resource)this.clusterResource, (Resource)this.usedResource));
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getUser());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                try {
                    this.doneApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState());
                }
                catch (IOException ie) {
                    LOG.error((Object)("Unable to remove application " + appAttemptRemovedEvent.getApplicationAttemptID()), (Throwable)ie);
                }
                break;
            }
            case CONTAINER_EXPIRED: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerid = containerExpiredEvent.getContainerId();
                this.containerCompleted(this.getRMContainer(containerid), SchedulerUtils.createAbnormalContainerStatus(containerid, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, FiCaSchedulerNode node) {
        ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application: " + applicationAttemptId + " launched container " + containerId + " on node: " + node));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        application.containerLaunchedOnNode(containerId, node.getNodeID());
    }

    @Lock(value={FifoScheduler.class})
    private synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        ApplicationAttemptId applicationAttemptId = container.getId().getApplicationAttemptId();
        FiCaSchedulerApp application = this.getApplication(applicationAttemptId);
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        if (application == null) {
            LOG.info((Object)("Unknown application: " + applicationAttemptId + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
            return;
        }
        application.containerCompleted(rmContainer, containerStatus, event);
        node.releaseContainer(container);
        Resources.subtractFrom((Resource)this.usedResource, (Resource)container.getResource());
        LOG.info((Object)("Application " + applicationAttemptId + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    private synchronized void removeNode(RMNode nodeInfo) {
        FiCaSchedulerNode node = this.getNode(nodeInfo.getNodeID());
        if (node == null) {
            return;
        }
        for (RMContainer container : node.getRunningContainers()) {
            this.containerCompleted(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(nodeInfo.getNodeID());
        Resources.subtractFrom((Resource)this.clusterResource, (Resource)node.getRMNode().getTotalCapability());
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) {
        return this.DEFAULT_QUEUE.getQueueInfo(false, false);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        return this.DEFAULT_QUEUE.getQueueUserAclInfo(null);
    }

    private synchronized void addNode(RMNode nodeManager) {
        this.nodes.put(nodeManager.getNodeID(), new FiCaSchedulerNode(nodeManager, this.usePortForNodeName));
        Resources.addTo((Resource)this.clusterResource, (Resource)nodeManager.getTotalCapability());
    }

    @Override
    public void recover(RMStateStore.RMState state) {
    }

    @Override
    public synchronized SchedulerNodeReport getNodeReport(NodeId nodeId) {
        FiCaSchedulerNode node = this.getNode(nodeId);
        return node == null ? null : new SchedulerNodeReport(node);
    }

    private RMContainer getRMContainer(ContainerId containerId) {
        FiCaSchedulerApp application = this.getApplication(containerId.getApplicationAttemptId());
        return application == null ? null : application.getRMContainer(containerId);
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.DEFAULT_QUEUE.getMetrics();
    }

    @Override
    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        return this.DEFAULT_QUEUE.hasAccess(acl, callerUGI);
    }

    @Override
    public synchronized List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        if (queueName.equals(this.DEFAULT_QUEUE.getQueueName())) {
            ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>(this.applications.size());
            for (FiCaSchedulerApp app : this.applications.values()) {
                apps.add(app.getApplicationAttemptId());
            }
            return apps;
        }
        return null;
    }
}

