/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.Groups;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class QueuePlacementRule {
    protected boolean create;

    public QueuePlacementRule initialize(boolean create, Map<String, String> args) {
        this.create = create;
        return this;
    }

    public String assignAppToQueue(String requestedQueue, String user, Groups groups, Collection<String> configuredQueues) throws IOException {
        String queue = this.getQueueForApp(requestedQueue, user, groups, configuredQueues);
        if (this.create || configuredQueues.contains(queue)) {
            return queue;
        }
        return "";
    }

    public void initializeFromXml(Element el) {
        boolean create = true;
        NamedNodeMap attributes = el.getAttributes();
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            String key = node.getNodeName();
            String value = node.getNodeValue();
            if (key.equals("create")) {
                create = Boolean.parseBoolean(value);
                continue;
            }
            args.put(key, value);
        }
        this.initialize(create, args);
    }

    public abstract boolean isTerminal();

    protected abstract String getQueueForApp(String var1, String var2, Groups var3, Collection<String> var4) throws IOException;

    public static class Reject
    extends QueuePlacementRule {
        @Override
        public String assignAppToQueue(String requestedQueue, String user, Groups groups, Collection<String> configuredQueues) {
            return null;
        }

        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Collection<String> configuredQueues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTerminal() {
            return true;
        }
    }

    public static class Default
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Collection<String> configuredQueues) {
            return "root.default";
        }

        @Override
        public boolean isTerminal() {
            return this.create;
        }
    }

    public static class Specified
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Collection<String> configuredQueues) {
            if (requestedQueue.equals("default")) {
                return "";
            }
            if (!requestedQueue.startsWith("root.")) {
                requestedQueue = "root." + requestedQueue;
            }
            return requestedQueue;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    public static class SecondaryGroupExistingQueue
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Collection<String> configuredQueues) throws IOException {
            List groupNames = groups.getGroups(user);
            for (int i = 1; i < groupNames.size(); ++i) {
                if (!configuredQueues.contains("root." + (String)groupNames.get(i))) continue;
                return "root." + (String)groupNames.get(i);
            }
            return "";
        }

        @Override
        public boolean isTerminal() {
            return this.create;
        }
    }

    public static class PrimaryGroup
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Collection<String> configuredQueues) throws IOException {
            return "root." + (String)groups.getGroups(user).get(0);
        }

        @Override
        public boolean isTerminal() {
            return this.create;
        }
    }

    public static class User
    extends QueuePlacementRule {
        @Override
        protected String getQueueForApp(String requestedQueue, String user, Groups groups, Collection<String> configuredQueues) {
            return "root." + user;
        }

        @Override
        public boolean isTerminal() {
            return this.create;
        }
    }
}

