/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb;

import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoBase;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;

public class ApplicationStateDataPBImpl
extends ProtoBase<YarnServerResourceManagerServiceProtos.ApplicationStateDataProto>
implements ApplicationStateData {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    YarnServerResourceManagerServiceProtos.ApplicationStateDataProto proto = YarnServerResourceManagerServiceProtos.ApplicationStateDataProto.getDefaultInstance();
    YarnServerResourceManagerServiceProtos.ApplicationStateDataProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationSubmissionContext applicationSubmissionContext = null;
    private static String RM_APP_PREFIX = "RMAPP_";

    public ApplicationStateDataPBImpl() {
        this.builder = YarnServerResourceManagerServiceProtos.ApplicationStateDataProto.newBuilder();
    }

    public ApplicationStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationStateDataProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerResourceManagerServiceProtos.ApplicationStateDataProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationSubmissionContext != null) {
            this.builder.setApplicationSubmissionContext(((ApplicationSubmissionContextPBImpl)this.applicationSubmissionContext).getProto());
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerResourceManagerServiceProtos.ApplicationStateDataProto.newBuilder((YarnServerResourceManagerServiceProtos.ApplicationStateDataProto)this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public long getSubmitTime() {
        YarnServerResourceManagerServiceProtos.ApplicationStateDataProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasSubmitTime()) {
            return -1L;
        }
        return p.getSubmitTime();
    }

    @Override
    public void setSubmitTime(long submitTime) {
        this.maybeInitBuilder();
        this.builder.setSubmitTime(submitTime);
    }

    @Override
    public long getStartTime() {
        YarnServerResourceManagerServiceProtos.ApplicationStateDataProto p = this.viaProto ? this.proto : this.builder;
        return p.getStartTime();
    }

    @Override
    public void setStartTime(long startTime) {
        this.maybeInitBuilder();
        this.builder.setStartTime(startTime);
    }

    @Override
    public String getUser() {
        YarnServerResourceManagerServiceProtos.ApplicationStateDataProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasUser()) {
            return null;
        }
        return p.getUser();
    }

    @Override
    public void setUser(String user) {
        this.maybeInitBuilder();
        this.builder.setUser(user);
    }

    @Override
    public ApplicationSubmissionContext getApplicationSubmissionContext() {
        YarnServerResourceManagerServiceProtos.ApplicationStateDataProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.applicationSubmissionContext != null) {
            return this.applicationSubmissionContext;
        }
        if (!p.hasApplicationSubmissionContext()) {
            return null;
        }
        this.applicationSubmissionContext = new ApplicationSubmissionContextPBImpl(p.getApplicationSubmissionContext());
        return this.applicationSubmissionContext;
    }

    @Override
    public void setApplicationSubmissionContext(ApplicationSubmissionContext context) {
        this.maybeInitBuilder();
        if (context == null) {
            this.builder.clearApplicationSubmissionContext();
        }
        this.applicationSubmissionContext = context;
    }

    @Override
    public RMAppState getState() {
        YarnServerResourceManagerServiceProtos.ApplicationStateDataProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationState()) {
            return null;
        }
        return ApplicationStateDataPBImpl.convertFromProtoFormat(p.getApplicationState());
    }

    @Override
    public void setState(RMAppState finalState) {
        this.maybeInitBuilder();
        if (finalState == null) {
            this.builder.clearApplicationState();
            return;
        }
        this.builder.setApplicationState(ApplicationStateDataPBImpl.convertToProtoFormat(finalState));
    }

    @Override
    public String getDiagnostics() {
        YarnServerResourceManagerServiceProtos.ApplicationStateDataProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDiagnostics()) {
            return null;
        }
        return p.getDiagnostics();
    }

    @Override
    public void setDiagnostics(String diagnostics) {
        this.maybeInitBuilder();
        if (diagnostics == null) {
            this.builder.clearDiagnostics();
            return;
        }
        this.builder.setDiagnostics(diagnostics);
    }

    @Override
    public long getFinishTime() {
        YarnServerResourceManagerServiceProtos.ApplicationStateDataProto p = this.viaProto ? this.proto : this.builder;
        return p.getFinishTime();
    }

    @Override
    public void setFinishTime(long finishTime) {
        this.maybeInitBuilder();
        this.builder.setFinishTime(finishTime);
    }

    public static ApplicationStateData newApplicationStateData(long submitTime, long startTime, String user, ApplicationSubmissionContext submissionContext, RMAppState state, String diagnostics, long finishTime) {
        ApplicationStateData appState = (ApplicationStateData)recordFactory.newRecordInstance(ApplicationStateData.class);
        appState.setSubmitTime(submitTime);
        appState.setStartTime(startTime);
        appState.setUser(user);
        appState.setApplicationSubmissionContext(submissionContext);
        appState.setState(state);
        appState.setDiagnostics(diagnostics);
        appState.setFinishTime(finishTime);
        return appState;
    }

    public static YarnServerResourceManagerServiceProtos.RMAppStateProto convertToProtoFormat(RMAppState e) {
        return YarnServerResourceManagerServiceProtos.RMAppStateProto.valueOf((String)(RM_APP_PREFIX + e.name()));
    }

    public static RMAppState convertFromProtoFormat(YarnServerResourceManagerServiceProtos.RMAppStateProto e) {
        return RMAppState.valueOf(e.name().replace(RM_APP_PREFIX, ""));
    }
}

