/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.RMStateVersionPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ZKRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(ZKRMStateStore.class);
    private final SecureRandom random = new SecureRandom();
    protected static final String ROOT_ZNODE_NAME = "ZKRMStateRoot";
    protected static final RMStateVersion CURRENT_VERSION_INFO = RMStateVersion.newInstance(1, 0);
    private static final String RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME = "RMDelegationTokensRoot";
    private static final String RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME = "RMDTSequentialNumber";
    private static final String RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME = "RMDTMasterKeysRoot";
    private int numRetries;
    private String zkHostPort = null;
    private int zkSessionTimeout;
    private long zkRetryInterval;
    private List<ACL> zkAcl;
    private String zkRootNodePath;
    private String rmAppRoot;
    private String rmDTSecretManagerRoot;
    private String dtMasterKeysRootPath;
    private String delegationTokensRootPath;
    private String dtSequenceNumberPath;
    @VisibleForTesting
    protected String znodeWorkingPath;
    @VisibleForTesting
    protected ZooKeeper zkClient;
    private ZooKeeper oldZkClient;
    private static final String FENCING_LOCK = "RM_ZK_FENCING_LOCK";
    private String fencingNodePath;
    private Op createFencingNodePathOp;
    private Op deleteFencingNodePathOp;
    private String zkRootNodeUsername;
    private final String zkRootNodePassword = Long.toString(this.random.nextLong());
    @VisibleForTesting
    List<ACL> zkRootNodeAcl;
    private boolean useDefaultFencingScheme = false;
    public static final int CREATE_DELETE_PERMS = 12;
    private final String zkRootNodeAuthScheme = new DigestAuthenticationProvider().getScheme();

    @VisibleForTesting
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected List<ACL> constructZkRootNodeACL(Configuration conf, List<ACL> sourceACLs) throws NoSuchAlgorithmException {
        ArrayList<ACL> zkRootNodeAcl = new ArrayList<ACL>();
        for (ACL acl : sourceACLs) {
            zkRootNodeAcl.add(new ACL(ZKUtil.removeSpecificPerms((int)acl.getPerms(), (int)12), acl.getId()));
        }
        this.zkRootNodeUsername = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.address", (String)"0.0.0.0:8032", (Configuration)conf);
        Id rmId = new Id(this.zkRootNodeAuthScheme, DigestAuthenticationProvider.generateDigest((String)(this.zkRootNodeUsername + ":" + this.zkRootNodePassword)));
        zkRootNodeAcl.add(new ACL(12, rmId));
        return zkRootNodeAcl;
    }

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.zkHostPort = conf.get("yarn.resourcemanager.zk-address");
        if (this.zkHostPort == null) {
            throw new YarnRuntimeException("No server address specified for zookeeper state store for Resource Manager recovery. yarn.resourcemanager.zk-address is not configured.");
        }
        this.numRetries = conf.getInt("yarn.resourcemanager.zk-num-retries", 500);
        this.znodeWorkingPath = conf.get("yarn.resourcemanager.zk-state-store.parent-path", "/rmstore");
        this.zkSessionTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        this.zkRetryInterval = conf.getLong("yarn.resourcemanager.zk-retry-interval-ms", 2000L);
        String zkAclConf = conf.get("yarn.resourcemanager.zk-acl", "world:anyone:rwcda");
        zkAclConf = ZKUtil.resolveConfIndirection((String)zkAclConf);
        try {
            this.zkAcl = ZKUtil.parseACLs((String)zkAclConf);
        }
        catch (ZKUtil.BadAclFormatException bafe) {
            LOG.error((Object)"Invalid format for yarn.resourcemanager.zk-acl");
            throw bafe;
        }
        this.zkRootNodePath = this.getNodePath(this.znodeWorkingPath, ROOT_ZNODE_NAME);
        this.rmAppRoot = this.getNodePath(this.zkRootNodePath, "RMAppRoot");
        this.fencingNodePath = this.getNodePath(this.zkRootNodePath, FENCING_LOCK);
        this.createFencingNodePathOp = Op.create((String)this.fencingNodePath, (byte[])new byte[0], this.zkAcl, (CreateMode)CreateMode.PERSISTENT);
        this.deleteFencingNodePathOp = Op.delete((String)this.fencingNodePath, (int)-1);
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            String zkRootNodeAclConf = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.zk-state-store.root-node.acl", (Configuration)conf);
            if (zkRootNodeAclConf != null) {
                zkRootNodeAclConf = ZKUtil.resolveConfIndirection((String)zkRootNodeAclConf);
                try {
                    this.zkRootNodeAcl = ZKUtil.parseACLs((String)zkRootNodeAclConf);
                }
                catch (ZKUtil.BadAclFormatException bafe) {
                    LOG.error((Object)"Invalid format for yarn.resourcemanager.zk-state-store.root-node.acl");
                    throw bafe;
                }
            } else {
                this.useDefaultFencingScheme = true;
                this.zkRootNodeAcl = this.constructZkRootNodeACL(conf, this.zkAcl);
            }
        }
        this.rmDTSecretManagerRoot = this.getNodePath(this.zkRootNodePath, "RMDTSecretManagerRoot");
        this.dtMasterKeysRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME);
        this.delegationTokensRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME);
        this.dtSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME);
    }

    @Override
    public synchronized void startInternal() throws Exception {
        this.createConnection();
        this.createRootDir(this.znodeWorkingPath);
        this.createRootDir(this.zkRootNodePath);
        if (HAUtil.isHAEnabled((Configuration)this.getConfig())) {
            this.fence();
        }
        this.createRootDir(this.rmAppRoot);
        this.createRootDir(this.rmDTSecretManagerRoot);
        this.createRootDir(this.dtMasterKeysRootPath);
        this.createRootDir(this.delegationTokensRootPath);
        this.createRootDir(this.dtSequenceNumberPath);
    }

    private void createRootDir(final String rootPath) throws Exception {
        try {
            new ZKAction<String>(){

                @Override
                public String run() throws KeeperException, InterruptedException {
                    return ZKRMStateStore.this.zkClient.create(rootPath, null, ZKRMStateStore.this.zkAcl, CreateMode.PERSISTENT);
                }
            }.runWithRetries();
        }
        catch (KeeperException ke) {
            if (ke.code() == KeeperException.Code.NODEEXISTS) {
                LOG.debug((Object)(rootPath + "znode already exists!"));
            }
            throw ke;
        }
    }

    private void logRootNodeAcls(String prefix) throws KeeperException, InterruptedException {
        Stat getStat = new Stat();
        List getAcls = this.zkClient.getACL(this.zkRootNodePath, getStat);
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        for (ACL acl : getAcls) {
            builder.append(acl.toString());
        }
        builder.append(getStat.toString());
        LOG.debug((Object)builder.toString());
    }

    private synchronized void fence() throws Exception {
        if (LOG.isTraceEnabled()) {
            this.logRootNodeAcls("Before fencing\n");
        }
        new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                ZKRMStateStore.this.zkClient.setACL(ZKRMStateStore.this.zkRootNodePath, ZKRMStateStore.this.zkRootNodeAcl, -1);
                return null;
            }
        }.runWithRetries();
        new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                try {
                    ZKRMStateStore.this.zkClient.multi(Collections.singletonList(ZKRMStateStore.this.deleteFencingNodePathOp));
                }
                catch (KeeperException.NoNodeException nne) {
                    LOG.info((Object)("Fencing node " + ZKRMStateStore.this.fencingNodePath + " doesn't exist to delete"));
                }
                return null;
            }
        }.runWithRetries();
        if (LOG.isTraceEnabled()) {
            this.logRootNodeAcls("After fencing\n");
        }
    }

    private synchronized void closeZkClients() throws IOException {
        if (this.zkClient != null) {
            try {
                this.zkClient.close();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing ZK", e);
            }
            this.zkClient = null;
        }
        if (this.oldZkClient != null) {
            try {
                this.oldZkClient.close();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing old ZK", e);
            }
            this.oldZkClient = null;
        }
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        this.closeZkClients();
    }

    @Override
    protected RMStateVersion getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        byte[] data = ((RMStateVersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.zkClient.exists(versionNodePath, true) != null) {
            this.setDataWithRetries(versionNodePath, data, -1);
        } else {
            this.createWithRetries(versionNodePath, data, this.zkAcl, CreateMode.PERSISTENT);
        }
    }

    @Override
    protected synchronized RMStateVersion loadVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        if (this.zkClient.exists(versionNodePath, true) != null) {
            byte[] data = this.getDataWithRetries(versionNodePath, true);
            RMStateVersionPBImpl version = new RMStateVersionPBImpl(YarnServerResourceManagerServiceProtos.RMStateVersionProto.parseFrom((byte[])data));
            return version;
        }
        return null;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        return rmState;
    }

    private synchronized void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        this.loadRMDelegationKeyState(rmState);
        this.loadRMSequentialNumberState(rmState);
        this.loadRMDelegationTokenState(rmState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDelegationKeyState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildrenWithRetries(this.dtMasterKeysRootPath, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.dtMasterKeysRootPath, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childData == null) {
                LOG.warn((Object)("Content of " + childNodePath + " is broken."));
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            try {
                if (!childNodeName.startsWith("DelegationKey_")) continue;
                DelegationKey key = new DelegationKey();
                key.readFields((DataInput)fsIn);
                rmState.rmSecretManagerState.masterKeyState.add(key);
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMSequentialNumberState(RMStateStore.RMState rmState) throws Exception {
        byte[] seqData = this.getDataWithRetries(this.dtSequenceNumberPath, false);
        if (seqData != null) {
            ByteArrayInputStream seqIs = new ByteArrayInputStream(seqData);
            DataInputStream seqIn = new DataInputStream(seqIs);
            try {
                rmState.rmSecretManagerState.dtSequenceNumber = seqIn.readInt();
            }
            finally {
                seqIn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDelegationTokenState(RMStateStore.RMState rmState) throws Exception {
        List childNodes = this.zkClient.getChildren(this.delegationTokensRootPath, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.delegationTokensRootPath, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childData == null) {
                LOG.warn((Object)("Content of " + childNodePath + " is broken."));
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            try {
                if (!childNodeName.startsWith("RMDelegationToken_")) continue;
                RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier();
                identifier.readFields((DataInput)fsIn);
                long renewDate = fsIn.readLong();
                rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
            }
            finally {
                is.close();
            }
        }
    }

    private synchronized void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildrenWithRetries(this.rmAppRoot, true);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.rmAppRoot, childNodeName);
            byte[] childData = this.getDataWithRetries(childNodePath, true);
            if (childNodeName.startsWith("application_")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading application from znode: " + childNodeName));
                }
                ApplicationId appId = ConverterUtils.toApplicationId((String)childNodeName);
                ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationStateDataProto.parseFrom((byte[])childData));
                RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getStartTime(), appStateData.getApplicationSubmissionContext(), appStateData.getUser(), appStateData.getState(), appStateData.getDiagnostics(), appStateData.getFinishTime());
                if (!appId.equals((Object)appState.context.getApplicationId())) {
                    throw new YarnRuntimeException("The child node name is different from the application id");
                }
                rmState.appState.put(appId, appState);
                this.loadApplicationAttemptState(appState, appId);
                continue;
            }
            LOG.info((Object)("Unknown child node with name: " + childNodeName));
        }
    }

    private void loadApplicationAttemptState(RMStateStore.ApplicationState appState, ApplicationId appId) throws Exception {
        String appPath = this.getNodePath(this.rmAppRoot, appId.toString());
        List<String> attempts = this.getChildrenWithRetries(appPath, false);
        for (String attemptIDStr : attempts) {
            if (!attemptIDStr.startsWith("appattempt_")) continue;
            String attemptPath = this.getNodePath(appPath, attemptIDStr);
            byte[] attemptData = this.getDataWithRetries(attemptPath, true);
            ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)attemptIDStr);
            ApplicationAttemptStateDataPBImpl attemptStateData = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerServiceProtos.ApplicationAttemptStateDataProto.parseFrom((byte[])attemptData));
            Credentials credentials = null;
            if (attemptStateData.getAppAttemptTokens() != null) {
                credentials = new Credentials();
                DataInputByteBuffer dibb = new DataInputByteBuffer();
                dibb.reset(new ByteBuffer[]{attemptStateData.getAppAttemptTokens()});
                credentials.readTokenStorageStream((DataInputStream)dibb);
            }
            RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(attemptId, attemptStateData.getMasterContainer(), credentials, attemptStateData.getStartTime(), attemptStateData.getState(), attemptStateData.getFinalTrackingUrl(), attemptStateData.getDiagnostics(), attemptStateData.getFinalApplicationStatus());
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        LOG.info((Object)"Done Loading applications from ZK state store");
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateDataPBImpl appStateDataPB) throws Exception {
        String nodeCreatePath = this.getNodePath(this.rmAppRoot, appId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing info for app: " + appId + " at: " + nodeCreatePath));
        }
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        this.createWithRetries(nodeCreatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT);
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateDataPBImpl appStateDataPB) throws Exception {
        String nodeUpdatePath = this.getNodePath(this.rmAppRoot, appId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing final state info for app: " + appId + " at: " + nodeUpdatePath));
        }
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        this.setDataWithRetries(nodeUpdatePath, appStateData, 0);
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateDataPBImpl attemptStateDataPB) throws Exception {
        String appDirPath = this.getNodePath(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        String nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        }
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        this.createWithRetries(nodeCreatePath, attemptStateData, this.zkAcl, CreateMode.PERSISTENT);
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateDataPBImpl attemptStateDataPB) throws Exception {
        String appIdStr = appAttemptId.getApplicationId().toString();
        String appAttemptIdStr = appAttemptId.toString();
        String appDirPath = this.getNodePath(this.rmAppRoot, appIdStr);
        String nodeUpdatePath = this.getNodePath(appDirPath, appAttemptIdStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing final state info for attempt: " + appAttemptIdStr + " at: " + nodeUpdatePath));
        }
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        this.setDataWithRetries(nodeUpdatePath, attemptStateData, 0);
    }

    @Override
    public synchronized void removeApplicationStateInternal(RMStateStore.ApplicationState appState) throws Exception {
        String appId = appState.getAppId().toString();
        String appIdRemovePath = this.getNodePath(this.rmAppRoot, appId);
        ArrayList<Op> opList = new ArrayList<Op>();
        for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
            String attemptRemovePath = this.getNodePath(appIdRemovePath, attemptId.toString());
            opList.add(Op.delete((String)attemptRemovePath, (int)-1));
        }
        opList.add(Op.delete((String)appIdRemovePath, (int)-1));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing info for app: " + appId + " at: " + appIdRemovePath + " and its attempts."));
        }
        this.doMultiWithRetries(opList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        ArrayList<Op> opList = new ArrayList<Op>();
        String nodeCreatePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        ByteArrayOutputStream tokenOs = new ByteArrayOutputStream();
        DataOutputStream tokenOut = new DataOutputStream(tokenOs);
        ByteArrayOutputStream seqOs = new ByteArrayOutputStream();
        DataOutputStream seqOut = new DataOutputStream(seqOs);
        try {
            rmDTIdentifier.write((DataOutput)tokenOut);
            tokenOut.writeLong(renewDate);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing RMDelegationToken_" + rmDTIdentifier.getSequenceNumber()));
            }
            opList.add(Op.create((String)nodeCreatePath, (byte[])tokenOs.toByteArray(), this.zkAcl, (CreateMode)CreateMode.PERSISTENT));
            seqOut.writeInt(latestSequenceNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing " + this.dtSequenceNumberPath + ". SequenceNumber: " + latestSequenceNumber));
            }
            opList.add(Op.setData((String)this.dtSequenceNumberPath, (byte[])seqOs.toByteArray(), (int)-1));
        }
        finally {
            tokenOs.close();
            seqOs.close();
        }
        this.doMultiWithRetries(opList);
    }

    @Override
    protected synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        String nodeRemovePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing RMDelegationToken_" + rmDTIdentifier.getSequenceNumber()));
        }
        this.deleteWithRetries(nodeRemovePath, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void storeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeCreatePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing RMDelegationKey_" + delegationKey.getKeyId()));
        }
        delegationKey.write((DataOutput)fsOut);
        try {
            this.createWithRetries(nodeCreatePath, os.toByteArray(), this.zkAcl, CreateMode.PERSISTENT);
        }
        finally {
            os.close();
        }
    }

    @Override
    protected synchronized void removeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeRemovePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing RMDelegationKey_" + delegationKey.getKeyId()));
        }
        this.deleteWithRetries(nodeRemovePath, -1);
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized void processWatchEvent(WatchedEvent event) throws Exception {
        Watcher.Event.EventType eventType = event.getType();
        LOG.info((Object)("Watcher event type: " + eventType + " with state:" + event.getState() + " for path:" + event.getPath() + " for " + (Object)((Object)this)));
        if (eventType == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case SyncConnected: {
                    LOG.info((Object)"ZKRMStateStore Session connected");
                    if (this.oldZkClient == null) break;
                    this.zkClient = this.oldZkClient;
                    this.oldZkClient = null;
                    ((Object)((Object)this)).notifyAll();
                    LOG.info((Object)"ZKRMStateStore Session restored");
                    break;
                }
                case Disconnected: {
                    LOG.info((Object)"ZKRMStateStore Session disconnected");
                    this.oldZkClient = this.zkClient;
                    this.zkClient = null;
                    break;
                }
                case Expired: {
                    LOG.info((Object)"Session expired");
                    this.createConnection();
                    break;
                }
                default: {
                    LOG.error((Object)("Unexpected Zookeeper watch event state: " + event.getState()));
                }
            }
        }
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    String getNodePath(String root, String nodeName) {
        return root + "/" + nodeName;
    }

    private synchronized void doMultiWithRetries(List<Op> opList) throws Exception {
        final ArrayList<Op> execOpList = new ArrayList<Op>(opList.size() + 2);
        execOpList.add(this.createFencingNodePathOp);
        execOpList.addAll(opList);
        execOpList.add(this.deleteFencingNodePathOp);
        new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                ZKRMStateStore.this.zkClient.multi((Iterable)execOpList);
                return null;
            }
        }.runWithRetries();
    }

    private void doMultiWithRetries(Op op) throws Exception {
        this.doMultiWithRetries(Collections.singletonList(op));
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void createWithRetries(String path, byte[] data, List<ACL> acl, CreateMode mode) throws Exception {
        this.doMultiWithRetries(Op.create((String)path, (byte[])data, acl, (CreateMode)mode));
    }

    private void deleteWithRetries(String path, int version) throws Exception {
        block2: {
            try {
                this.doMultiWithRetries(Op.delete((String)path, (int)version));
            }
            catch (KeeperException.NoNodeException nne) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)("Attempted to delete a non-existing znode " + path));
            }
        }
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void setDataWithRetries(String path, byte[] data, int version) throws Exception {
        this.doMultiWithRetries(Op.setData((String)path, (byte[])data, (int)version));
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public byte[] getDataWithRetries(final String path, final boolean watch) throws Exception {
        return (byte[])new ZKAction<byte[]>(){

            @Override
            public byte[] run() throws KeeperException, InterruptedException {
                return ZKRMStateStore.this.zkClient.getData(path, watch, null);
            }
        }.runWithRetries();
    }

    private List<String> getChildrenWithRetries(final String path, final boolean watch) throws Exception {
        return (List)new ZKAction<List<String>>(){

            @Override
            List<String> run() throws KeeperException, InterruptedException {
                return ZKRMStateStore.this.zkClient.getChildren(path, watch);
            }
        }.runWithRetries();
    }

    private synchronized void createConnection() throws IOException, InterruptedException {
        this.closeZkClients();
        for (int retries = 0; retries < this.numRetries && this.zkClient == null; ++retries) {
            try {
                this.zkClient = this.getNewZooKeeper();
                if (!this.useDefaultFencingScheme) continue;
                this.zkClient.addAuthInfo(this.zkRootNodeAuthScheme, (this.zkRootNodeUsername + ":" + this.zkRootNodePassword).getBytes());
                continue;
            }
            catch (IOException ioe) {
                LOG.info((Object)("Failed to connect to the ZooKeeper on attempt - " + (retries + 1)));
                ioe.printStackTrace();
            }
        }
        if (this.zkClient == null) {
            LOG.error((Object)"Unable to connect to Zookeeper");
            throw new YarnRuntimeException("Unable to connect to Zookeeper");
        }
        ((Object)((Object)this)).notifyAll();
        LOG.info((Object)"Created new ZK connection");
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected synchronized ZooKeeper getNewZooKeeper() throws IOException, InterruptedException {
        ZooKeeper zk = new ZooKeeper(this.zkHostPort, this.zkSessionTimeout, null);
        zk.register((Watcher)new ForwardingWatcher());
        return zk;
    }

    private abstract class ZKAction<T> {
        private ZKAction() {
        }

        abstract T run() throws KeeperException, InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T runWithCheck() throws Exception {
            long startTime = System.currentTimeMillis();
            ZKRMStateStore zKRMStateStore = ZKRMStateStore.this;
            synchronized (zKRMStateStore) {
                while (ZKRMStateStore.this.zkClient == null) {
                    ((Object)((Object)ZKRMStateStore.this)).wait(ZKRMStateStore.this.zkSessionTimeout);
                    if (ZKRMStateStore.this.zkClient != null) break;
                    if (System.currentTimeMillis() - startTime <= (long)ZKRMStateStore.this.zkSessionTimeout) continue;
                    throw new IOException("Wait for ZKClient creation timed out");
                }
                return this.run();
            }
        }

        private boolean shouldRetry(KeeperException.Code code) {
            switch (code) {
                case CONNECTIONLOSS: 
                case OPERATIONTIMEOUT: {
                    return true;
                }
            }
            return false;
        }

        T runWithRetries() throws Exception {
            int retry = 0;
            while (true) {
                try {
                    return this.runWithCheck();
                }
                catch (KeeperException.NoAuthException nae) {
                    if (!HAUtil.isHAEnabled((Configuration)ZKRMStateStore.this.getConfig())) continue;
                    throw new StoreFencedException();
                }
                catch (KeeperException ke) {
                    if (this.shouldRetry(ke.code()) && ++retry < ZKRMStateStore.this.numRetries) {
                        LOG.info((Object)("Waiting for zookeeper to be connected, retry no. + " + retry));
                        Thread.sleep(ZKRMStateStore.this.zkRetryInterval);
                        continue;
                    }
                    throw ke;
                }
                break;
            }
        }
    }

    private final class ForwardingWatcher
    implements Watcher {
        private ForwardingWatcher() {
        }

        public void process(WatchedEvent event) {
            try {
                ZKRMStateStore.this.processWatchEvent(event);
            }
            catch (Throwable t) {
                LOG.error((Object)("Failed to process watcher event " + event + ": " + StringUtils.stringifyException((Throwable)t)));
            }
        }
    }
}

