/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;

@XmlRootElement(name="app")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppInfo {
    @XmlTransient
    protected String appIdNum;
    @XmlTransient
    protected boolean trackingUrlIsNotReady;
    @XmlTransient
    protected String trackingUrlPretty;
    @XmlTransient
    protected boolean amContainerLogsExist = false;
    @XmlTransient
    protected ApplicationId applicationId;
    protected String id;
    protected String user;
    protected String name;
    protected String queue;
    protected RMAppState state;
    protected FinalApplicationStatus finalStatus;
    protected float progress;
    protected String trackingUI;
    protected String trackingUrl;
    protected String diagnostics;
    protected long clusterId;
    protected long startedTime;
    protected long finishedTime;
    protected long elapsedTime;
    protected String amContainerLogs;
    protected String amHostHttpAddress;

    public AppInfo() {
    }

    public AppInfo(RMApp app, Boolean hasAccess, String host) {
        this(app, hasAccess);
    }

    public AppInfo(RMApp app, Boolean hasAccess) {
        if (app != null) {
            String trackingUrl = app.getTrackingUrl();
            this.state = app.getState();
            boolean bl = this.trackingUrlIsNotReady = trackingUrl == null || trackingUrl.isEmpty() || RMAppState.NEW == this.state || RMAppState.SUBMITTED == this.state || RMAppState.ACCEPTED == this.state;
            String string = this.trackingUrlIsNotReady ? "UNASSIGNED" : (this.trackingUI = app.getFinishTime() == 0L ? "ApplicationMaster" : "History");
            if (!this.trackingUrlIsNotReady) {
                this.trackingUrl = StringHelper.join((Object[])new Object[]{"http://", trackingUrl});
            }
            this.trackingUrlPretty = this.trackingUrlIsNotReady ? "UNASSIGNED" : StringHelper.join((Object[])new Object[]{"http://", trackingUrl});
            this.applicationId = app.getApplicationId();
            this.appIdNum = String.valueOf(app.getApplicationId().getId());
            this.id = app.getApplicationId().toString();
            this.user = app.getUser().toString();
            this.name = app.getName().toString();
            this.queue = app.getQueue().toString();
            this.progress = app.getProgress() * 100.0f;
            this.diagnostics = app.getDiagnostics().toString();
            if (this.diagnostics == null || this.diagnostics.isEmpty()) {
                this.diagnostics = "";
            }
            this.finalStatus = app.getFinalApplicationStatus();
            this.clusterId = ResourceManager.clusterTimeStamp;
            if (hasAccess.booleanValue()) {
                Container masterContainer;
                this.startedTime = app.getStartTime();
                this.finishedTime = app.getFinishTime();
                this.elapsedTime = Times.elapsed((long)app.getStartTime(), (long)app.getFinishTime());
                RMAppAttempt attempt = app.getCurrentAppAttempt();
                if (attempt != null && (masterContainer = attempt.getMasterContainer()) != null) {
                    String url;
                    this.amContainerLogsExist = true;
                    this.amContainerLogs = url = StringHelper.join((Object[])new Object[]{"http://", masterContainer.getNodeHttpAddress(), "/node", "/containerlogs/", ConverterUtils.toString((ContainerId)masterContainer.getId()), "/", app.getUser()});
                    this.amHostHttpAddress = masterContainer.getNodeHttpAddress();
                }
            }
        }
    }

    public boolean isTrackingUrlReady() {
        return !this.trackingUrlIsNotReady;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public String getAppId() {
        return this.id;
    }

    public String getAppIdNum() {
        return this.appIdNum;
    }

    public String getUser() {
        return this.user;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state.toString();
    }

    public float getProgress() {
        return this.progress;
    }

    public String getTrackingUI() {
        return this.trackingUI;
    }

    public String getNote() {
        return this.diagnostics;
    }

    public String getFinalStatus() {
        return this.finalStatus.toString();
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getTrackingUrlPretty() {
        return this.trackingUrlPretty;
    }

    public long getStartTime() {
        return this.startedTime;
    }

    public long getFinishTime() {
        return this.finishedTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getAMContainerLogs() {
        return this.amContainerLogs;
    }

    public String getAMHostHttpAddress() {
        return this.amHostHttpAddress;
    }

    public boolean amContainerLogsExist() {
        return this.amContainerLogsExist;
    }

    public long getClusterId() {
        return this.clusterId;
    }
}

