/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

class NodesPage
extends RmView {
    NodesPage() {
    }

    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        String type = this.$("node.state");
        String title = "Nodes of the cluster";
        if (type != null && !type.isEmpty()) {
            title = title + " (" + type + ")";
        }
        this.setTitle(title);
        this.set("ui.dataTables.id", "nodes");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"nodes"), this.nodesTableInit());
        this.setTableStyles(html, "nodes", new String[]{".healthStatus {width:10em}", ".healthReport {width:10em}"});
    }

    @Override
    protected Class<? extends SubView> content() {
        return NodesBlock.class;
    }

    private String nodesTableInit() {
        StringBuilder b = JQueryUI.tableInit().append(", aoColumnDefs: [");
        b.append("{'bSearchable': false, 'aTargets': [ 7 ]}");
        b.append(", {'sType': 'title-numeric', 'bSearchable': false, 'aTargets': [ 8, 9 ] }");
        b.append(", {'sType': 'title-numeric', 'aTargets': [ 5 ]}");
        b.append("]}");
        return b.toString();
    }

    static class NodesBlock
    extends HtmlBlock {
        final RMContext rmContext;
        final ResourceManager rm;
        private static final long BYTES_IN_MB = 0x100000L;

        @Inject
        NodesBlock(RMContext context, ResourceManager rm, View.ViewContext ctx) {
            super(ctx);
            this.rmContext = context;
            this.rm = rm;
        }

        protected void render(HtmlBlock.Block html) {
            html._(MetricsOverviewTable.class);
            ResourceScheduler sched = this.rm.getResourceScheduler();
            String type = this.$("node.state");
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#nodes").thead().tr().th(".rack", "Rack").th(".state", "Node State").th(".nodeaddress", "Node Address").th(".nodehttpaddress", "Node HTTP Address").th(".healthStatus", "Health-status").th(".lastHealthUpdate", "Last health-update").th(".healthReport", "Health-report").th(".containers", "Containers").th(".mem", "Mem Used").th(".mem", "Mem Avail")._())._()).tbody();
            RMNodeState stateFilter = null;
            if (type != null && !type.isEmpty()) {
                stateFilter = RMNodeState.valueOf(type.toUpperCase());
            }
            Collection rmNodes = this.rmContext.getRMNodes().values();
            boolean isInactive = false;
            if (stateFilter != null) {
                switch (stateFilter) {
                    case DECOMMISSIONED: 
                    case LOST: 
                    case REBOOTED: {
                        rmNodes = this.rmContext.getInactiveRMNodes().values();
                        isInactive = true;
                    }
                }
            }
            for (RMNode ni : rmNodes) {
                RMNodeState state;
                if (stateFilter != null ? !stateFilter.equals((Object)(state = ni.getState())) : ni.getState() == RMNodeState.UNHEALTHY) continue;
                NodeInfo info = new NodeInfo(ni, sched);
                int usedMemory = (int)info.getUsedMemory();
                int availableMemory = (int)info.getAvailableMemory();
                Hamlet.TR row = tbody.tr().td(info.getRack()).td(info.getState()).td(info.getNodeId());
                if (isInactive) {
                    row.td()._(new Object[]{"N/A"})._();
                } else {
                    String httpAddress = info.getNodeHTTPAddress();
                    row.td().a("http://" + httpAddress, httpAddress)._();
                }
                ((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)row.td(info.getHealthStatus()).td().br().$title(String.valueOf(info.getLastHealthUpdate()))._())._(new Object[]{Times.format((long)info.getLastHealthUpdate())})._()).td(info.getHealthReport()).td(String.valueOf(info.getNumContainers())).td().br().$title(String.valueOf(usedMemory))._())._(new Object[]{StringUtils.byteDesc((long)((long)usedMemory * 0x100000L))})._()).td().br().$title(String.valueOf(usedMemory))._())._(new Object[]{StringUtils.byteDesc((long)((long)availableMemory * 0x100000L))})._())._();
            }
            ((Hamlet.TABLE)tbody._())._();
        }
    }
}

