/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AppBlock
extends HtmlBlock {
    private ApplicationACLsManager aclsManager;

    @Inject
    AppBlock(ResourceManager rm, View.ViewContext ctx, ApplicationACLsManager aclsManager) {
        super(ctx);
        this.aclsManager = aclsManager;
    }

    protected void render(HtmlBlock.Block html) {
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires application ID"});
            return;
        }
        ApplicationId appID = null;
        try {
            appID = Apps.toAppID((String)aid);
        }
        catch (Exception e) {
            this.puts(new Object[]{"Invalid Application ID: " + aid});
            return;
        }
        RMContext context = (RMContext)this.getInstance(RMContext.class);
        RMApp rmApp = (RMApp)context.getRMApps().get(appID);
        if (rmApp == null) {
            this.puts(new Object[]{"Application not found: " + aid});
            return;
        }
        AppInfo app = new AppInfo(rmApp, true);
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        if (callerUGI != null && !this.aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, app.getUser(), appID)) {
            this.puts(new Object[]{"You (User " + remoteUser + ") are not authorized to view application " + appID});
            return;
        }
        this.setTitle(StringHelper.join((Object[])new Object[]{"Application ", aid}));
        this.info("Application Overview")._("User:", (Object)app.getUser())._("Name:", (Object)app.getName())._("State:", (Object)app.getState())._("FinalStatus:", (Object)app.getFinalStatus())._("Started:", (Object)Times.format((long)app.getStartTime()))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)app.getStartTime(), (long)app.getFinishTime())))._("Tracking URL:", !app.isTrackingUrlReady() ? "#" : app.getTrackingUrlPretty(), (Object)app.getTrackingUI())._("Diagnostics:", (Object)app.getNote());
        Collection<RMAppAttempt> attempts = rmApp.getAppAttempts().values();
        String amString = attempts.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        Hamlet.DIV div = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.table("#app");
        ((Hamlet.TABLE)table.tr().th(amString)._()).tr().th(".ui-state-default", "Attempt Number").th(".ui-state-default", "Start Time").th(".ui-state-default", "Node").th(".ui-state-default", "Logs")._();
        boolean odd = false;
        for (RMAppAttempt attempt : attempts) {
            AppAttemptInfo attemptInfo = new AppAttemptInfo(attempt);
            odd = !odd;
            ((Hamlet.TR)((Hamlet.TR)table.tr(odd ? ".odd" : ".even").td(String.valueOf(attemptInfo.getAttemptId())).td(Times.format((long)attemptInfo.getStartTime())).td().a(".nodelink", this.url(new String[]{"http://", attemptInfo.getNodeHttpAddress()}), attemptInfo.getNodeHttpAddress())._()).td().a(".logslink", this.url(new String[]{attemptInfo.getLogsLink()}), "logs")._())._();
        }
        table._();
        div._();
    }
}

