/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.service.AbstractService;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegationTokenRenewer
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(DelegationTokenRenewer.class);
    public static final String SCHEME = "hdfs";
    private Timer renewalTimer;
    private DelegationTokenCancelThread dtCancelThread = new DelegationTokenCancelThread();
    private Set<DelegationTokenToRenew> delegationTokens = Collections.synchronizedSet(new HashSet());
    private final ConcurrentMap<ApplicationId, Long> delayedRemovalMap = new ConcurrentHashMap<ApplicationId, Long>();
    private long tokenRemovalDelayMs;
    private Thread delayedRemovalThread;
    private boolean tokenKeepAliveEnabled;

    public DelegationTokenRenewer() {
        super(DelegationTokenRenewer.class.getName());
    }

    public synchronized void init(Configuration conf) {
        super.init(conf);
        this.tokenKeepAliveEnabled = conf.getBoolean("yarn.log-aggregation-enable", false);
        this.tokenRemovalDelayMs = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
    }

    public synchronized void start() {
        super.start();
        this.dtCancelThread.start();
        this.renewalTimer = new Timer(true);
        if (this.tokenKeepAliveEnabled) {
            this.delayedRemovalThread = new Thread((Runnable)new DelayedTokenRemovalRunnable(this.getConfig()), "DelayedTokenCanceller");
            this.delayedRemovalThread.start();
        }
    }

    public synchronized void stop() {
        this.renewalTimer.cancel();
        this.delegationTokens.clear();
        this.dtCancelThread.interrupt();
        try {
            this.dtCancelThread.join(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.tokenKeepAliveEnabled && this.delayedRemovalThread != null) {
            this.delayedRemovalThread.interrupt();
            try {
                this.delayedRemovalThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted while joining on delayed removal thread.", (Throwable)e);
            }
        }
        super.stop();
    }

    private void addTokenToList(DelegationTokenToRenew t) {
        this.delegationTokens.add(t);
    }

    public synchronized void addApplication(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd) throws IOException {
        if (ts == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering tokens for renewal for: appId = " + applicationId));
        }
        Collection tokens = ts.getAllTokens();
        long now = System.currentTimeMillis();
        for (Token token : tokens) {
            if (!token.isManaged()) continue;
            DelegationTokenToRenew dtr = new DelegationTokenToRenew(applicationId, token, this.getConfig(), now, shouldCancelAtEnd);
            this.addTokenToList(dtr);
            this.setTimerForTokenRenewal(dtr, true);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Registering token for renewal for: service = " + token.getService() + " for appId = " + applicationId));
        }
    }

    private void setTimerForTokenRenewal(DelegationTokenToRenew token, boolean firstTime) throws IOException {
        long renewIn;
        long now = System.currentTimeMillis();
        if (firstTime) {
            renewIn = now;
        } else {
            long expiresIn = token.expirationDate - now;
            renewIn = now + expiresIn - expiresIn / 10L;
        }
        RenewalTimerTask tTask = new RenewalTimerTask(token);
        token.setTimerTask(tTask);
        this.renewalTimer.schedule(token.timerTask, new Date(renewIn));
    }

    private void cancelToken(DelegationTokenToRenew t) {
        if (t.shouldCancelAtEnd) {
            this.dtCancelThread.cancelToken(t.token, t.conf);
        } else {
            LOG.info((Object)("Did not cancel " + t));
        }
    }

    private void removeFailedDelegationToken(DelegationTokenToRenew t) {
        ApplicationId applicationId = t.applicationId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing failed delegation token for appid=" + applicationId + ";t=" + t.token.getService()));
        }
        this.delegationTokens.remove(t);
        if (t.timerTask != null) {
            t.timerTask.cancel();
        }
    }

    public void applicationFinished(ApplicationId applicationId) {
        if (!this.tokenKeepAliveEnabled) {
            this.removeApplicationFromRenewal(applicationId);
        } else {
            this.delayedRemovalMap.put(applicationId, System.currentTimeMillis() + this.tokenRemovalDelayMs);
        }
    }

    public void updateKeepAliveApplications(List<ApplicationId> appIds) {
        if (this.tokenKeepAliveEnabled && appIds != null && appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                this.delayedRemovalMap.put(appId, System.currentTimeMillis() + this.tokenRemovalDelayMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplicationFromRenewal(ApplicationId applicationId) {
        Set<DelegationTokenToRenew> set = this.delegationTokens;
        synchronized (set) {
            Iterator<DelegationTokenToRenew> it = this.delegationTokens.iterator();
            while (it.hasNext()) {
                DelegationTokenToRenew dttr = it.next();
                if (!dttr.applicationId.equals((Object)applicationId)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing delegation token for appId=" + applicationId + "; token=" + dttr.token.getService()));
                }
                if (dttr.timerTask != null) {
                    dttr.timerTask.cancel();
                }
                this.cancelToken(dttr);
                it.remove();
            }
        }
    }

    private class DelayedTokenRemovalRunnable
    implements Runnable {
        private long waitTimeMs;

        DelayedTokenRemovalRunnable(Configuration conf) {
            this.waitTimeMs = conf.getLong("yarn.resourcemanager.delayed.delegation-token.removal-interval-ms", 30000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList toCancel = new ArrayList();
            while (!Thread.currentThread().isInterrupted()) {
                Iterator it = DelegationTokenRenewer.this.delayedRemovalMap.entrySet().iterator();
                toCancel.clear();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    if ((Long)e.getValue() >= System.currentTimeMillis()) continue;
                    toCancel.add(e.getKey());
                }
                for (ApplicationId appId : toCancel) {
                    DelegationTokenRenewer.this.removeApplicationFromRenewal(appId);
                    DelegationTokenRenewer.this.delayedRemovalMap.remove(appId);
                }
                DelayedTokenRemovalRunnable delayedTokenRemovalRunnable = this;
                synchronized (delayedTokenRemovalRunnable) {
                    try {
                        this.wait(this.waitTimeMs);
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"Delayed Deletion Thread Interrupted. Shutting it down");
                        return;
                    }
                }
            }
        }
    }

    private class RenewalTimerTask
    extends TimerTask {
        private DelegationTokenToRenew dttr;

        RenewalTimerTask(DelegationTokenToRenew t) {
            this.dttr = t;
        }

        @Override
        public void run() {
            Token<?> token = this.dttr.token;
            try {
                this.dttr.expirationDate = (Long)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

                    @Override
                    public Long run() throws Exception {
                        return ((RenewalTimerTask)RenewalTimerTask.this).dttr.token.renew(((RenewalTimerTask)RenewalTimerTask.this).dttr.conf);
                    }
                });
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Renewing delegation-token for:" + token.getService() + "; new expiration;" + this.dttr.expirationDate));
                }
                DelegationTokenRenewer.this.setTimerForTokenRenewal(this.dttr, false);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception renewing token" + token + ". Not rescheduled"), (Throwable)e);
                DelegationTokenRenewer.this.removeFailedDelegationToken(this.dttr);
            }
        }
    }

    private static class DelegationTokenCancelThread
    extends Thread {
        private LinkedBlockingQueue<TokenWithConf> queue = new LinkedBlockingQueue();

        public DelegationTokenCancelThread() {
            super("Delegation Token Canceler");
            this.setDaemon(true);
        }

        public void cancelToken(Token<?> token, Configuration conf) {
            TokenWithConf tokenWithConf = new TokenWithConf(token, conf);
            while (!this.queue.offer(tokenWithConf)) {
                LOG.warn((Object)("Unable to add token " + token + " for cancellation. " + "Will retry.."));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void run() {
            TokenWithConf tokenWithConf = null;
            while (true) {
                try {
                    while (true) {
                        final TokenWithConf current = tokenWithConf = this.queue.take();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Canceling token " + tokenWithConf.token.getService()));
                        }
                        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                current.token.cancel(current.conf);
                                return null;
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to cancel token " + tokenWithConf.token + " " + StringUtils.stringifyException((Throwable)e)));
                    continue;
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Got exception " + StringUtils.stringifyException((Throwable)t) + ". Exiting.."));
                    System.exit(-1);
                    continue;
                }
                break;
            }
        }

        private static class TokenWithConf {
            Token<?> token;
            Configuration conf;

            TokenWithConf(Token<?> token, Configuration conf) {
                this.token = token;
                this.conf = conf;
            }
        }
    }

    private static class DelegationTokenToRenew {
        public final Token<?> token;
        public final ApplicationId applicationId;
        public final Configuration conf;
        public long expirationDate;
        public TimerTask timerTask;
        public final boolean shouldCancelAtEnd;

        public DelegationTokenToRenew(ApplicationId jId, Token<?> token, Configuration conf, long expirationDate, boolean shouldCancelAtEnd) {
            this.token = token;
            this.applicationId = jId;
            this.conf = conf;
            this.expirationDate = expirationDate;
            this.timerTask = null;
            this.shouldCancelAtEnd = shouldCancelAtEnd;
            if (this.token == null || this.applicationId == null || this.conf == null) {
                throw new IllegalArgumentException("Invalid params to renew token;token=" + this.token + ";appId=" + this.applicationId + ";conf=" + this.conf);
            }
        }

        public void setTimerTask(TimerTask tTask) {
            this.timerTask = tTask;
        }

        public String toString() {
            return this.token + ";exp=" + this.expirationDate;
        }

        public boolean equals(Object obj) {
            return obj instanceof DelegationTokenToRenew && this.token.equals(((DelegationTokenToRenew)obj).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }
    }
}

