/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.Lock;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.BuilderUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LeafQueue
implements CSQueue {
    private static final Log LOG = LogFactory.getLog(LeafQueue.class);
    private final String queueName;
    private CSQueue parent;
    private float capacity;
    private float absoluteCapacity;
    private float maximumCapacity;
    private float absoluteMaxCapacity;
    private float absoluteUsedCapacity = 0.0f;
    private int userLimit;
    private float userLimitFactor;
    private int maxApplications;
    private int maxApplicationsPerUser;
    private float maxAMResourcePerQueuePercent;
    private int maxActiveApplications;
    private int maxActiveAppsUsingAbsCap;
    private int maxActiveApplicationsPerUser;
    private org.apache.hadoop.yarn.api.records.Resource usedResources = Resources.createResource(0);
    private float usedCapacity = 0.0f;
    private volatile int numContainers;
    Set<SchedulerApp> activeApplications;
    Map<ApplicationAttemptId, SchedulerApp> applicationsMap = new HashMap<ApplicationAttemptId, SchedulerApp>();
    Set<SchedulerApp> pendingApplications;
    private final org.apache.hadoop.yarn.api.records.Resource minimumAllocation;
    private final org.apache.hadoop.yarn.api.records.Resource maximumAllocation;
    private final float minimumAllocationFactor;
    private RMContainerTokenSecretManager containerTokenSecretManager;
    private Map<String, User> users = new HashMap<String, User>();
    private final QueueMetrics metrics;
    private QueueInfo queueInfo;
    private QueueState state;
    private Map<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private CapacitySchedulerContext scheduler;
    private final ActiveUsersManager activeUsersManager;
    private static final CSAssignment NULL_ASSIGNMENT = new CSAssignment(Resources.createResource(0), NodeType.NODE_LOCAL);

    public LeafQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, Comparator<SchedulerApp> applicationComparator, CSQueue old) {
        this.scheduler = cs;
        this.queueName = queueName;
        this.parent = parent;
        this.metrics = old != null ? old.getMetrics() : QueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics(), cs.getConf());
        this.activeUsersManager = new ActiveUsersManager(this.metrics);
        this.minimumAllocation = cs.getMinimumResourceCapability();
        this.maximumAllocation = cs.getMaximumResourceCapability();
        this.minimumAllocationFactor = (float)(this.maximumAllocation.getMemory() - this.minimumAllocation.getMemory()) / (float)this.maximumAllocation.getMemory();
        this.containerTokenSecretManager = cs.getContainerTokenSecretManager();
        float capacity = cs.getConfiguration().getCapacity(this.getQueuePath()) / 100.0f;
        float absoluteCapacity = parent.getAbsoluteCapacity() * capacity;
        float maximumCapacity = cs.getConfiguration().getMaximumCapacity(this.getQueuePath()) / 100.0f;
        float absoluteMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, parent);
        int userLimit = cs.getConfiguration().getUserLimit(this.getQueuePath());
        float userLimitFactor = cs.getConfiguration().getUserLimitFactor(this.getQueuePath());
        int maxApplications = cs.getConfiguration().getMaximumApplicationsPerQueue(this.getQueuePath());
        if (maxApplications < 0) {
            int maxSystemApps = cs.getConfiguration().getMaximumSystemApplications();
            maxApplications = (int)((float)maxSystemApps * absoluteCapacity);
        }
        this.maxApplicationsPerUser = (int)((float)maxApplications * ((float)userLimit / 100.0f) * userLimitFactor);
        this.maxAMResourcePerQueuePercent = cs.getConfiguration().getMaximumApplicationMasterResourcePerQueuePercent(this.getQueuePath());
        int maxActiveApplications = CSQueueUtils.computeMaxActiveApplications(cs.getClusterResources(), this.minimumAllocation, this.maxAMResourcePerQueuePercent, absoluteMaxCapacity);
        this.maxActiveAppsUsingAbsCap = CSQueueUtils.computeMaxActiveApplications(cs.getClusterResources(), this.minimumAllocation, this.maxAMResourcePerQueuePercent, absoluteCapacity);
        int maxActiveApplicationsPerUser = CSQueueUtils.computeMaxActiveApplicationsPerUser(this.maxActiveAppsUsingAbsCap, userLimit, userLimitFactor);
        this.queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        this.queueInfo.setQueueName(queueName);
        this.queueInfo.setChildQueues(new ArrayList());
        QueueState state = cs.getConfiguration().getState(this.getQueuePath());
        Map<QueueACL, AccessControlList> acls = cs.getConfiguration().getAcls(this.getQueuePath());
        this.setupQueueConfigs(cs.getClusterResources(), capacity, absoluteCapacity, maximumCapacity, absoluteMaxCapacity, userLimit, userLimitFactor, maxApplications, this.maxApplicationsPerUser, maxActiveApplications, maxActiveApplicationsPerUser, state, acls);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LeafQueue: name=" + queueName + ", fullname=" + this.getQueuePath()));
        }
        this.pendingApplications = new TreeSet<SchedulerApp>(applicationComparator);
        this.activeApplications = new TreeSet<SchedulerApp>(applicationComparator);
    }

    private synchronized void setupQueueConfigs(org.apache.hadoop.yarn.api.records.Resource clusterResource, float capacity, float absoluteCapacity, float maximumCapacity, float absoluteMaxCapacity, int userLimit, float userLimitFactor, int maxApplications, int maxApplicationsPerUser, int maxActiveApplications, int maxActiveApplicationsPerUser, QueueState state, Map<QueueACL, AccessControlList> acls) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), capacity, maximumCapacity);
        float absCapacity = this.getParent().getAbsoluteCapacity() * capacity;
        CSQueueUtils.checkAbsoluteCapacities(this.getQueueName(), absCapacity, absoluteMaxCapacity);
        this.capacity = capacity;
        this.absoluteCapacity = absCapacity;
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absoluteMaxCapacity;
        this.userLimit = userLimit;
        this.userLimitFactor = userLimitFactor;
        this.maxApplications = maxApplications;
        this.maxApplicationsPerUser = maxApplicationsPerUser;
        this.maxActiveApplications = maxActiveApplications;
        this.maxActiveApplicationsPerUser = maxActiveApplicationsPerUser;
        this.state = state;
        this.acls = acls;
        this.queueInfo.setCapacity(this.capacity);
        this.queueInfo.setMaximumCapacity(this.maximumCapacity);
        this.queueInfo.setQueueState(this.state);
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            aclsString.append(e.getKey() + ":" + e.getValue().getAclString());
        }
        CSQueueUtils.updateQueueStatistics(this, this.getParent(), clusterResource, this.minimumAllocation);
        LOG.info((Object)("Initializing " + this.queueName + "\n" + "capacity = " + capacity + " [= (float) configuredCapacity / 100 ]" + "\n" + "asboluteCapacity = " + absoluteCapacity + " [= parentAbsoluteCapacity * capacity ]" + "\n" + "maxCapacity = " + maximumCapacity + " [= configuredMaxCapacity ]" + "\n" + "absoluteMaxCapacity = " + absoluteMaxCapacity + " [= 1.0 maximumCapacity undefined, " + "(parentAbsoluteMaxCapacity * maximumCapacity) / 100 otherwise ]" + "\n" + "userLimit = " + userLimit + " [= configuredUserLimit ]" + "\n" + "userLimitFactor = " + userLimitFactor + " [= configuredUserLimitFactor ]" + "\n" + "maxApplications = " + maxApplications + " [= configuredMaximumSystemApplicationsPerQueue or" + " (int)(configuredMaximumSystemApplications * absoluteCapacity)]" + "\n" + "maxApplicationsPerUser = " + maxApplicationsPerUser + " [= (int)(maxApplications * (userLimit / 100.0f) * " + "userLimitFactor) ]" + "\n" + "maxActiveApplications = " + maxActiveApplications + " [= max(" + "(int)ceil((clusterResourceMemory / minimumAllocation) * " + "maxAMResourcePerQueuePercent * absoluteMaxCapacity)," + "1) ]" + "\n" + "maxActiveAppsUsingAbsCap = " + this.maxActiveAppsUsingAbsCap + " [= max(" + "(int)ceil((clusterResourceMemory / minimumAllocation) *" + "maxAMResourcePercent * absoluteCapacity)," + "1) ]" + "\n" + "maxActiveApplicationsPerUser = " + maxActiveApplicationsPerUser + " [= max(" + "(int)(maxActiveApplications * (userLimit / 100.0f) * " + "userLimitFactor)," + "1) ]" + "\n" + "usedCapacity = " + this.usedCapacity + " [= usedResourcesMemory / " + "(clusterResourceMemory * absoluteCapacity)]" + "\n" + "absoluteUsedCapacity = " + this.absoluteUsedCapacity + " [= usedResourcesMemory / clusterResourceMemory]" + "\n" + "maxAMResourcePerQueuePercent = " + this.maxAMResourcePerQueuePercent + " [= configuredMaximumAMResourcePercent ]" + "\n" + "minimumAllocationFactor = " + this.minimumAllocationFactor + " [= (float)(maximumAllocationMemory - minimumAllocationMemory) / " + "maximumAllocationMemory ]" + "\n" + "numContainers = " + this.numContainers + " [= currentNumContainers ]" + "\n" + "state = " + state + " [= configuredState ]" + "\n" + "acls = " + aclsString + " [= configuredAcls ]" + "\n"));
    }

    @Override
    public synchronized float getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    @Override
    public synchronized float getMaximumCapacity() {
        return this.maximumCapacity;
    }

    @Override
    public synchronized float getAbsoluteMaximumCapacity() {
        return this.absoluteMaxCapacity;
    }

    @Override
    public synchronized float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity;
    }

    @Override
    public synchronized CSQueue getParent() {
        return this.parent;
    }

    @Override
    public synchronized void setParent(CSQueue newParentQueue) {
        this.parent = (ParentQueue)newParentQueue;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getQueuePath() {
        return this.getParent().getQueuePath() + "." + this.getQueueName();
    }

    @InterfaceAudience.Private
    public org.apache.hadoop.yarn.api.records.Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    @InterfaceAudience.Private
    public org.apache.hadoop.yarn.api.records.Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }

    @InterfaceAudience.Private
    public float getMinimumAllocationFactor() {
        return this.minimumAllocationFactor;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public synchronized int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    public synchronized int getMaximumActiveApplications() {
        return this.maxActiveApplications;
    }

    public synchronized int getMaximumActiveApplicationsPerUser() {
        return this.maxActiveApplicationsPerUser;
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return this.activeUsersManager;
    }

    @Override
    public synchronized float getUsedCapacity() {
        return this.usedCapacity;
    }

    @Override
    public synchronized org.apache.hadoop.yarn.api.records.Resource getUsedResources() {
        return this.usedResources;
    }

    @Override
    public List<CSQueue> getChildQueues() {
        return null;
    }

    @Override
    public synchronized void setUsedCapacity(float usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    @Override
    public synchronized void setAbsoluteUsedCapacity(float absUsedCapacity) {
        this.absoluteUsedCapacity = absUsedCapacity;
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), this.capacity, maximumCapacity);
        float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.getParent());
        CSQueueUtils.checkAbsoluteCapacities(this.getQueueName(), this.absoluteCapacity, absMaxCapacity);
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absMaxCapacity;
    }

    synchronized void setUserLimit(int userLimit) {
        this.userLimit = userLimit;
    }

    synchronized void setUserLimitFactor(int userLimitFactor) {
        this.userLimitFactor = userLimitFactor;
    }

    @Override
    public synchronized int getNumApplications() {
        return this.getNumPendingApplications() + this.getNumActiveApplications();
    }

    public synchronized int getNumPendingApplications() {
        return this.pendingApplications.size();
    }

    public synchronized int getNumActiveApplications() {
        return this.activeApplications.size();
    }

    @InterfaceAudience.Private
    public synchronized int getNumApplications(String user) {
        return this.getUser(user).getTotalApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumPendingApplications(String user) {
        return this.getUser(user).getPendingApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumActiveApplications(String user) {
        return this.getUser(user).getActiveApplications();
    }

    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @InterfaceAudience.Private
    public synchronized int getUserLimit() {
        return this.userLimit;
    }

    @InterfaceAudience.Private
    public synchronized float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    @Override
    public synchronized Map<QueueACL, AccessControlList> getQueueAcls() {
        return new HashMap<QueueACL, AccessControlList>(this.acls);
    }

    @Override
    public synchronized QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        this.queueInfo.setCurrentCapacity(this.usedCapacity);
        return this.queueInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    public String toString() {
        return this.queueName + ": " + "capacity=" + this.capacity + ", " + "absoluteCapacity=" + this.absoluteCapacity + ", " + "usedResources=" + this.usedResources.getMemory() + "MB, " + "usedCapacity=" + this.getUsedCapacity() + ", " + "absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + ", " + "numApps=" + this.getNumApplications() + ", " + "numContainers=" + this.getNumContainers();
    }

    private synchronized User getUser(String userName) {
        User user = this.users.get(userName);
        if (user == null) {
            user = new User();
            this.users.put(userName, user);
        }
        return user;
    }

    @Override
    public synchronized void reinitialize(CSQueue newlyParsedQueue, org.apache.hadoop.yarn.api.records.Resource clusterResource) throws IOException {
        if (!(newlyParsedQueue instanceof LeafQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
        LeafQueue newlyParsedLeafQueue = (LeafQueue)newlyParsedQueue;
        this.setupQueueConfigs(clusterResource, newlyParsedLeafQueue.capacity, newlyParsedLeafQueue.absoluteCapacity, newlyParsedLeafQueue.maximumCapacity, newlyParsedLeafQueue.absoluteMaxCapacity, newlyParsedLeafQueue.userLimit, newlyParsedLeafQueue.userLimitFactor, newlyParsedLeafQueue.maxApplications, newlyParsedLeafQueue.getMaxApplicationsPerUser(), newlyParsedLeafQueue.getMaximumActiveApplications(), newlyParsedLeafQueue.getMaximumActiveApplicationsPerUser(), newlyParsedLeafQueue.state, newlyParsedLeafQueue.acls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (this.acls.get(acl).isUserAllowed(user)) {
                return true;
            }
        }
        return this.getParent().hasAccess(acl, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(SchedulerApp application, String userName, String queue) throws AccessControlException {
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)userName);
        if (!this.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi)) {
            throw new AccessControlException("User " + userName + " cannot submit" + " applications to queue " + this.getQueuePath());
        }
        User user = null;
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (this.getState() != QueueState.RUNNING) {
                String msg = "Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            if (this.getNumApplications() >= this.getMaxApplications()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + this.getNumApplications() + " applications," + " cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            user = this.getUser(userName);
            if (user.getTotalApplications() >= this.getMaxApplicationsPerUser()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + user.getTotalApplications() + " applications from user " + userName + " cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            this.addApplication(application, user);
        }
        int attemptId = application.getApplicationAttemptId().getAttemptId();
        this.metrics.submitApp(userName, attemptId);
        try {
            this.getParent().submitApplication(application, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application to parent-queue: " + this.getParent().getQueuePath()), (Throwable)ace);
            this.removeApplication(application, user);
            throw ace;
        }
    }

    private synchronized void activateApplications() {
        Iterator<SchedulerApp> i = this.pendingApplications.iterator();
        while (i.hasNext()) {
            SchedulerApp application = i.next();
            if (this.getNumActiveApplications() >= this.getMaximumActiveApplications()) break;
            User user = this.getUser(application.getUser());
            if (user.getActiveApplications() >= this.getMaximumActiveApplicationsPerUser()) continue;
            user.activateApplication();
            this.activeApplications.add(application);
            i.remove();
            LOG.info((Object)("Application " + application.getApplicationId() + " from user: " + application.getUser() + " activated in queue: " + this.getQueueName()));
        }
    }

    private synchronized void addApplication(SchedulerApp application, User user) {
        user.submitApplication();
        this.pendingApplications.add(application);
        this.applicationsMap.put(application.getApplicationAttemptId(), application);
        this.activateApplications();
        LOG.info((Object)("Application added - appId: " + application.getApplicationId() + " user: " + user + "," + " leaf-queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplication(SchedulerApp application, String queue) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.removeApplication(application, this.getUser(application.getUser()));
        }
        this.getParent().finishApplication(application, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeApplication(SchedulerApp application, User user) {
        boolean wasActive = this.activeApplications.remove(application);
        if (!wasActive) {
            this.pendingApplications.remove(application);
        }
        this.applicationsMap.remove(application.getApplicationAttemptId());
        user.finishApplication(wasActive);
        if (user.getTotalApplications() == 0) {
            this.users.remove(application.getUser());
        }
        this.activateApplications();
        SchedulerApp schedulerApp = application;
        synchronized (schedulerApp) {
            this.activeUsersManager.deactivateApplication(application.getUser(), application.getApplicationId());
        }
        LOG.info((Object)("Application removed - appId: " + application.getApplicationId() + " user: " + application.getUser() + " queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    private synchronized SchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applicationsMap.get(applicationAttemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CSAssignment assignContainers(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node) {
        RMContainer reservedContainer;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getHostName() + " #applications=" + this.activeApplications.size()));
        }
        if ((reservedContainer = node.getReservedContainer()) != null) {
            SchedulerApp application = this.getApplication(reservedContainer.getApplicationAttemptId());
            return new CSAssignment(this.assignReservedContainer(application, node, reservedContainer, clusterResource), NodeType.NODE_LOCAL);
        }
        for (SchedulerApp application : this.activeApplications) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("pre-assignContainers for application " + application.getApplicationId()));
                application.showRequests();
            }
            SchedulerApp schedulerApp = application;
            synchronized (schedulerApp) {
                for (Priority priority : application.getPriorities()) {
                    org.apache.hadoop.yarn.api.records.Resource required;
                    if (!this.needContainers(application, priority, required = application.getResourceRequest(priority, "*").getCapability())) continue;
                    org.apache.hadoop.yarn.api.records.Resource userLimit = this.computeUserLimitAndSetHeadroom(application, clusterResource, required);
                    if (!this.assignToQueue(clusterResource, required)) {
                        return NULL_ASSIGNMENT;
                    }
                    if (!this.assignToUser(application.getUser(), userLimit)) break;
                    application.addSchedulingOpportunity(priority);
                    CSAssignment assignment = this.assignContainersOnNode(clusterResource, node, application, priority, null);
                    org.apache.hadoop.yarn.api.records.Resource assigned = assignment.getResource();
                    if (!Resources.greaterThan(assigned, Resources.none())) break;
                    this.allocateResource(clusterResource, application, assigned);
                    if (assignment.getType() != NodeType.OFF_SWITCH) {
                        application.resetSchedulingOpportunities(priority);
                    }
                    return assignment;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("post-assignContainers for application " + application.getApplicationId()));
            }
            application.showRequests();
        }
        return NULL_ASSIGNMENT;
    }

    private synchronized org.apache.hadoop.yarn.api.records.Resource assignReservedContainer(SchedulerApp application, SchedulerNode node, RMContainer rmContainer, org.apache.hadoop.yarn.api.records.Resource clusterResource) {
        Priority priority = rmContainer.getReservedPriority();
        if (application.getTotalRequiredResources(priority) == 0) {
            Container container = rmContainer.getContainer();
            this.completedContainer(clusterResource, application, node, rmContainer, SchedulerUtils.createAbnormalContainerStatus(container.getId(), "Container reservation no longer required."), RMContainerEventType.RELEASED);
            return container.getResource();
        }
        this.assignContainersOnNode(clusterResource, node, application, priority, rmContainer);
        return Resource.NONE;
    }

    private synchronized boolean assignToQueue(org.apache.hadoop.yarn.api.records.Resource clusterResource, org.apache.hadoop.yarn.api.records.Resource required) {
        float potentialNewCapacity = (float)(this.usedResources.getMemory() + required.getMemory()) / (float)clusterResource.getMemory();
        if (potentialNewCapacity > this.absoluteMaxCapacity) {
            LOG.info((Object)(this.getQueueName() + " usedResources: " + this.usedResources.getMemory() + " clusterResources: " + clusterResource.getMemory() + " currentCapacity " + (float)this.usedResources.getMemory() / (float)clusterResource.getMemory() + " required " + required.getMemory() + " potentialNewCapacity: " + potentialNewCapacity + " ( " + " max-capacity: " + this.absoluteMaxCapacity + ")"));
            return false;
        }
        return true;
    }

    @Lock(value={LeafQueue.class, SchedulerApp.class})
    private org.apache.hadoop.yarn.api.records.Resource computeUserLimitAndSetHeadroom(SchedulerApp application, org.apache.hadoop.yarn.api.records.Resource clusterResource, org.apache.hadoop.yarn.api.records.Resource required) {
        String user = application.getUser();
        org.apache.hadoop.yarn.api.records.Resource userLimit = this.computeUserLimit(application, clusterResource, required);
        org.apache.hadoop.yarn.api.records.Resource queueMaxCap = Resources.createResource(CSQueueUtils.roundDown(this.minimumAllocation, (int)(this.absoluteMaxCapacity * (float)clusterResource.getMemory())));
        org.apache.hadoop.yarn.api.records.Resource userConsumed = this.getUser(user).getConsumedResources();
        org.apache.hadoop.yarn.api.records.Resource headroom = Resources.subtract(Resources.min(userLimit, queueMaxCap), userConsumed);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Headroom calculation for user " + user + ": " + " userLimit=" + userLimit + " queueMaxCap=" + queueMaxCap + " consumed=" + userConsumed + " headroom=" + headroom));
        }
        application.setHeadroom(headroom);
        this.metrics.setAvailableResourcesToUser(user, headroom);
        return userLimit;
    }

    @Lock(value={Lock.NoLock.class})
    private org.apache.hadoop.yarn.api.records.Resource computeUserLimit(SchedulerApp application, org.apache.hadoop.yarn.api.records.Resource clusterResource, org.apache.hadoop.yarn.api.records.Resource required) {
        int queueCapacity = Math.max(CSQueueUtils.roundUp(this.minimumAllocation, (int)(this.absoluteCapacity * (float)clusterResource.getMemory())), required.getMemory());
        int consumed = this.usedResources.getMemory();
        int currentCapacity = consumed < queueCapacity ? queueCapacity : consumed + required.getMemory();
        int activeUsers = this.activeUsersManager.getNumActiveUsers();
        int limit = CSQueueUtils.roundUp(this.minimumAllocation, Math.min(Math.max(LeafQueue.divideAndCeil(currentCapacity, activeUsers), LeafQueue.divideAndCeil(this.userLimit * currentCapacity, 100)), (int)((float)queueCapacity * this.userLimitFactor)));
        if (LOG.isDebugEnabled()) {
            String userName = application.getUser();
            LOG.debug((Object)("User limit computation for " + userName + " in queue " + this.getQueueName() + " userLimit=" + this.userLimit + " userLimitFactor=" + this.userLimitFactor + " required: " + required + " consumed: " + this.getUser(userName).getConsumedResources() + " limit: " + limit + " queueCapacity: " + queueCapacity + " qconsumed: " + consumed + " currentCapacity: " + currentCapacity + " activeUsers: " + activeUsers + " clusterCapacity: " + clusterResource.getMemory()));
        }
        return Resources.createResource(limit);
    }

    private synchronized boolean assignToUser(String userName, org.apache.hadoop.yarn.api.records.Resource limit) {
        User user = this.getUser(userName);
        if (user.getConsumedResources().getMemory() > limit.getMemory()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit - " + " consumed: " + user.getConsumedResources() + " limit: " + limit));
            }
            return false;
        }
        return true;
    }

    static int divideAndCeil(int a, int b) {
        if (b == 0) {
            LOG.info((Object)("divideAndCeil called with a=" + a + " b=" + b));
            return 0;
        }
        return (a + (b - 1)) / b;
    }

    boolean needContainers(SchedulerApp application, Priority priority, org.apache.hadoop.yarn.api.records.Resource required) {
        int requiredContainers = application.getTotalRequiredResources(priority);
        int reservedContainers = application.getNumReservedContainers(priority);
        int starvation = 0;
        if (reservedContainers > 0) {
            float nodeFactor = (float)required.getMemory() / (float)this.getMaximumAllocation().getMemory();
            starvation = (int)((float)application.getReReservations(priority) / (float)reservedContainers * (1.0f - Math.min(nodeFactor, this.getMinimumAllocationFactor())));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("needsContainers: app.#re-reserve=" + application.getReReservations(priority) + " reserved=" + reservedContainers + " nodeFactor=" + nodeFactor + " minAllocFactor=" + this.minimumAllocationFactor + " starvation=" + starvation));
            }
        }
        return starvation + requiredContainers - reservedContainers > 0;
    }

    private CSAssignment assignContainersOnNode(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, RMContainer reservedContainer) {
        org.apache.hadoop.yarn.api.records.Resource assigned = Resources.none();
        assigned = this.assignNodeLocalContainers(clusterResource, node, application, priority, reservedContainer);
        if (Resources.greaterThan(assigned, Resources.none())) {
            return new CSAssignment(assigned, NodeType.NODE_LOCAL);
        }
        assigned = this.assignRackLocalContainers(clusterResource, node, application, priority, reservedContainer);
        if (Resources.greaterThan(assigned, Resources.none())) {
            return new CSAssignment(assigned, NodeType.RACK_LOCAL);
        }
        return new CSAssignment(this.assignOffSwitchContainers(clusterResource, node, application, priority, reservedContainer), NodeType.OFF_SWITCH);
    }

    private org.apache.hadoop.yarn.api.records.Resource assignNodeLocalContainers(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, RMContainer reservedContainer) {
        ResourceRequest request = application.getResourceRequest(priority, node.getHostName());
        if (request != null && this.canAssign(application, priority, node, NodeType.NODE_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, request, NodeType.NODE_LOCAL, reservedContainer);
        }
        return Resources.none();
    }

    private org.apache.hadoop.yarn.api.records.Resource assignRackLocalContainers(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, RMContainer reservedContainer) {
        ResourceRequest request = application.getResourceRequest(priority, node.getRackName());
        if (request != null && this.canAssign(application, priority, node, NodeType.RACK_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, request, NodeType.RACK_LOCAL, reservedContainer);
        }
        return Resources.none();
    }

    private org.apache.hadoop.yarn.api.records.Resource assignOffSwitchContainers(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, RMContainer reservedContainer) {
        ResourceRequest request = application.getResourceRequest(priority, "*");
        if (request != null && this.canAssign(application, priority, node, NodeType.OFF_SWITCH, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, request, NodeType.OFF_SWITCH, reservedContainer);
        }
        return Resources.none();
    }

    boolean canAssign(SchedulerApp application, Priority priority, SchedulerNode node, NodeType type, RMContainer reservedContainer) {
        ResourceRequest nodeLocalRequest;
        if (type == NodeType.OFF_SWITCH) {
            float localityWaitFactor;
            if (reservedContainer != null) {
                return true;
            }
            ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
            long missedOpportunities = application.getSchedulingOpportunities(priority);
            long requiredContainers = offSwitchRequest.getNumContainers();
            return (float)requiredContainers * (localityWaitFactor = application.getLocalityWaitFactor(priority, this.scheduler.getNumClusterNodes())) < (float)missedOpportunities;
        }
        ResourceRequest rackLocalRequest = application.getResourceRequest(priority, node.getRackName());
        if (rackLocalRequest == null || rackLocalRequest.getNumContainers() <= 0) {
            return false;
        }
        if (type == NodeType.RACK_LOCAL) {
            return true;
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = application.getResourceRequest(priority, node.getHostName())) != null) {
            return nodeLocalRequest.getNumContainers() > 0;
        }
        return false;
    }

    private Container getContainer(RMContainer rmContainer, SchedulerApp application, SchedulerNode node, org.apache.hadoop.yarn.api.records.Resource capability, Priority priority) {
        return rmContainer != null ? rmContainer.getContainer() : this.createContainer(application, node, capability, priority);
    }

    Container createContainer(SchedulerApp application, SchedulerNode node, org.apache.hadoop.yarn.api.records.Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (int)application.getNewContainerId());
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (org.apache.hadoop.yarn.api.records.Resource)capability, (Priority)priority, null);
        return container;
    }

    ContainerToken createContainerToken(SchedulerApp application, Container container) {
        return this.containerTokenSecretManager.createContainerToken(container.getId(), container.getNodeId(), application.getUser(), container.getResource());
    }

    private org.apache.hadoop.yarn.api.records.Resource assignContainer(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, ResourceRequest request, NodeType type, RMContainer rmContainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getHostName() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " request=" + request + " type=" + (Object)((Object)type)));
        }
        org.apache.hadoop.yarn.api.records.Resource capability = request.getCapability();
        org.apache.hadoop.yarn.api.records.Resource available = node.getAvailableResource();
        assert (available.getMemory() > 0);
        Container container = this.getContainer(rmContainer, application, node, capability, priority);
        if (container == null) {
            return Resources.none();
        }
        int availableContainers = available.getMemory() / capability.getMemory();
        if (availableContainers > 0) {
            RMContainer allocatedContainer;
            if (rmContainer != null) {
                this.unreserve(application, priority, node, rmContainer);
            }
            if (UserGroupInformation.isSecurityEnabled()) {
                ContainerToken containerToken = this.createContainerToken(application, container);
                if (containerToken == null) {
                    return Resources.none();
                }
                container.setContainerToken(containerToken);
            }
            if ((allocatedContainer = application.allocate(type, node, priority, request, container)) == null) {
                return Resources.none();
            }
            node.allocateContainer(application.getApplicationId(), allocatedContainer);
            LOG.info((Object)("assignedContainer application=" + application.getApplicationId() + " container=" + container + " containerId=" + container.getId() + " queue=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usedResources + " cluster=" + clusterResource));
            return container.getResource();
        }
        this.reserve(application, priority, node, rmContainer, container);
        LOG.info((Object)("Reserved container  application=" + application.getApplicationId() + " resource=" + request.getCapability() + " queue=" + this.toString() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usedResources + " cluster=" + clusterResource));
        return request.getCapability();
    }

    private void reserve(SchedulerApp application, Priority priority, SchedulerNode node, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            this.getMetrics().reserveResource(application.getUser(), container.getResource());
        }
        rmContainer = application.reserve(node, priority, rmContainer, container);
        node.reserveResource(application, priority, rmContainer);
    }

    private void unreserve(SchedulerApp application, Priority priority, SchedulerNode node, RMContainer rmContainer) {
        application.unreserve(node, priority);
        node.unreserveResource(application);
        this.getMetrics().unreserveResource(application.getUser(), rmContainer.getContainer().getResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerApp application, SchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (application != null) {
            LeafQueue leafQueue = this;
            synchronized (leafQueue) {
                Container container = rmContainer.getContainer();
                if (rmContainer.getState() == RMContainerState.RESERVED) {
                    this.unreserve(application, rmContainer.getReservedPriority(), node, rmContainer);
                } else {
                    application.containerCompleted(rmContainer, containerStatus, event);
                    node.releaseContainer(container);
                }
                this.releaseResource(clusterResource, application, container.getResource());
                LOG.info((Object)("completedContainer container=" + container + " resource=" + container.getResource() + " queue=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usedResources + " cluster=" + clusterResource));
            }
            this.getParent().completedContainer(clusterResource, application, node, rmContainer, null, event);
        }
    }

    synchronized void allocateResource(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerApp application, org.apache.hadoop.yarn.api.records.Resource resource) {
        Resources.addTo(this.usedResources, resource);
        CSQueueUtils.updateQueueStatistics(this, this.getParent(), clusterResource, this.minimumAllocation);
        ++this.numContainers;
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.assignContainer(resource);
        Resources.subtractFrom(application.getHeadroom(), resource);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)(this.getQueueName() + " user=" + userName + " used=" + this.usedResources + " numContainers=" + this.numContainers + " headroom = " + application.getHeadroom() + " user-resources=" + user.getConsumedResources()));
        }
    }

    synchronized void releaseResource(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerApp application, org.apache.hadoop.yarn.api.records.Resource resource) {
        Resources.subtractFrom(this.usedResources, resource);
        CSQueueUtils.updateQueueStatistics(this, this.getParent(), clusterResource, this.minimumAllocation);
        --this.numContainers;
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.releaseContainer(resource);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        LOG.info((Object)(this.getQueueName() + " used=" + this.usedResources + " numContainers=" + this.numContainers + " user=" + userName + " user-resources=" + user.getConsumedResources()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateClusterResource(org.apache.hadoop.yarn.api.records.Resource clusterResource) {
        this.maxActiveApplications = CSQueueUtils.computeMaxActiveApplications(clusterResource, this.minimumAllocation, this.maxAMResourcePerQueuePercent, this.absoluteMaxCapacity);
        this.maxActiveAppsUsingAbsCap = CSQueueUtils.computeMaxActiveApplications(clusterResource, this.minimumAllocation, this.maxAMResourcePerQueuePercent, this.absoluteCapacity);
        this.maxActiveApplicationsPerUser = CSQueueUtils.computeMaxActiveApplicationsPerUser(this.maxActiveAppsUsingAbsCap, this.userLimit, this.userLimitFactor);
        CSQueueUtils.updateQueueStatistics(this, this.getParent(), clusterResource, this.minimumAllocation);
        Iterator<SchedulerApp> i$ = this.activeApplications.iterator();
        while (i$.hasNext()) {
            SchedulerApp application;
            SchedulerApp schedulerApp = application = i$.next();
            synchronized (schedulerApp) {
                this.computeUserLimitAndSetHeadroom(application, clusterResource, Resources.none());
            }
        }
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerApp application, Container container) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.allocateResource(clusterResource, application, container.getResource());
        }
        this.getParent().recoverContainer(clusterResource, application, container);
    }

    static class User {
        org.apache.hadoop.yarn.api.records.Resource consumed = Resources.createResource(0);
        int pendingApplications = 0;
        int activeApplications = 0;

        User() {
        }

        public org.apache.hadoop.yarn.api.records.Resource getConsumedResources() {
            return this.consumed;
        }

        public int getPendingApplications() {
            return this.pendingApplications;
        }

        public int getActiveApplications() {
            return this.activeApplications;
        }

        public int getTotalApplications() {
            return this.getPendingApplications() + this.getActiveApplications();
        }

        public synchronized void submitApplication() {
            ++this.pendingApplications;
        }

        public synchronized void activateApplication() {
            --this.pendingApplications;
            ++this.activeApplications;
        }

        public synchronized void finishApplication(boolean wasActive) {
            if (wasActive) {
                --this.activeApplications;
            } else {
                --this.pendingApplications;
            }
        }

        public synchronized void assignContainer(org.apache.hadoop.yarn.api.records.Resource resource) {
            Resources.addTo(this.consumed, resource);
        }

        public synchronized void releaseContainer(org.apache.hadoop.yarn.api.records.Resource resource) {
            Resources.subtractFrom(this.consumed, resource);
        }
    }
}

