/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.records.HeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.BuilderUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMNodeImpl
implements RMNode,
EventHandler<RMNodeEvent> {
    private static final Log LOG = LogFactory.getLog(RMNodeImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final NodeId nodeId;
    private final RMContext context;
    private final String hostName;
    private final int commandPort;
    private final int httpPort;
    private final String nodeAddress;
    private final String httpAddress;
    private final Resource totalCapability;
    private final Node node;
    private final NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)recordFactory.newRecordInstance(NodeHealthStatus.class);
    private final Map<ContainerId, ContainerStatus> justLaunchedContainers = new HashMap<ContainerId, ContainerStatus>();
    private final Set<ContainerId> containersToClean = new TreeSet<ContainerId>((Comparator<ContainerId>)new BuilderUtils.ContainerIdComparator());
    private final List<ApplicationId> finishedApplications = new ArrayList<ApplicationId>();
    private HeartbeatResponse latestHeartBeatResponse = (HeartbeatResponse)recordFactory.newRecordInstance(HeartbeatResponse.class);
    private static final StateMachineFactory<RMNodeImpl, RMNodeState, RMNodeEventType, RMNodeEvent> stateMachineFactory = new StateMachineFactory((Enum)RMNodeState.NEW).addTransition((Enum)RMNodeState.NEW, (Enum)RMNodeState.RUNNING, (Enum)RMNodeEventType.STARTED, (SingleArcTransition)new AddNodeTransition()).addTransition((Enum)RMNodeState.RUNNING, EnumSet.of(RMNodeState.RUNNING, RMNodeState.UNHEALTHY), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenHealthyTransition()).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(RMNodeState.DECOMMISSIONED)).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(RMNodeState.LOST)).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(RMNodeState.REBOOTED)).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.RUNNING, (Enum)RMNodeEventType.RECONNECTED, (SingleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)RMNodeState.UNHEALTHY, EnumSet.of(RMNodeState.UNHEALTHY, RMNodeState.RUNNING), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenUnHealthyTransition()).addTransition((Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(RMNodeState.DECOMMISSIONED)).addTransition((Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(RMNodeState.LOST)).addTransition((Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(RMNodeState.REBOOTED)).addTransition((Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeEventType.RECONNECTED, (SingleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).installTopology();
    private final StateMachine<RMNodeState, RMNodeEventType, RMNodeEvent> stateMachine;

    public RMNodeImpl(NodeId nodeId, RMContext context, String hostName, int cmPort, int httpPort, Node node, Resource capability) {
        this.nodeId = nodeId;
        this.context = context;
        this.hostName = hostName;
        this.commandPort = cmPort;
        this.httpPort = httpPort;
        this.totalCapability = capability;
        this.nodeAddress = hostName + ":" + cmPort;
        this.httpAddress = hostName + ":" + httpPort;
        this.node = node;
        this.nodeHealthStatus.setIsNodeHealthy(true);
        this.nodeHealthStatus.setHealthReport("Healthy");
        this.nodeHealthStatus.setLastHealthReportTime(System.currentTimeMillis());
        this.latestHeartBeatResponse.setResponseId(0);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    public String toString() {
        return this.nodeId.toString();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getCommandPort() {
        return this.commandPort;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    public NodeId getNodeID() {
        return this.nodeId;
    }

    @Override
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public String getHttpAddress() {
        return this.httpAddress;
    }

    @Override
    public Resource getTotalCapability() {
        return this.totalCapability;
    }

    @Override
    public String getRackName() {
        return this.node.getNetworkLocation();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeHealthStatus getNodeHealthStatus() {
        this.readLock.lock();
        try {
            NodeHealthStatus nodeHealthStatus = this.nodeHealthStatus;
            return nodeHealthStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNodeHealthStatus(NodeHealthStatus status) {
        this.writeLock.lock();
        try {
            this.nodeHealthStatus.setHealthReport(status.getHealthReport());
            this.nodeHealthStatus.setIsNodeHealthy(status.getIsNodeHealthy());
            this.nodeHealthStatus.setLastHealthReportTime(status.getLastHealthReportTime());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMNodeState getState() {
        this.readLock.lock();
        try {
            RMNodeState rMNodeState = (RMNodeState)this.stateMachine.getCurrentState();
            return rMNodeState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationId> getAppsToCleanup() {
        this.readLock.lock();
        try {
            ArrayList<ApplicationId> arrayList = new ArrayList<ApplicationId>(this.finishedApplications);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerId> getContainersToCleanUp() {
        this.readLock.lock();
        try {
            ArrayList<ContainerId> arrayList = new ArrayList<ContainerId>(this.containersToClean);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HeartbeatResponse getLastHeartBeatResponse() {
        this.readLock.lock();
        try {
            HeartbeatResponse heartbeatResponse = this.latestHeartBeatResponse;
            return heartbeatResponse;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMNodeEvent event) {
        LOG.debug((Object)("Processing " + event.getNodeId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            RMNodeState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on Node  " + this.nodeId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.nodeId + " Node Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateMetricsForRejoinedNode(RMNodeState previousNodeState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        metrics.incrNumActiveNodes();
        switch (previousNodeState) {
            case LOST: {
                metrics.decrNumLostNMs();
                break;
            }
            case REBOOTED: {
                metrics.decrNumRebootedNMs();
                break;
            }
            case DECOMMISSIONED: {
                metrics.decrDecommisionedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
            }
        }
    }

    private void updateMetricsForDeactivatedNode(RMNodeState finalState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        metrics.decrNumActiveNodes();
        switch (finalState) {
            case DECOMMISSIONED: {
                metrics.incrDecommisionedNMs();
                break;
            }
            case LOST: {
                metrics.incrNumLostNMs();
                break;
            }
            case REBOOTED: {
                metrics.incrNumRebootedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.incrNumUnhealthyNMs();
            }
        }
    }

    public static class StatusUpdateWhenUnHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, RMNodeState> {
        public RMNodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
            rmNode.latestHeartBeatResponse = statusEvent.getLatestResponse();
            NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
            rmNode.setNodeHealthStatus(remoteNodeHealthStatus);
            if (remoteNodeHealthStatus.getIsNodeHealthy()) {
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
                rmNode.updateMetricsForRejoinedNode(RMNodeState.UNHEALTHY);
                return RMNodeState.RUNNING;
            }
            return RMNodeState.UNHEALTHY;
        }
    }

    public static class StatusUpdateWhenHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, RMNodeState> {
        public RMNodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
            rmNode.latestHeartBeatResponse = statusEvent.getLatestResponse();
            NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
            rmNode.setNodeHealthStatus(remoteNodeHealthStatus);
            if (!remoteNodeHealthStatus.getIsNodeHealthy()) {
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
                rmNode.updateMetricsForDeactivatedNode(RMNodeState.UNHEALTHY);
                return RMNodeState.UNHEALTHY;
            }
            ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
            ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
            for (ContainerStatus remoteContainer : statusEvent.getContainers()) {
                ContainerId containerId = remoteContainer.getContainerId();
                if (rmNode.containersToClean.contains(containerId)) {
                    LOG.info((Object)("Container " + containerId + " already scheduled for " + "cleanup, no further processing"));
                    continue;
                }
                if (rmNode.finishedApplications.contains(containerId.getApplicationAttemptId().getApplicationId())) {
                    LOG.info((Object)("Container " + containerId + " belongs to an application that is already killed," + " no further processing"));
                    continue;
                }
                if (remoteContainer.getState() == ContainerState.RUNNING) {
                    if (rmNode.justLaunchedContainers.containsKey(containerId)) continue;
                    rmNode.justLaunchedContainers.put(containerId, remoteContainer);
                    newlyLaunchedContainers.add(remoteContainer);
                    continue;
                }
                rmNode.justLaunchedContainers.remove(containerId);
                completedContainers.add(remoteContainer);
            }
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeUpdateSchedulerEvent(rmNode, newlyLaunchedContainers, completedContainers));
            rmNode.context.getDelegationTokenRenewer().updateKeepAliveApplications(statusEvent.getKeepAliveAppIds());
            rmNode.containersToClean.clear();
            rmNode.finishedApplications.clear();
            return RMNodeState.RUNNING;
        }
    }

    public static class DeactivateNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        private final RMNodeState finalState;

        public DeactivateNodeTransition(RMNodeState finalState) {
            this.finalState = finalState;
        }

        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
            rmNode.context.getRMNodes().remove(rmNode.nodeId);
            LOG.info((Object)("Deactivating Node " + rmNode.nodeId + " as it is now " + (Object)((Object)this.finalState)));
            rmNode.context.getInactiveRMNodes().put(rmNode.nodeId.getHost(), rmNode);
            rmNode.updateMetricsForDeactivatedNode(this.finalState);
        }
    }

    public static class CleanUpContainerTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.containersToClean.add(((RMNodeCleanContainerEvent)event).getContainerId());
        }
    }

    public static class CleanUpAppTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.finishedApplications.add(((RMNodeCleanAppEvent)event).getAppId());
        }
    }

    public static class ReconnectNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
            RMNode newNode = ((RMNodeReconnectEvent)event).getReconnectedNode();
            if (rmNode.getTotalCapability().equals((Object)newNode.getTotalCapability()) && rmNode.getHttpPort() == newNode.getHttpPort()) {
                rmNode.getLastHeartBeatResponse().setResponseId(0);
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
            } else {
                switch (rmNode.getState()) {
                    case RUNNING: {
                        ClusterMetrics.getMetrics().decrNumActiveNodes();
                        break;
                    }
                    case UNHEALTHY: {
                        ClusterMetrics.getMetrics().decrNumUnhealthyNMs();
                    }
                }
                rmNode.context.getRMNodes().put(newNode.getNodeID(), newNode);
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(newNode.getNodeID(), RMNodeEventType.STARTED));
            }
        }
    }

    public static class AddNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
            String host = rmNode.nodeId.getHost();
            if (rmNode.context.getInactiveRMNodes().containsKey(host)) {
                RMNode previouRMNode = (RMNode)rmNode.context.getInactiveRMNodes().get(host);
                rmNode.context.getInactiveRMNodes().remove(host);
                rmNode.updateMetricsForRejoinedNode(previouRMNode.getState());
            } else {
                ClusterMetrics.getMetrics().incrNumActiveNodes();
            }
        }
    }
}

