/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAcquiredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAllocatedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

public class RMContainerImpl
implements RMContainer {
    private static final Log LOG = LogFactory.getLog(RMContainerImpl.class);
    private static final StateMachineFactory<RMContainerImpl, RMContainerState, RMContainerEventType, RMContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)RMContainerState.NEW).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition()).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.ACQUIRED, (Enum)RMContainerEventType.ACQUIRED, (SingleArcTransition)new AcquiredTransition()).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.LAUNCHED, (SingleArcTransition)new LaunchedTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new ContainerFinishedAtAcquiredState()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.EXPIRE).addTransition((Enum)RMContainerState.COMPLETED, (Enum)RMContainerState.COMPLETED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.EXPIRED, (Enum)RMContainerState.EXPIRED, EnumSet.of(RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.RELEASED, (Enum)RMContainerState.RELEASED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).addTransition((Enum)RMContainerState.KILLED, (Enum)RMContainerState.KILLED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).installTopology();
    private final StateMachine<RMContainerState, RMContainerEventType, RMContainerEvent> stateMachine = stateMachineFactory.make((Object)this);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ContainerId containerId;
    private final ApplicationAttemptId appAttemptId;
    private final NodeId nodeId;
    private final Container container;
    private final EventHandler eventHandler;
    private final ContainerAllocationExpirer containerAllocationExpirer;
    private Resource reservedResource;
    private NodeId reservedNode;
    private Priority reservedPriority;

    public RMContainerImpl(Container container, ApplicationAttemptId appAttemptId, NodeId nodeId, EventHandler handler, ContainerAllocationExpirer containerAllocationExpirer) {
        this.containerId = container.getId();
        this.nodeId = nodeId;
        this.container = container;
        this.appAttemptId = appAttemptId;
        this.eventHandler = handler;
        this.containerAllocationExpirer = containerAllocationExpirer;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMContainerState getState() {
        this.readLock.lock();
        try {
            RMContainerState rMContainerState = (RMContainerState)this.stateMachine.getCurrentState();
            return rMContainerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Resource getReservedResource() {
        return this.reservedResource;
    }

    @Override
    public NodeId getReservedNode() {
        return this.reservedNode;
    }

    @Override
    public Priority getReservedPriority() {
        return this.reservedPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMContainerEvent event) {
        LOG.debug((Object)("Processing " + event.getContainerId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            RMContainerState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on container " + this.containerId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(event.getContainerId() + " Container Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static final class KillTransition
    extends FinishedTransition {
        private KillTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
            container.eventHandler.handle((Event)new RMNodeCleanContainerEvent(container.nodeId, container.containerId));
            super.transition(container, event);
        }
    }

    private static final class ContainerFinishedAtAcquiredState
    extends FinishedTransition {
        private ContainerFinishedAtAcquiredState() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
            super.transition(container, event);
        }
    }

    private static class FinishedTransition
    extends BaseTransition {
        private FinishedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerFinishedEvent finishedEvent = (RMContainerFinishedEvent)event;
            container.container.setContainerStatus(finishedEvent.getRemoteContainerStatus());
            container.eventHandler.handle((Event)new RMAppAttemptContainerFinishedEvent(container.appAttemptId, container.container.getContainerStatus()));
        }
    }

    private static final class LaunchedTransition
    extends BaseTransition {
        private LaunchedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(container.getContainerId());
        }
    }

    private static final class AcquiredTransition
    extends BaseTransition {
        private AcquiredTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.register(container.getContainerId());
            container.eventHandler.handle((Event)new RMAppAttemptContainerAcquiredEvent(container.getApplicationAttemptId(), container.getContainer()));
        }
    }

    private static final class ContainerStartedTransition
    extends BaseTransition {
        private ContainerStartedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.eventHandler.handle((Event)new RMAppAttemptContainerAllocatedEvent(container.appAttemptId, container.container));
        }
    }

    private static final class ContainerReservedTransition
    extends BaseTransition {
        private ContainerReservedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerReservedEvent e = (RMContainerReservedEvent)event;
            container.reservedResource = e.getReservedResource();
            container.reservedNode = e.getReservedNode();
            container.reservedPriority = e.getReservedPriority();
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<RMContainerImpl, RMContainerEvent> {
        private BaseTransition() {
        }

        public void transition(RMContainerImpl cont, RMContainerEvent event) {
        }
    }
}

