/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.amlauncher;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ApplicationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMSecretManager;
import org.apache.hadoop.yarn.security.client.ClientTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.util.ProtoUtils;

public class AMLauncher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(AMLauncher.class);
    private ContainerManager containerMgrProxy;
    private final RMAppAttempt application;
    private final Configuration conf;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ClientToAMSecretManager clientToAMSecretManager;
    private final AMLauncherEventType eventType;
    private final RMContext rmContext;
    private final EventHandler handler;

    public AMLauncher(RMContext rmContext, RMAppAttempt application, AMLauncherEventType eventType, ClientToAMSecretManager clientToAMSecretManager, Configuration conf) {
        this.application = application;
        this.conf = conf;
        this.clientToAMSecretManager = clientToAMSecretManager;
        this.eventType = eventType;
        this.rmContext = rmContext;
        this.handler = rmContext.getDispatcher().getEventHandler();
    }

    private void connect() throws IOException {
        ContainerId masterContainerID = this.application.getMasterContainer().getId();
        this.containerMgrProxy = this.getContainerMgrProxy(masterContainerID);
    }

    private void launch() throws IOException {
        this.connect();
        ContainerId masterContainerID = this.application.getMasterContainer().getId();
        ApplicationSubmissionContext applicationContext = this.application.getSubmissionContext();
        LOG.info((Object)("Setting up container " + this.application.getMasterContainer() + " for AM " + this.application.getAppAttemptId()));
        ContainerLaunchContext launchContext = this.createAMContainerLaunchContext(applicationContext, masterContainerID);
        StartContainerRequest request = (StartContainerRequest)this.recordFactory.newRecordInstance(StartContainerRequest.class);
        request.setContainerLaunchContext(launchContext);
        this.containerMgrProxy.startContainer(request);
        LOG.info((Object)("Done launching container " + this.application.getMasterContainer() + " for AM " + this.application.getAppAttemptId()));
    }

    private void cleanup() throws IOException {
        this.connect();
        ContainerId containerId = this.application.getMasterContainer().getId();
        StopContainerRequest stopRequest = (StopContainerRequest)this.recordFactory.newRecordInstance(StopContainerRequest.class);
        stopRequest.setContainerId(containerId);
        this.containerMgrProxy.stopContainer(stopRequest);
    }

    protected ContainerManager getContainerMgrProxy(ContainerId containerId) {
        Container container = this.application.getMasterContainer();
        NodeId node = container.getNodeId();
        final InetSocketAddress containerManagerBindAddress = NetUtils.createSocketAddrForHost((String)node.getHost(), (int)node.getPort());
        final YarnRPC rpc = YarnRPC.create((Configuration)this.conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)containerId.toString());
        if (UserGroupInformation.isSecurityEnabled()) {
            Token token = ProtoUtils.convertFromProtoFormat((DelegationToken)container.getContainerToken(), (InetSocketAddress)containerManagerBindAddress);
            currentUser.addToken(token);
        }
        return (ContainerManager)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ContainerManager>(){

            @Override
            public ContainerManager run() {
                return (ContainerManager)rpc.getProxy(ContainerManager.class, containerManagerBindAddress, AMLauncher.this.conf);
            }
        });
    }

    private ContainerLaunchContext createAMContainerLaunchContext(ApplicationSubmissionContext applicationMasterContext, ContainerId containerID) throws IOException {
        ContainerLaunchContext container = applicationMasterContext.getAMContainerSpec();
        LOG.info((Object)("Command to launch container " + containerID + " : " + StringUtils.arrayToString((String[])container.getCommands().toArray(new String[0]))));
        container.setContainerId(containerID);
        container.setUser(applicationMasterContext.getUser());
        this.setupTokensAndEnv(container);
        return container;
    }

    private void setupTokensAndEnv(ContainerLaunchContext container) throws IOException {
        Map environment = container.getEnvironment();
        environment.put("APPLICATION_WEB_PROXY_BASE", this.application.getWebProxyBase());
        environment.put("AM_CONTAINER_ID", container.getContainerId().toString());
        environment.put("NM_HOST", this.application.getMasterContainer().getNodeId().getHost());
        environment.put("NM_PORT", String.valueOf(this.application.getMasterContainer().getNodeId().getPort()));
        String[] parts = this.application.getMasterContainer().getNodeHttpAddress().split(":");
        environment.put("NM_HTTP_PORT", parts[1]);
        environment.put("APP_SUBMIT_TIME_ENV", String.valueOf(((RMApp)this.rmContext.getRMApps().get(this.application.getAppAttemptId().getApplicationId())).getSubmitTime()));
        if (UserGroupInformation.isSecurityEnabled()) {
            Credentials credentials = new Credentials();
            DataInputByteBuffer dibb = new DataInputByteBuffer();
            if (container.getContainerTokens() != null) {
                dibb.reset(new ByteBuffer[]{container.getContainerTokens()});
                credentials.readTokenStorageStream((DataInputStream)dibb);
            }
            ApplicationTokenIdentifier id = new ApplicationTokenIdentifier(this.application.getAppAttemptId());
            Token token = new Token((TokenIdentifier)id, (SecretManager)this.rmContext.getApplicationTokenSecretManager());
            InetSocketAddress serviceAddr = this.conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)serviceAddr);
            String appMasterTokenEncoded = token.encodeToUrlString();
            LOG.debug((Object)("Putting appMaster token in env : " + token));
            environment.put("AppMasterTokenEnv", appMasterTokenEncoded);
            credentials.addToken(token.getService(), token);
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            container.setContainerTokens(ByteBuffer.wrap(dob.getData(), 0, dob.getLength()));
            ClientTokenIdentifier identifier = new ClientTokenIdentifier(this.application.getAppAttemptId().getApplicationId());
            SecretKey clientSecretKey = this.clientToAMSecretManager.getMasterKey(identifier);
            String encoded = Base64.encodeBase64URLSafeString((byte[])clientSecretKey.getEncoded());
            environment.put("AppClientTokenEnv", encoded);
        }
    }

    @Override
    public void run() {
        switch (this.eventType) {
            case LAUNCH: {
                try {
                    LOG.info((Object)("Launching master" + this.application.getAppAttemptId()));
                    this.launch();
                    this.handler.handle((Event)new RMAppAttemptEvent(this.application.getAppAttemptId(), RMAppAttemptEventType.LAUNCHED));
                }
                catch (Exception ie) {
                    String message = "Error launching " + this.application.getAppAttemptId() + ". Got exception: " + StringUtils.stringifyException((Throwable)ie);
                    LOG.info((Object)message);
                    this.handler.handle((Event)new RMAppAttemptLaunchFailedEvent(this.application.getAppAttemptId(), message));
                }
                break;
            }
            case CLEANUP: {
                try {
                    LOG.info((Object)("Cleaning master " + this.application.getAppAttemptId()));
                    this.cleanup();
                }
                catch (IOException ie) {
                    LOG.info((Object)"Error cleaning master ", (Throwable)ie);
                }
                break;
            }
            default: {
                LOG.warn((Object)("Received unknown event-type " + (Object)((Object)this.eventType) + ". Ignoring."));
            }
        }
    }
}

