/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class LogDumper
extends Configured
implements Tool {
    private static final String CONTAINER_ID_OPTION = "containerId";
    private static final String APPLICATION_ID_OPTION = "applicationId";
    private static final String NODE_ADDRESS_OPTION = "nodeAddress";
    private static final String APP_OWNER_OPTION = "appOwner";

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption(APPLICATION_ID_OPTION, true, "ApplicationId");
        opts.addOption(CONTAINER_ID_OPTION, true, "ContainerId");
        opts.addOption(NODE_ADDRESS_OPTION, true, "NodeAddress");
        opts.addOption(APP_OWNER_OPTION, true, "AppOwner");
        if (args.length < 1) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            return -1;
        }
        GnuParser parser = new GnuParser();
        String appIdStr = null;
        String containerIdStr = null;
        String nodeAddress = null;
        String appOwner = null;
        try {
            CommandLine commandLine = parser.parse(opts, args, true);
            appIdStr = commandLine.getOptionValue(APPLICATION_ID_OPTION);
            containerIdStr = commandLine.getOptionValue(CONTAINER_ID_OPTION);
            nodeAddress = commandLine.getOptionValue(NODE_ADDRESS_OPTION);
            appOwner = commandLine.getOptionValue(APP_OWNER_OPTION);
        }
        catch (ParseException e) {
            System.out.println("options parsing failed: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            return -1;
        }
        if (appIdStr == null) {
            System.out.println("ApplicationId cannot be null!");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            return -1;
        }
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(this.getConf());
        ApplicationId appId = ConverterUtils.toApplicationId(recordFactory, appIdStr);
        DataOutputStream out = new DataOutputStream(System.out);
        if (appOwner == null || appOwner.isEmpty()) {
            appOwner = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        int resultCode = 0;
        if (containerIdStr == null && nodeAddress == null) {
            resultCode = this.dumpAllContainersLogs(appId, appOwner, out);
        } else if (containerIdStr == null && nodeAddress != null || containerIdStr != null && nodeAddress == null) {
            System.out.println("ContainerId or NodeAddress cannot be null!");
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            resultCode = -1;
        } else {
            Path remoteRootLogDir = new Path(this.getConf().get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
            AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.getConf(), LogAggregationUtils.getRemoteNodeLogFileForApp(remoteRootLogDir, appId, appOwner, ConverterUtils.toNodeId(nodeAddress), LogAggregationUtils.getRemoteNodeLogDirSuffix(this.getConf())));
            resultCode = this.dumpAContainerLogs(containerIdStr, reader, out);
        }
        return resultCode;
    }

    public int dumpAContainersLogs(String appId, String containerId, String nodeId, String jobOwner) throws IOException {
        AggregatedLogFormat.LogReader reader;
        Path remoteRootLogDir = new Path(this.getConf().get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(this.getConf());
        Path logPath = LogAggregationUtils.getRemoteNodeLogFileForApp(remoteRootLogDir, ConverterUtils.toApplicationId(appId), jobOwner, ConverterUtils.toNodeId(nodeId), suffix);
        try {
            reader = new AggregatedLogFormat.LogReader(this.getConf(), logPath);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Logs not available at " + logPath.toString());
            System.out.println("Log aggregation has not completed or is not enabled.");
            return -1;
        }
        DataOutputStream out = new DataOutputStream(System.out);
        return this.dumpAContainerLogs(containerId, reader, out);
    }

    private int dumpAContainerLogs(String containerIdStr, AggregatedLogFormat.LogReader reader, DataOutputStream out) throws IOException {
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        DataInputStream valueStream = reader.next(key);
        while (valueStream != null && !key.toString().equals(containerIdStr)) {
            key = new AggregatedLogFormat.LogKey();
            valueStream = reader.next(key);
        }
        if (valueStream == null) {
            System.out.println("Logs for container " + containerIdStr + " are not present in this log-file.");
            return -1;
        }
        try {
            while (true) {
                AggregatedLogFormat.LogReader.readAContainerLogsForALogType(valueStream, out);
            }
        }
        catch (EOFException eof) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpAllContainersLogs(ApplicationId appId, String appOwner, DataOutputStream out) throws IOException {
        RemoteIterator nodeFiles;
        Path remoteRootLogDir = new Path(this.getConf().get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String user = appOwner;
        String logDirSuffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(this.getConf());
        Path remoteAppLogDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, logDirSuffix);
        try {
            nodeFiles = FileContext.getFileContext().listStatus(remoteAppLogDir);
        }
        catch (FileNotFoundException fnf) {
            System.out.println("Logs not available at " + remoteAppLogDir.toString());
            System.out.println("Log aggregation has not completed or is not enabled.");
            return -1;
        }
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.getConf(), new Path(remoteAppLogDir, thisNodeFile.getPath().getName()));
            try {
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    try {
                        while (true) {
                            AggregatedLogFormat.LogReader.readAContainerLogsForALogType(valueStream, out);
                        }
                    }
                    catch (EOFException eof) {
                        key = new AggregatedLogFormat.LogKey();
                        valueStream = reader.next(key);
                    }
                }
            }
            finally {
                reader.close();
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        LogDumper logDumper = new LogDumper();
        logDumper.setConf(conf);
        int exitCode = logDumper.run(args);
        System.exit(exitCode);
    }
}

