/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ProtoBase;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerTokenPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.util.ProtoUtils;

public class ContainerPBImpl
extends ProtoBase<YarnProtos.ContainerProto>
implements Container {
    YarnProtos.ContainerProto proto = YarnProtos.ContainerProto.getDefaultInstance();
    YarnProtos.ContainerProto.Builder builder = null;
    boolean viaProto = false;
    private ContainerId containerId = null;
    private NodeId nodeId = null;
    private Resource resource = null;
    private Priority priority = null;
    private ContainerToken containerToken = null;
    private ContainerStatus containerStatus = null;

    public ContainerPBImpl() {
        this.builder = YarnProtos.ContainerProto.newBuilder();
    }

    public ContainerPBImpl(YarnProtos.ContainerProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public YarnProtos.ContainerProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.containerId != null && !((ContainerIdPBImpl)this.containerId).getProto().equals(this.builder.getId())) {
            this.builder.setId(this.convertToProtoFormat(this.containerId));
        }
        if (this.nodeId != null && !((NodeIdPBImpl)this.nodeId).getProto().equals(this.builder.getNodeId())) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.resource != null && !((ResourcePBImpl)this.resource).getProto().equals(this.builder.getResource())) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
        if (this.priority != null && !((PriorityPBImpl)this.priority).getProto().equals(this.builder.getPriority())) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.containerToken != null && !((ContainerTokenPBImpl)this.containerToken).getProto().equals(this.builder.getContainerToken())) {
            this.builder.setContainerToken(this.convertToProtoFormat(this.containerToken));
        }
        if (this.containerStatus != null && !((ContainerStatusPBImpl)this.containerStatus).getProto().equals(this.builder.getContainerStatus())) {
            this.builder.setContainerStatus(this.convertToProtoFormat(this.containerStatus));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public ContainerState getState() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getState());
    }

    @Override
    public void setState(ContainerState state) {
        this.maybeInitBuilder();
        if (state == null) {
            this.builder.clearState();
            return;
        }
        this.builder.setState(this.convertToProtoFormat(state));
    }

    @Override
    public ContainerId getId() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.containerId != null) {
            return this.containerId;
        }
        if (!p.hasId()) {
            return null;
        }
        this.containerId = this.convertFromProtoFormat(p.getId());
        return this.containerId;
    }

    @Override
    public void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public NodeId getNodeId() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public void setId(ContainerId id) {
        this.maybeInitBuilder();
        if (id == null) {
            this.builder.clearId();
        }
        this.containerId = id;
    }

    @Override
    public String getNodeHttpAddress() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeHttpAddress()) {
            return null;
        }
        return p.getNodeHttpAddress();
    }

    @Override
    public void setNodeHttpAddress(String nodeHttpAddress) {
        this.maybeInitBuilder();
        if (nodeHttpAddress == null) {
            this.builder.clearNodeHttpAddress();
            return;
        }
        this.builder.setNodeHttpAddress(nodeHttpAddress);
    }

    @Override
    public Resource getResource() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    @Override
    public Priority getPriority() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    @Override
    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    @Override
    public ContainerToken getContainerToken() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.containerToken != null) {
            return this.containerToken;
        }
        if (!p.hasContainerToken()) {
            return null;
        }
        this.containerToken = this.convertFromProtoFormat(p.getContainerToken());
        return this.containerToken;
    }

    @Override
    public void setContainerToken(ContainerToken containerToken) {
        this.maybeInitBuilder();
        if (containerToken == null) {
            this.builder.clearContainerToken();
        }
        this.containerToken = containerToken;
    }

    @Override
    public ContainerStatus getContainerStatus() {
        YarnProtos.ContainerProtoOrBuilder p;
        YarnProtos.ContainerProtoOrBuilder containerProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.containerStatus != null) {
            return this.containerStatus;
        }
        if (!p.hasContainerStatus()) {
            return null;
        }
        this.containerStatus = this.convertFromProtoFormat(p.getContainerStatus());
        return this.containerStatus;
    }

    @Override
    public void setContainerStatus(ContainerStatus containerStatus) {
        this.maybeInitBuilder();
        if (containerStatus == null) {
            this.builder.clearContainerStatus();
        }
        this.containerStatus = containerStatus;
    }

    private YarnProtos.ContainerStateProto convertToProtoFormat(ContainerState e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private ContainerState convertFromProtoFormat(YarnProtos.ContainerStateProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority p) {
        return ((PriorityPBImpl)p).getProto();
    }

    private ContainerTokenPBImpl convertFromProtoFormat(YarnProtos.ContainerTokenProto p) {
        return new ContainerTokenPBImpl(p);
    }

    private YarnProtos.ContainerTokenProto convertToProtoFormat(ContainerToken t) {
        return ((ContainerTokenPBImpl)t).getProto();
    }

    private ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto p) {
        return new ContainerStatusPBImpl(p);
    }

    private YarnProtos.ContainerStatusProto convertToProtoFormat(ContainerStatus t) {
        return ((ContainerStatusPBImpl)t).getProto();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Container: [");
        sb.append("ContainerId: ").append(this.getId()).append(", ");
        sb.append("NodeId: ").append(this.getNodeId()).append(", ");
        sb.append("NodeHttpAddress: ").append(this.getNodeHttpAddress()).append(", ");
        sb.append("Resource: ").append(this.getResource()).append(", ");
        sb.append("Priority: ").append(this.getPriority()).append(", ");
        sb.append("State: ").append((Object)this.getState()).append(", ");
        sb.append("Token: ").append(this.getContainerToken()).append(", ");
        sb.append("Status: ").append(this.getContainerStatus());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(Container other) {
        if (this.getId().compareTo(other.getId()) == 0) {
            if (this.getNodeId().compareTo(other.getNodeId()) == 0) {
                if (this.getResource().compareTo(other.getResource()) == 0) {
                    if (this.getState().compareTo(other.getState()) == 0) {
                        return this.getState().compareTo(other.getState());
                    }
                    return this.getState().compareTo(other.getState());
                }
                return this.getResource().compareTo(other.getResource());
            }
            return this.getNodeId().compareTo(other.getNodeId());
        }
        return this.getId().compareTo(other.getId());
    }
}

