/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.EventType;
import org.apache.hadoop.tools.rumen.HistoryEvent;

public class TaskAttemptStartedEvent
implements HistoryEvent {
    private TaskID taskId;
    private TaskAttemptID attemptId;
    private long startTime;
    private TaskType taskType;
    private String trackerName;
    private int httpPort;

    public TaskAttemptStartedEvent(TaskAttemptID attemptId, TaskType taskType, long startTime, String trackerName, int httpPort) {
        this.taskId = attemptId.getTaskID();
        this.attemptId = attemptId;
        this.startTime = startTime;
        this.taskType = taskType;
        this.trackerName = trackerName;
        this.httpPort = httpPort;
    }

    public TaskID getTaskId() {
        return this.taskId;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.attemptId;
    }

    @Override
    public EventType getEventType() {
        return EventType.MAP_ATTEMPT_STARTED;
    }
}

