/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.rumen.InputDemuxer;
import org.apache.hadoop.tools.rumen.Pair;
import org.apache.hadoop.tools.rumen.PossiblyDecompressedInputStream;

public class ConcatenatedInputFilesDemuxer
implements InputDemuxer {
    private String name;
    private DelimitedInputStream input;
    private String knownNextFileName = null;
    private static int MAXIMUM_HEADER_LINE_LENGTH = 500;

    public void bindTo(Path path, Configuration conf) throws IOException {
        PossiblyDecompressedInputStream underlyingInput = null;
        if (this.name != null) {
            this.close();
        }
        this.name = path.getName();
        underlyingInput = new PossiblyDecompressedInputStream(path, conf);
        this.input = new DelimitedInputStream(new BufferedInputStream((InputStream)underlyingInput), "\f!!FILE=", "!!\n");
        this.knownNextFileName = this.input.nextFileName();
        if (this.knownNextFileName == null) {
            this.close();
            return;
        }
    }

    public Pair<String, InputStream> getNext() throws IOException {
        if (this.knownNextFileName != null) {
            Pair result = new Pair((Object)this.knownNextFileName, (Object)this.input);
            this.knownNextFileName = null;
            return result;
        }
        String nextFileName = this.input.nextFileName();
        if (nextFileName == null) {
            return null;
        }
        return new Pair((Object)nextFileName, (Object)this.input);
    }

    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
    }

    static class DelimitedInputStream
    extends InputStream {
        private InputStream input;
        private boolean endSeen = false;
        private final String fileMarker;
        private final byte[] markerBytes;
        private final byte[] fileMarkerBuffer;
        private final String fileEndMarker;
        private final byte[] endMarkerBytes;
        private final byte[] fileEndMarkerBuffer;

        public DelimitedInputStream(InputStream input, String fileMarker, String fileEndMarker) {
            this.input = new BufferedInputStream(input, 10000);
            this.input.mark(10000);
            this.fileMarker = fileMarker;
            this.markerBytes = this.fileMarker.getBytes();
            this.fileMarkerBuffer = new byte[this.markerBytes.length];
            this.fileEndMarker = fileEndMarker;
            this.endMarkerBytes = this.fileEndMarker.getBytes();
            this.fileEndMarkerBuffer = new byte[this.endMarkerBytes.length];
        }

        @Override
        public int read() throws IOException {
            if (this.endSeen) {
                return -1;
            }
            this.input.mark(10000);
            int result = this.input.read();
            if (result < 0) {
                this.endSeen = true;
                return result;
            }
            if (result == this.markerBytes[0]) {
                this.input.reset();
                int markerReadResult = this.input.read(this.fileMarkerBuffer, 0, this.fileMarkerBuffer.length);
                this.input.reset();
                if (markerReadResult < this.fileMarkerBuffer.length || !this.fileMarker.equals(new String(this.fileMarkerBuffer))) {
                    return this.input.read();
                }
                return -1;
            }
            return result;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.endSeen) {
                return -1;
            }
            this.input.mark(length + this.markerBytes.length + 10);
            int dataSeen = this.input.read(buffer, offset, length);
            byte[] extraReadBuffer = null;
            int extraActualRead = -1;
            for (int i = offset; i < offset + dataSeen; ++i) {
                if (buffer[i] != this.markerBytes[0]) continue;
                boolean mismatch = false;
                for (int j = 1; j < Math.min(this.markerBytes.length, offset + dataSeen - i); ++j) {
                    if (buffer[i + j] == this.markerBytes[j]) continue;
                    mismatch = true;
                    break;
                }
                if (mismatch) continue;
                int uncheckedMarkerCharCount = this.markerBytes.length - (offset + dataSeen - i);
                if (uncheckedMarkerCharCount > 0) {
                    if (extraReadBuffer == null) {
                        extraReadBuffer = new byte[this.markerBytes.length - 1];
                        extraActualRead = this.input.read(extraReadBuffer);
                    }
                    if (extraActualRead < uncheckedMarkerCharCount) {
                        this.input.reset();
                        return this.input.read(buffer, offset, length);
                    }
                    for (int j = 0; j < uncheckedMarkerCharCount; ++j) {
                        if (extraReadBuffer[j] == this.markerBytes[this.markerBytes.length - uncheckedMarkerCharCount + j]) continue;
                        this.input.reset();
                        return this.input.read(buffer, offset, length);
                    }
                }
                this.input.reset();
                if (i == offset) {
                    return -1;
                }
                int result = this.input.read(buffer, offset, i - offset);
                return result;
            }
            return dataSeen;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public void close() throws IOException {
            if (this.endSeen) {
                this.input.close();
            }
        }

        String nextFileName() throws IOException {
            return this.nextFileName(MAXIMUM_HEADER_LINE_LENGTH);
        }

        private String nextFileName(int bufferSize) throws IOException {
            int i;
            int actualRead;
            byte[] buffer = new byte[bufferSize];
            this.input.mark(bufferSize + 1);
            int mostRecentRead = actualRead = this.input.read(buffer);
            while (actualRead < bufferSize && mostRecentRead > 0) {
                mostRecentRead = this.input.read(buffer, actualRead, bufferSize - actualRead);
                if (mostRecentRead <= 0) continue;
                actualRead += mostRecentRead;
            }
            if (actualRead < this.markerBytes.length) {
                this.input.reset();
                return null;
            }
            for (i = 0; i < this.markerBytes.length; ++i) {
                if (this.markerBytes[i] == buffer[i]) continue;
                this.input.reset();
                return null;
            }
            for (i = this.markerBytes.length; i < actualRead; ++i) {
                if (buffer[i] == this.endMarkerBytes[0]) {
                    this.input.reset();
                    if (this.input.read(buffer, 0, this.markerBytes.length) < this.markerBytes.length) {
                        throw new IOException("Can't reread bytes I've read before.");
                    }
                    if (this.input.read(buffer, 0, i - this.markerBytes.length) < i - this.markerBytes.length) {
                        throw new IOException("Can't reread bytes I've read before.");
                    }
                    if (this.input.read(this.fileEndMarkerBuffer) < this.fileEndMarkerBuffer.length) {
                        this.input.reset();
                        return null;
                    }
                    for (int j = 0; j < this.endMarkerBytes.length; ++j) {
                        if (this.endMarkerBytes[j] == this.fileEndMarkerBuffer[j]) continue;
                        this.input.reset();
                        return null;
                    }
                    return new String(buffer, 0, i - this.markerBytes.length);
                }
                if (buffer[i] != 10) continue;
                return null;
            }
            this.input.reset();
            if (actualRead < bufferSize) {
                return null;
            }
            return this.nextFileName(bufferSize * 2);
        }
    }
}

