/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.distcp2.CopyListing;
import org.apache.hadoop.tools.distcp2.DistCp;
import org.apache.hadoop.tools.distcp2.DistCpOptions;
import org.apache.hadoop.tools.distcp2.SimpleCopyListing;
import org.apache.hadoop.tools.distcp2.util.TestDistCpUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestIntegration {
    private static final Log LOG = LogFactory.getLog(TestIntegration.class);
    private static MiniDFSCluster miniDfsCluster = null;
    private static MiniMRCluster miniMrCluster = null;
    private static FileSystem fs;
    private static Path listFile;
    private static Path target;
    private static String root;

    private static JobConf getConf() {
        return miniMrCluster.createJobConf();
    }

    @BeforeClass
    public static void setup() {
        try {
            miniDfsCluster = new MiniDFSCluster(new Configuration(), 3, true, null);
            fs = miniDfsCluster.getFileSystem();
            String namenode = fs.getUri().toString();
            miniMrCluster = new MiniMRCluster(3, namenode, 1);
            listFile = new Path("target/tmp/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            target = new Path("target/tmp/target").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            root = new Path("target/tmp").makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            TestDistCpUtils.delete(fs, root);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
        }
    }

    @AfterClass
    public static void shutdown() throws IOException {
        miniMrCluster.shutdown();
        fs.close();
        miniDfsCluster.shutdown();
    }

    @Test(timeout=100000L)
    public void testSingleFileMissingTarget() {
        this.caseSingleFileMissingTarget(false);
        this.caseSingleFileMissingTarget(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileMissingTarget(boolean sync) {
        try {
            this.addEntries(listFile, "singlefile1/file1");
            this.createFiles("singlefile1/file1");
            this.runTest(listFile, target, sync);
            this.checkResult(target, 1, new String[0]);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test(timeout=100000L)
    public void testSingleFileTargetFile() {
        this.caseSingleFileTargetFile(false);
        this.caseSingleFileTargetFile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileTargetFile(boolean sync) {
        try {
            this.addEntries(listFile, "singlefile1/file1");
            this.createFiles("singlefile1/file1", "target");
            this.runTest(listFile, target, sync);
            this.checkResult(target, 1, new String[0]);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test(timeout=100000L)
    public void testSingleFileTargetDir() {
        this.caseSingleFileTargetDir(false);
        this.caseSingleFileTargetDir(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleFileTargetDir(boolean sync) {
        try {
            this.addEntries(listFile, "singlefile2/file2");
            this.createFiles("singlefile2/file2");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, sync);
            this.checkResult(target, 1, "file2");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test(timeout=100000L)
    public void testSingleDirTargetMissing() {
        this.caseSingleDirTargetMissing(false);
        this.caseSingleDirTargetMissing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseSingleDirTargetMissing(boolean sync) {
        try {
            this.addEntries(listFile, "singledir");
            this.mkdirs(root + "/singledir/dir1");
            this.runTest(listFile, target, sync);
            this.checkResult(target, 1, "dir1");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testSingleDirTargetPresent() {
        try {
            this.addEntries(listFile, "singledir");
            this.mkdirs(root + "/singledir/dir1");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, false);
            this.checkResult(target, 1, "singledir/dir1");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testUpdateSingleDirTargetPresent() {
        try {
            this.addEntries(listFile, "Usingledir");
            this.mkdirs(root + "/Usingledir/Udir1");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, true);
            this.checkResult(target, 1, "Udir1");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test(timeout=100000L)
    public void testMultiFileTargetPresent() {
        this.caseMultiFileTargetPresent(false);
        this.caseMultiFileTargetPresent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseMultiFileTargetPresent(boolean sync) {
        try {
            this.addEntries(listFile, "multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.mkdirs(target.toString());
            this.runTest(listFile, target, sync);
            this.checkResult(target, 3, "file3", "file4", "file5");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testCustomCopyListing() {
        try {
            this.addEntries(listFile, "multifile1/file3", "multifile1/file4", "multifile1/file5");
            this.createFiles("multifile1/file3", "multifile1/file4", "multifile1/file5");
            this.mkdirs(target.toString());
            JobConf conf = TestIntegration.getConf();
            try {
                conf.setClass("distcp.copy.listing.class", CustomCopyListing.class, CopyListing.class);
                DistCpOptions options = new DistCpOptions(Arrays.asList(new Path(root + "/" + "multifile1")), target);
                options.setSyncFolder(true);
                options.setDeleteMissing(false);
                options.setOverwrite(false);
                try {
                    new DistCp((Configuration)conf, options).execute();
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception encountered ", (Throwable)e);
                    throw new IOException(e);
                }
            }
            finally {
                conf.unset("distcp.copy.listing.class");
            }
            this.checkResult(target, 2, "file4", "file5");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    @Test(timeout=100000L)
    public void testMultiFileTargetMissing() {
        this.caseMultiFileTargetMissing(false);
        this.caseMultiFileTargetMissing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseMultiFileTargetMissing(boolean sync) {
        try {
            this.addEntries(listFile, "multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.runTest(listFile, target, sync);
            this.checkResult(target, 3, "file3", "file4", "file5");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testMultiDirTargetPresent() {
        try {
            this.addEntries(listFile, "multifile", "singledir");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.mkdirs(target.toString(), root + "/singledir/dir1");
            this.runTest(listFile, target, false);
            this.checkResult(target, 2, "multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir1");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testUpdateMultiDirTargetPresent() {
        try {
            this.addEntries(listFile, "Umultifile", "Usingledir");
            this.createFiles("Umultifile/Ufile3", "Umultifile/Ufile4", "Umultifile/Ufile5");
            this.mkdirs(target.toString(), root + "/Usingledir/Udir1");
            this.runTest(listFile, target, true);
            this.checkResult(target, 4, "Ufile3", "Ufile4", "Ufile5", "Udir1");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testMultiDirTargetMissing() {
        try {
            this.addEntries(listFile, "multifile", "singledir");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.mkdirs(root + "/singledir/dir1");
            this.runTest(listFile, target, false);
            this.checkResult(target, 2, "multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir1");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testUpdateMultiDirTargetMissing() {
        try {
            this.addEntries(listFile, "multifile", "singledir");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.mkdirs(root + "/singledir/dir1");
            this.runTest(listFile, target, true);
            this.checkResult(target, 4, "file3", "file4", "file5", "dir1");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testDeleteMissingInDestination() {
        try {
            this.addEntries(listFile, "srcdir");
            this.createFiles("srcdir/file1", "dstdir/file1", "dstdir/file2");
            Path target = new Path(root + "/dstdir");
            this.runTest(listFile, target, true, true, false);
            this.checkResult(target, 1, "file1");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testOverwrite() {
        byte[] contents1 = "contents1".getBytes();
        byte[] contents2 = "contents2".getBytes();
        Assert.assertEquals((long)contents1.length, (long)contents2.length);
        try {
            this.addEntries(listFile, "srcdir");
            this.createWithContents("srcdir/file1", contents1);
            this.createWithContents("dstdir/file1", contents2);
            Path target = new Path(root + "/dstdir");
            this.runTest(listFile, target, false, false, true);
            this.checkResult(target, 1, "file1");
            FSDataInputStream is = fs.open(new Path(root + "/dstdir/file1"));
            byte[] dstContents = new byte[contents1.length];
            is.readFully(dstContents);
            is.close();
            Assert.assertArrayEquals((byte[])contents1, (byte[])dstContents);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testGlobTargetMissingSingleLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, "*");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("singledir/dir2/file6");
            this.runTest(listFile, target, false);
            this.checkResult(target, 2, "multifile/file3", "multifile/file4", "multifile/file5", "singledir/dir2/file6");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while testing distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testUpdateGlobTargetMissingSingleLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, "*");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("singledir/dir2/file6");
            this.runTest(listFile, target, true);
            this.checkResult(target, 4, "file3", "file4", "file5", "dir2/file6");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testGlobTargetMissingMultiLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, "*/*");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("singledir1/dir3/file7", "singledir1/dir3/file8", "singledir1/dir3/file9");
            this.runTest(listFile, target, false);
            this.checkResult(target, 4, "file3", "file4", "file5", "dir3/file7", "dir3/file8", "dir3/file9");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testUpdateGlobTargetMissingMultiLevel() {
        try {
            Path listFile = new Path("target/tmp1/listing").makeQualified(fs.getUri(), fs.getWorkingDirectory());
            this.addEntries(listFile, "*/*");
            this.createFiles("multifile/file3", "multifile/file4", "multifile/file5");
            this.createFiles("singledir1/dir3/file7", "singledir1/dir3/file8", "singledir1/dir3/file9");
            this.runTest(listFile, target, true);
            this.checkResult(target, 6, "file3", "file4", "file5", "file7", "file8", "file9");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while running distcp", (Throwable)e);
            Assert.fail((String)"distcp failure");
        }
        finally {
            TestDistCpUtils.delete(fs, root);
            TestDistCpUtils.delete(fs, "target/tmp1");
        }
    }

    @Test(timeout=100000L)
    public void testCleanup() {
        try {
            Path sourcePath = new Path("noscheme:///file");
            ArrayList<Path> sources = new ArrayList<Path>();
            sources.add(sourcePath);
            DistCpOptions options = new DistCpOptions(sources, target);
            JobConf conf = TestIntegration.getConf();
            Path stagingDir = JobSubmissionFiles.getStagingDir((JobClient)new JobClient(conf), (Configuration)conf);
            stagingDir.getFileSystem((Configuration)conf).mkdirs(stagingDir);
            try {
                new DistCp((Configuration)conf, options).execute();
            }
            catch (Throwable t) {
                Assert.assertEquals((long)stagingDir.getFileSystem((Configuration)conf).listStatus(stagingDir).length, (long)0L);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)("testCleanup failed " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntries(Path listFile, String ... entries) throws IOException {
        FSDataOutputStream out = fs.create(listFile);
        try {
            for (String entry : entries) {
                out.write((root + "/" + entry).getBytes());
                out.write("\n".getBytes());
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(String ... entries) throws IOException {
        for (String entry : entries) {
            if (!entry.startsWith("hdfs://")) {
                entry = root + "/" + entry;
            }
            FSDataOutputStream out = fs.create(new Path(entry));
            try {
                out.write((root + "/" + entry).getBytes());
                out.write("\n".getBytes());
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWithContents(String entry, byte[] contents) throws IOException {
        FSDataOutputStream out = fs.create(new Path(root + "/" + entry));
        try {
            out.write(contents);
        }
        finally {
            out.close();
        }
    }

    private void mkdirs(String ... entries) throws IOException {
        for (String entry : entries) {
            fs.mkdirs(new Path(entry));
        }
    }

    private void runTest(Path listFile, Path target, boolean sync) throws IOException {
        this.runTest(listFile, target, sync, false, false);
    }

    private void runTest(Path listFile, Path target, boolean sync, boolean delete, boolean overwrite) throws IOException {
        DistCpOptions options = new DistCpOptions(listFile, target);
        options.setSyncFolder(sync);
        options.setDeleteMissing(delete);
        options.setOverwrite(overwrite);
        try {
            new DistCp((Configuration)TestIntegration.getConf(), options).execute();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void checkResult(Path target, int count, String ... relPaths) throws IOException {
        Assert.assertEquals((long)count, (long)fs.listStatus(target).length);
        if (relPaths == null || relPaths.length == 0) {
            Assert.assertTrue((String)target.toString(), (boolean)fs.exists(target));
            return;
        }
        for (String relPath : relPaths) {
            Assert.assertTrue((String)new Path(target, relPath).toString(), (boolean)fs.exists(new Path(target, relPath)));
        }
    }

    private static class CustomCopyListing
    extends SimpleCopyListing {
        public CustomCopyListing(Configuration configuration, Credentials credentials) {
            super(configuration, credentials);
        }

        protected boolean shouldCopy(Path path, DistCpOptions options) {
            return !path.getName().equals("file3");
        }
    }
}

