/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricCounterLong;
import org.apache.hadoop.metrics2.impl.MetricGaugeDouble;
import org.apache.hadoop.metrics2.impl.MetricGaugeLong;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.lib.AbstractMetricsSource;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.apache.hadoop.test.MoreAsserts;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMetricsSystemImpl {
    private static final Log LOG = LogFactory.getLog(TestMetricsSystemImpl.class);
    @Captor
    private ArgumentCaptor<MetricsRecord> r1;
    @Captor
    private ArgumentCaptor<MetricsRecord> r2;
    @Captor
    private ArgumentCaptor<MetricsRecord> r3;
    private static String hostname = MetricsSystemImpl.getHostname();

    @Test
    public void testInitFirst() throws Exception {
        new ConfigBuilder().add("default.period", 8).add("source.filter.class", "org.apache.hadoop.metrics2.filter.GlobFilter").add("test.*.source.filter.class", "${source.filter.class}").add("test.*.source.filter.exclude", "s1*").add("test.sink.sink3.source.filter.class", "${source.filter.class}").add("test.sink.sink3.source.filter.exclude", "s2*").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        TestSource s1 = (TestSource)ms.register("s1", "s1 desc", (MetricsSource)new TestSource("s1rec"));
        TestSource s2 = (TestSource)ms.register("s2", "s2 desc", (MetricsSource)new TestSource("s2rec"));
        TestSource s3 = (TestSource)ms.register("s3", "s3 desc", (MetricsSource)new TestSource("s3rec"));
        s1.s1.add(0L);
        s2.s1.add(0L);
        s3.s1.add(0L);
        MetricsSink sink1 = (MetricsSink)Mockito.mock(MetricsSink.class);
        MetricsSink sink2 = (MetricsSink)Mockito.mock(MetricsSink.class);
        MetricsSink sink3 = (MetricsSink)Mockito.mock(MetricsSink.class);
        ms.register("sink1", "sink1 desc", sink1);
        ms.register("sink2", "sink2 desc", sink2);
        ms.register("sink3", "sink3 desc", sink3);
        ms.publishMetricsNow();
        ms.stop();
        ms.shutdown();
        ((MetricsSink)Mockito.verify((Object)sink1, (VerificationMode)Mockito.times((int)3))).putMetrics((MetricsRecord)this.r1.capture());
        List mr1 = this.r1.getAllValues();
        ((MetricsSink)Mockito.verify((Object)sink2, (VerificationMode)Mockito.times((int)3))).putMetrics((MetricsRecord)this.r2.capture());
        List mr2 = this.r2.getAllValues();
        ((MetricsSink)Mockito.verify((Object)sink3, (VerificationMode)Mockito.times((int)2))).putMetrics((MetricsRecord)this.r3.capture());
        List mr3 = this.r3.getAllValues();
        TestMetricsSystemImpl.checkMetricsRecords(mr1, "s2rec");
        MoreAsserts.assertEquals("output", mr1, mr2);
        TestMetricsSystemImpl.checkMetricsRecords(mr3, "s3rec");
    }

    @Test
    public void testMultiThreadedPublish() throws Exception {
        new ConfigBuilder().add("*.period", 80).add("test.sink.Collector.queue.capacity", "20").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        final MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        int numThreads = 10;
        final CollectingSink sink = new CollectingSink(10);
        ms.registerSink("Collector", "Collector of values from all threads.", (MetricsSink)sink);
        final TestSource[] sources = new TestSource[10];
        Thread[] threads = new Thread[10];
        final String[] results = new String[10];
        final CyclicBarrier barrier1 = new CyclicBarrier(10);
        final CyclicBarrier barrier2 = new CyclicBarrier(10);
        for (int i = 0; i < 10; ++i) {
            sources[i] = (TestSource)ms.register("threadSource" + i, "A source of my threaded goodness.", (MetricsSource)new TestSource("threadSourceRec" + i));
            threads[i] = new Thread(new Runnable(){

                private boolean safeAwait(int mySource, CyclicBarrier barrier) {
                    try {
                        barrier1.await(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        results[mySource] = "Interrupted";
                        return false;
                    }
                    catch (BrokenBarrierException e) {
                        results[mySource] = "Broken Barrier";
                        return false;
                    }
                    catch (TimeoutException e) {
                        results[mySource] = "Timed out on barrier";
                        return false;
                    }
                    return true;
                }

                @Override
                public void run() {
                    int mySource = Integer.parseInt(Thread.currentThread().getName());
                    if (sink.collected[mySource].get() != 0L) {
                        results[mySource] = "Someone else collected my metric!";
                        return;
                    }
                    sources[mySource].g1.set(230L);
                    if (!this.safeAwait(mySource, barrier1)) {
                        return;
                    }
                    ms.publishMetricsNow();
                    if (!this.safeAwait(mySource, barrier2)) {
                        return;
                    }
                    if (sink.collected[mySource].get() != 230L) {
                        results[mySource] = "Metric not collected!";
                        return;
                    }
                    results[mySource] = "Passed";
                }
            }, "" + i);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        boolean pass = true;
        String allResults = "";
        for (String r : results) {
            allResults = allResults + r + "\n";
            pass = pass && r.equalsIgnoreCase("Passed");
        }
        Assert.assertTrue((String)allResults, (boolean)pass);
        ms.stop();
        ms.shutdown();
    }

    @Test
    public void testHangingSink() {
        new ConfigBuilder().add("*.period", 8).add("test.sink.hanging.retry.delay", "1").add("test.sink.hanging.retry.backoff", "1.01").add("test.sink.hanging.retry.count", "0").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        TestSource s = (TestSource)ms.register("s3", "s3 desc", (MetricsSource)new TestSource("s3rec"));
        s.c1.incr();
        HangingSink hanging = new HangingSink();
        ms.registerSink("hanging", "Hang the sink!", (MetricsSink)hanging);
        ms.publishMetricsNow();
        Assert.assertFalse((boolean)hanging.getInterrupted());
        ms.stop();
        ms.shutdown();
        Assert.assertTrue((boolean)hanging.getInterrupted());
        Assert.assertTrue((String)"The sink didn't get called after its first hang for subsequent records.", (boolean)hanging.getGotCalledSecondTime());
    }

    static void checkMetricsRecords(List<MetricsRecord> recs, String expected) {
        LOG.debug(recs);
        MetricsRecord r = recs.get(0);
        Assert.assertEquals((String)"name", (Object)expected, (Object)r.name());
        MoreAsserts.assertEquals("tags", new MetricsTag[]{new MetricsTag("context", "Metrics context", "test"), new MetricsTag("hostName", "Local hostname", hostname)}, r.tags());
        MoreAsserts.assertEquals("metrics", new Metric[]{new MetricCounterLong("c1", "c1 desc", 1L), new MetricGaugeLong("g1", "g1 desc", 2L), new MetricCounterLong("s1_num_ops", "Number of ops for s1 desc", 1L), new MetricGaugeDouble("s1_avg_time", "Average time for s1 desc", 0.0)}, r.metrics());
    }

    private static class TestSource
    extends AbstractMetricsSource {
        final MetricMutableCounterLong c1;
        final MetricMutableGaugeLong g1;
        final MetricMutableStat s1;

        TestSource(String name) {
            super(name);
            this.registry.setContext("test");
            this.c1 = this.registry.newCounter("c1", "c1 desc", 1L);
            this.g1 = this.registry.newGauge("g1", "g1 desc", 2L);
            this.s1 = this.registry.newStat("s1", "s1 desc", "ops", "time");
        }
    }

    private static class HangingSink
    implements MetricsSink {
        private volatile boolean interrupted;
        private boolean gotCalledSecondTime;
        private boolean firstTime = true;

        private HangingSink() {
        }

        public boolean getGotCalledSecondTime() {
            return this.gotCalledSecondTime;
        }

        public boolean getInterrupted() {
            return this.interrupted;
        }

        public void init(SubsetConfiguration conf) {
        }

        public void putMetrics(MetricsRecord record) {
            if (!this.firstTime) {
                this.gotCalledSecondTime = true;
                return;
            }
            this.firstTime = false;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                this.interrupted = true;
            }
        }

        public void flush() {
        }
    }

    private static class CollectingSink
    implements MetricsSink {
        private final AtomicLong[] collected;

        public CollectingSink(int capacity) {
            this.collected = new AtomicLong[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.collected[i] = new AtomicLong();
            }
        }

        public void init(SubsetConfiguration conf) {
        }

        public void putMetrics(MetricsRecord record) {
            String prefix = "threadSourceRec";
            if (record.name().startsWith("threadSourceRec")) {
                int recordNumber = Integer.parseInt(record.name().substring("threadSourceRec".length()));
                ArrayList<String> names = new ArrayList<String>();
                for (Metric m : record.metrics()) {
                    if (m.name().equalsIgnoreCase("g1")) {
                        this.collected[recordNumber].set(m.value().longValue());
                        return;
                    }
                    names.add(m.name());
                }
            }
        }

        public void flush() {
        }
    }
}

