/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTokenCache {
    private static final int NUM_OF_KEYS = 10;
    private static MiniMRCluster mrCluster;
    private static MiniDFSCluster dfsCluster;
    private static final Path TEST_DIR;
    private static final Path tokenFileName;
    private static int numSlaves;
    private static JobConf jConf;
    private static ObjectMapper mapper;
    private static Path p1;
    private static Path p2;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        dfsCluster = new MiniDFSCluster(conf, numSlaves, true, null);
        jConf = new JobConf(conf);
        mrCluster = new MiniMRCluster(0, 0, numSlaves, dfsCluster.getFileSystem().getUri().toString(), 1, null, null, null, jConf);
        TestTokenCache.createTokenFileJson();
        TestTokenCache.verifySecretKeysInJSONFile();
        dfsCluster.getNameNode().getNamesystem().getDelegationTokenSecretManager().startThreads();
        FileSystem fs = dfsCluster.getFileSystem();
        p1 = new Path("file1");
        p2 = new Path("file2");
        p1 = fs.makeQualified(p1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (mrCluster != null) {
            mrCluster.shutdown();
        }
        mrCluster = null;
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
        dfsCluster = null;
    }

    private static void createTokenFileJson() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            KeyGenerator kg = KeyGenerator.getInstance("HmacSHA1");
            for (int i = 0; i < 10; ++i) {
                SecretKeySpec key = (SecretKeySpec)kg.generateKey();
                byte[] enc_key = key.getEncoded();
                map.put("alias" + i, new String(Base64.encodeBase64((byte[])enc_key)));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        try {
            File p = new File(tokenFileName.getParent().toString());
            p.mkdirs();
            mapper.writeValue(new File(tokenFileName.toString()), map);
        }
        catch (Exception e) {
            System.out.println("failed with :" + e.getLocalizedMessage());
        }
    }

    private static void verifySecretKeysInJSONFile() throws IOException {
        Map map = (Map)mapper.readValue(new File(tokenFileName.toString()), Map.class);
        Assert.assertEquals((String)"didn't read JSON correctly", (long)map.size(), (long)10L);
    }

    @Test
    public void testTokenCache() throws IOException {
        jConf = mrCluster.createJobConf();
        NameNode nn = dfsCluster.getNameNode();
        URI nnUri = NameNode.getUri((InetSocketAddress)nn.getNameNodeAddress());
        jConf.set("mapreduce.job.hdfs-servers", nnUri + "," + nnUri.toString());
        jConf.set("mapreduce.jobtracker.kerberos.principal", "jt_id");
        String[] args = new String[]{"-tokenCacheFile", tokenFileName.toString(), "-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)jConf, (Tool)new MySleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with" + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        Assert.assertEquals((String)"dist job res is not 0", (long)res, (long)0L);
    }

    @Test
    public void testLocalJobTokenCache() throws NoSuchAlgorithmException, IOException {
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        jConf.set("mapreduce.job.credentials.json", tokenFileName.toString());
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)jConf, (Tool)new MySleepJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with" + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"local Job failed");
        }
        Assert.assertEquals((String)"local job res is not 0", (long)res, (long)0L);
    }

    @Test
    public void testGetTokensForNamenodes() throws IOException {
        FileSystem fs = dfsCluster.getFileSystem();
        Credentials credentials = new Credentials();
        TokenCache.obtainTokensForNamenodesInternal((Credentials)credentials, (Path[])new Path[]{p1, p2}, (Configuration)jConf);
        String fs_addr = fs.getCanonicalServiceName();
        Token nnt = TokenCache.getDelegationToken((Credentials)credentials, (String)fs_addr);
        Assert.assertNotNull((String)"Token for nn is null", (Object)nnt);
        Collection tns = credentials.getAllTokens();
        Assert.assertEquals((String)"number of tokens is not 1", (long)1L, (long)tns.size());
        boolean found = false;
        for (Token t : tns) {
            if (t.getKind().equals((Object)DelegationTokenIdentifier.HDFS_DELEGATION_KIND) && t.getService().equals((Object)new Text(fs_addr))) {
                found = true;
            }
            Assert.assertTrue((String)("didn't find token for " + p1), (boolean)found);
        }
    }

    @Test
    public void testGetTokensForUriWithoutAuth() throws IOException {
        FileSystem fs = dfsCluster.getFileSystem();
        HadoopArchives har = new HadoopArchives((Configuration)jConf);
        Path archivePath = new Path(fs.getHomeDirectory(), "tmp");
        String[] args = new String[]{"-archiveName", "foo1.har", "-p", fs.getHomeDirectory().toString(), "test", archivePath.toString()};
        try {
            int ret = ToolRunner.run((Tool)har, (String[])args);
        }
        catch (Exception e) {
            Assert.fail((String)"Could not create har file");
        }
        Path finalPath = new Path(archivePath, "foo1.har");
        Path filePath = new Path(finalPath, "test");
        Credentials credentials = new Credentials();
        TokenCache.obtainTokensForNamenodesInternal((Credentials)credentials, (Path[])new Path[]{finalPath}, (Configuration)jConf);
    }

    @Test
    public void testCleanUpTokenReferral() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapreduce.job.credentials.binary", "foo");
        TokenCache.cleanUpTokenReferral((Configuration)conf);
        Assert.assertNull((Object)conf.get("mapreduce.job.credentials.binary"));
    }

    static {
        TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"), "sleepTest");
        tokenFileName = new Path(TEST_DIR, "tokenFile.json");
        numSlaves = 1;
        mapper = new ObjectMapper();
    }

    static class MySleepJob
    extends SleepJob
    implements JobConfigurable {
        Credentials ts;

        MySleepJob() {
        }

        public void configure(JobConf job) {
            try {
                this.ts = job.getCredentials();
                Path p1 = new Path("file1");
                p1 = p1.getFileSystem((Configuration)job).makeQualified(p1);
                Credentials cred = new Credentials();
                TokenCache.obtainTokensForNamenodesInternal((Credentials)cred, (Path[])new Path[]{p1}, (Configuration)job);
                for (Token t : cred.getAllTokens()) {
                    this.ts.addToken(new Text("Hdfs"), t);
                }
            }
            catch (IOException e) {
                Assert.fail((String)("Exception " + e));
            }
        }

        public void map(IntWritable key, IntWritable value, OutputCollector<IntWritable, NullWritable> output, Reporter reporter) throws IOException {
            byte[] key1 = this.ts.getSecretKey(new Text("alias1"));
            Collection dts = this.ts.getAllTokens();
            int dts_size = 0;
            if (dts != null) {
                dts_size = dts.size();
            }
            if (dts.size() != 2) {
                throw new RuntimeException("tokens are not available");
            }
            if (key1 == null || this.ts == null || this.ts.numberOfSecretKeys() != 10) {
                throw new RuntimeException("secret keys are not available");
            }
            super.map(key, value, output, reporter);
        }

        public JobConf setupJobConf(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount) {
            JobConf job = super.setupJobConf(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount);
            job.setMapperClass(MySleepJob.class);
            return job;
        }
    }
}

