/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskTrackerVersionCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultVersionCheck() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf jtConf = new JobConf();
            mr = new MiniMRCluster(1, "file:///", 1, null, null, jtConf);
            TaskTracker tt = mr.getTaskTrackerRunner(0).getTaskTracker();
            String currBuildVersion = VersionInfo.getBuildVersion();
            String currVersion = VersionInfo.getVersion();
            Assert.assertTrue((boolean)tt.isPermittedVersion(currBuildVersion, currVersion));
            Assert.assertFalse((String)"We disallow different versions", (boolean)tt.isPermittedVersion(currBuildVersion + "x", currVersion + "x"));
            Assert.assertFalse((String)"We disallow different full versions with same version", (boolean)tt.isPermittedVersion(currBuildVersion + "x", currVersion));
            try {
                tt.isPermittedVersion(currBuildVersion, currVersion + "x");
                Assert.fail((String)"Matched full version with mismatched version");
            }
            catch (AssertionError ae) {
                // empty catch block
            }
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelaxedVersionCheck() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf jtConf = new JobConf();
            jtConf.setBoolean("hadoop.relaxed.worker.version.check", true);
            mr = new MiniMRCluster(1, "file:///", 1, null, null, jtConf);
            TaskTracker tt = mr.getTaskTrackerRunner(0).getTaskTracker();
            String currFullVersion = VersionInfo.getBuildVersion();
            String currVersion = VersionInfo.getVersion();
            Assert.assertTrue((boolean)tt.isPermittedVersion(currFullVersion, currVersion));
            Assert.assertFalse((String)"We dissallow different versions", (boolean)tt.isPermittedVersion(currFullVersion + "x", currVersion + "x"));
            Assert.assertTrue((String)"We allow different full versions with same version", (boolean)tt.isPermittedVersion(currFullVersion + "x", currVersion));
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoVersionCheck() throws IOException {
        MiniMRCluster mr = null;
        try {
            JobConf jtConf = new JobConf();
            jtConf.setBoolean("hadoop.skip.worker.version.check", true);
            mr = new MiniMRCluster(1, "file:///", 1, null, null, jtConf);
            TaskTracker tt = mr.getTaskTrackerRunner(0).getTaskTracker();
            String currFullVersion = VersionInfo.getBuildVersion();
            String currVersion = VersionInfo.getVersion();
            Assert.assertTrue((boolean)tt.isPermittedVersion(currFullVersion, currVersion));
            Assert.assertTrue((boolean)tt.isPermittedVersion(currFullVersion + "x", currVersion + "x"));
            Assert.assertTrue((boolean)tt.isPermittedVersion(currFullVersion + "x", currVersion));
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

